/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.explain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.IdsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupRequest;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupResponse;
import org.opensearch.indexmanagement.rollup.action.explain.TransportExplainRollupAction;
import org.opensearch.indexmanagement.rollup.model.ExplainRollup;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0015*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/rollup/action/explain/TransportExplainRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/explain/ExplainRollupRequest;", "Lorg/opensearch/indexmanagement/rollup/action/explain/ExplainRollupResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nTransportExplainRollupAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportExplainRollupAction.kt\norg/opensearch/indexmanagement/rollup/action/explain/TransportExplainRollupAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n766#2:148\n857#2,2:149\n1549#2:151\n1620#2,3:152\n1855#2,2:155\n*S KotlinDebug\n*F\n+ 1 TransportExplainRollupAction.kt\norg/opensearch/indexmanagement/rollup/action/explain/TransportExplainRollupAction\n*L\n69#1:148\n69#1:149,2\n69#1:151\n69#1:152,3\n72#1:155,2\n*E\n"})
public final class TransportExplainRollupAction
extends HandledTransportAction<ExplainRollupRequest, ExplainRollupResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportExplainRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        super("cluster:admin/opendistro/rollup/explain", transportService, actionFilters, ExplainRollupRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportExplainRollupAction._init_$lambda$0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doExecute(@NotNull Task task, @NotNull ExplainRollupRequest request, @NotNull ActionListener<ExplainRollupResponse> actionListener) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        List<String> ids = request.getRollupIDs();
        Iterable $this$filter$iv = ids;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, null));
        }
        Map idsToExplain = MapsKt.toMap((Iterable)((List)destination$iv$iv), (Map)new LinkedHashMap());
        BoolQueryBuilder $this$doExecute_u24lambda_u244 = $i$f$map = new BoolQueryBuilder().minimumShouldMatch(1);
        boolean bl = false;
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            $this$doExecute_u24lambda_u244.should((QueryBuilder)new WildcardQueryBuilder("rollup.rollup_id.keyword", "*" + it2 + "*"));
        }
        BoolQueryBuilder queryBuilder = $i$f$map;
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"queryBuilder");
        Boolean bl3 = this.filterByEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"filterByEnabled");
        SecurityUtils.Companion.addUserFilter(user, queryBuilder, bl3, "rollup.user");
        Object object = new String[]{".opendistro-ism-config"};
        SearchRequest searchRequest = new SearchRequest(object).source(new SearchSourceBuilder().size(10000).query((QueryBuilder)queryBuilder));
        object = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it3 = (ThreadContext.StoredContext)object;
            boolean bl4 = false;
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, actionListener, (Map<String, ExplainRollup>)idsToExplain, ids){
                final /* synthetic */ TransportExplainRollupAction this$0;
                final /* synthetic */ ActionListener<ExplainRollupResponse> $actionListener;
                final /* synthetic */ Map<String, ExplainRollup> $idsToExplain;
                final /* synthetic */ List<String> $ids;
                {
                    this.this$0 = $receiver;
                    this.$actionListener = $actionListener;
                    this.$idsToExplain = $idsToExplain;
                    this.$ids = $ids;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull SearchResponse response2) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    try {
                        void $this$forEach$iv;
                        SearchHit[] searchHitArray = response2.getHits().getHits();
                        Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"response.hits.hits");
                        Object[] objectArray = searchHitArray;
                        Map<String, ExplainRollup> map = this.$idsToExplain;
                        boolean $i$f$forEach = false;
                        for (void element$iv : $this$forEach$iv) {
                            SearchHit it = (SearchHit)element$iv;
                            boolean bl = false;
                            BytesReference bytesReference = it.getSourceRef();
                            Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"it.sourceRef");
                            XContentParser xContentParser = OpenSearchExtensionsKt.contentParser(bytesReference);
                            String string = it.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                            Rollup rollup2 = (Rollup)OpenSearchExtensionsKt.parseWithType(xContentParser, string, it.getSeqNo(), it.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

                                @NotNull
                                public final Rollup invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
                                }
                            });
                            map.put(rollup2.getId(), new ExplainRollup(rollup2.getMetadataID(), null, 2, null));
                        }
                    }
                    catch (Exception e) {
                        TransportExplainRollupAction.access$getLog$p(this.this$0).error("Failed to parse explain response", (Throwable)e);
                        this.$actionListener.onFailure(e);
                        return;
                    }
                    Iterable $this$mapNotNull$iv = this.$idsToExplain.values();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        ExplainRollup it = (ExplainRollup)element$iv$iv;
                        boolean bl2 = false;
                        ExplainRollup explainRollup = it;
                        if ((explainRollup != null ? explainRollup.getMetadataID() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List metadataIds = (List)destination$iv$iv;
                    String[] stringArray = new String[]{".opendistro-ism-config"};
                    SearchRequest searchRequest = new SearchRequest(stringArray);
                    Collection $this$toTypedArray$iv = metadataIds;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    stringArray = thisCollection$iv.toArray(new String[0]);
                    SearchRequest metadataSearchRequest = searchRequest.source(new SearchSourceBuilder().size(10000).query((QueryBuilder)new IdsQueryBuilder().addIds(Arrays.copyOf(stringArray, stringArray.length))));
                    this.this$0.getClient().search(metadataSearchRequest, (ActionListener)new ActionListener<SearchResponse>(this.$actionListener, this.$idsToExplain, this.this$0){
                        final /* synthetic */ ActionListener<ExplainRollupResponse> $actionListener;
                        final /* synthetic */ Map<String, ExplainRollup> $idsToExplain;
                        final /* synthetic */ TransportExplainRollupAction this$0;
                        {
                            this.$actionListener = $actionListener;
                            this.$idsToExplain = $idsToExplain;
                            this.this$0 = $receiver;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onResponse(@NotNull SearchResponse response2) {
                            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                            try {
                                void $this$forEach$iv;
                                SearchHit[] searchHitArray = response2.getHits().getHits();
                                Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"response.hits.hits");
                                Object[] objectArray = searchHitArray;
                                Map<String, ExplainRollup> map = this.$idsToExplain;
                                boolean $i$f$forEach = false;
                                for (void element$iv : $this$forEach$iv) {
                                    SearchHit it = (SearchHit)element$iv;
                                    boolean bl = false;
                                    BytesReference bytesReference = it.getSourceRef();
                                    Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"it.sourceRef");
                                    XContentParser xContentParser = OpenSearchExtensionsKt.contentParser(bytesReference);
                                    String string = it.getId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                                    RollupMetadata metadata2 = (RollupMetadata)OpenSearchExtensionsKt.parseWithType(xContentParser, string, it.getSeqNo(), it.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, RollupMetadata>((Object)RollupMetadata.Companion){

                                        @NotNull
                                        public final RollupMetadata invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                            return ((RollupMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
                                        }
                                    });
                                    map.computeIfPresent(metadata2.getRollupID(), (arg_0, arg_1) -> doExecute.1.onResponse.2.onResponse$lambda$1$lambda$0((Function2)new Function2<String, ExplainRollup, ExplainRollup>(metadata2){
                                        final /* synthetic */ RollupMetadata $metadata;
                                        {
                                            this.$metadata = $metadata;
                                            super(2);
                                        }

                                        @Nullable
                                        public final ExplainRollup invoke(@NotNull String string, @NotNull ExplainRollup explainRollup) {
                                            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                                            Intrinsics.checkNotNullParameter((Object)explainRollup, (String)"explainRollup");
                                            return ExplainRollup.copy$default(explainRollup, null, this.$metadata, 1, null);
                                        }
                                    }, arg_0, arg_1));
                                }
                                this.$actionListener.onResponse((Object)((Object)new ExplainRollupResponse(MapsKt.toMap(this.$idsToExplain))));
                            }
                            catch (Exception e) {
                                TransportExplainRollupAction.access$getLog$p(this.this$0).error("Failed to parse rollup metadata", (Throwable)e);
                                this.$actionListener.onFailure(e);
                                return;
                            }
                        }

                        public void onFailure(@NotNull Exception e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            TransportExplainRollupAction.access$getLog$p(this.this$0).error("Failed to search rollup metadata", (Throwable)e);
                            if (e instanceof RemoteTransportException) {
                                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                this.$actionListener.onFailure((Exception)throwable);
                            } else {
                                this.$actionListener.onFailure(e);
                            }
                        }

                        private static final ExplainRollup onResponse$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (ExplainRollup)$tmp0.invoke(p0, p1);
                        }
                    });
                }

                /*
                 * WARNING - void declaration
                 */
                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TransportExplainRollupAction.access$getLog$p(this.this$0).error("Failed to search for rollups", (Throwable)e);
                    Exception exception = e;
                    if (exception instanceof ResourceNotFoundException) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String it;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = this.$ids;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (String)element$iv$iv;
                            boolean bl = false;
                            if (!(!StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(TuplesKt.to((Object)it, null));
                        }
                        Map nonWildcardIds = MapsKt.toMap((Iterable)((List)destination$iv$iv), (Map)new LinkedHashMap<K, V>());
                        this.$actionListener.onResponse((Object)((Object)new ExplainRollupResponse(nonWildcardIds)));
                    } else if (exception instanceof RemoteTransportException) {
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        this.$actionListener.onFailure((Exception)throwable);
                    } else {
                        this.$actionListener.onFailure(e);
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda$0(TransportExplainRollupAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ Logger access$getLog$p(TransportExplainRollupAction $this) {
        return $this.log;
    }
}

