/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.indexmanagement.rollup.model.Rollup;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "Lorg/opensearch/action/index/IndexRequest;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;)V", "getRollup", "()Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "setRollup", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;)V", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "opensearch-index-management"})
public final class IndexRollupRequest
extends IndexRequest {
    @NotNull
    private Rollup rollup;

    @NotNull
    public final Rollup getRollup() {
        return this.rollup;
    }

    public final void setRollup(@NotNull Rollup rollup2) {
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"<set-?>");
        this.rollup = rollup2;
    }

    public IndexRollupRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        super(sin);
        this.rollup = new Rollup(sin);
        super.setRefreshPolicy(WriteRequest.RefreshPolicy.readFrom((StreamInput)sin));
    }

    public IndexRollupRequest(@NotNull Rollup rollup2, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.rollup = rollup2;
        if (rollup2.getSeqNo() == -2L || rollup2.getPrimaryTerm() == 0L) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else {
            this.setIfSeqNo(rollup2.getSeqNo()).setIfPrimaryTerm(rollup2.getPrimaryTerm());
        }
        super.setRefreshPolicy(refreshPolicy);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (StringsKt.isBlank((CharSequence)this.rollup.getId())) {
            validationException = ValidateActions.addValidationError((String)"rollupID is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        this.rollup.writeTo(out);
        this.getRefreshPolicy().writeTo(out);
    }
}

