/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.engine.states.deletion;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.GetSnapshotsResult;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.State;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.deletion.DeletingState;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J2\u0010\u001a\u001a\u00020\b2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/deletion/DeletingState;", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/State;", "()V", "continuous", "", "getContinuous", "()Z", "execute", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "context", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "filterByDeleteCondition", "", "", "snapshots", "Lorg/opensearch/snapshots/SnapshotInfo;", "deleteCondition", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "log", "Lorg/apache/logging/log4j/Logger;", "getDeleteSnapshotErrorMessage", "snapshotNames", "getSnapshotDeletionStartedMessage", "getSnapshotsErrorMessage", "getSnapshotsMissingMessage", "handleException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "snapshotsToDelete", "metadataBuilder", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "offSetThresholdCount", "", "count", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nDeletingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeletingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/deletion/DeletingState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n766#2:157\n857#2,2:158\n1045#2:162\n1549#2:164\n1620#2,3:165\n37#3,2:160\n1#4:163\n*S KotlinDebug\n*F\n+ 1 DeletingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/deletion/DeletingState\n*L\n63#1:157\n63#1:158,2\n123#1:162\n148#1:164\n148#1:165,3\n70#1:160,2\n*E\n"})
public final class DeletingState
implements State {
    @NotNull
    public static final DeletingState INSTANCE = new DeletingState();
    private static final boolean continuous;

    private DeletingState() {
    }

    @Override
    public boolean getContinuous() {
        return continuous;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull SMStateMachine var1_1, @NotNull Continuation<? super SMResult> var2_2) {
        if (!(var2_2 instanceof execute.1)) ** GOTO lbl-1000
        var22_3 = var2_2;
        if ((var22_3.label & -2147483648) != 0) {
            var22_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DeletingState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((SMStateMachine)null, (Continuation<? super SMResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                client = context.getClient();
                job = context.getJob();
                metadata = context.getMetadata();
                log = context.getLog();
                metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.DELETION);
                if (job.getDeletion() == null) {
                    log.warn("Policy deletion config becomes null before trying to delete old snapshots. Reset.");
                    return new SMResult.Fail(metadataBuilder.resetDeletion(), WorkflowType.DELETION, Boxing.boxBoolean((boolean)true));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = client;
                $continuation.L$2 = job;
                $continuation.L$3 = log;
                $continuation.label = 1;
                v0 = SMUtilsKt.getSnapshots(client, job, job.getPolicyName() + "*", metadataBuilder, log, this.getSnapshotsMissingMessage(), this.getSnapshotsErrorMessage(), (Continuation<? super GetSnapshotsResult>)$continuation);
                if (v0 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                log = (Logger)$continuation.L$3;
                job = (SMPolicy)$continuation.L$2;
                client = (Client)$continuation.L$1;
                this = (DeletingState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                getSnapshotsRes = (GetSnapshotsResult)v0;
                metadataBuilder = getSnapshotsRes.getMetadataBuilder();
                if (getSnapshotsRes.getFailed()) {
                    return new SMResult.Fail(metadataBuilder, WorkflowType.DELETION, null, 4, null);
                }
                getSnapshots = getSnapshotsRes.getSnapshots();
                var11_13 = getSnapshots;
                var20_16 = this;
                $i$f$filter = false;
                var13_20 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SnapshotInfo)element$iv$iv;
                    $i$a$-filter-DeletingState$execute$2 = false;
                    if (!(it.state() != SnapshotState.IN_PROGRESS)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                snapshotsToDelete = var20_16.filterByDeleteCondition((List)destination$iv$iv, job.getDeletion().getCondition(), log);
                if (!(((Collection)snapshotsToDelete).isEmpty() == false)) ** GOTO lbl96
                $i$f$filter = job.getSnapshotConfig().get("repository");
                Intrinsics.checkNotNull((Object)$i$f$filter, (String)"null cannot be cast to non-null type kotlin.String");
                v1 = (String)$i$f$filter;
                $this$toTypedArray$iv = snapshotsToDelete;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                $i$f$filter = thisCollection$iv.toArray(new String[0]);
                req = new DeleteSnapshotRequest(v1, Arrays.copyOf($i$f$filter, ((String[])$i$f$filter).length));
                $i$f$filter = client.admin().cluster();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter, (String)"client.admin().cluster()");
                $continuation.L$0 = this;
                $continuation.L$1 = log;
                $continuation.L$2 = metadataBuilder;
                $continuation.L$3 = snapshotsToDelete;
                $continuation.label = 2;
                v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$i$f$filter, (Function2)new Function2<ClusterAdminClient, ActionListener<AcknowledgedResponse>, Unit>(req){
                    final /* synthetic */ DeleteSnapshotRequest $req;
                    {
                        this.$req = $req;
                        super(2);
                    }

                    public final void invoke(@NotNull ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.deleteSnapshot(this.$req, it);
                    }
                }, $continuation);
                ** if (v2 != var23_5) goto lbl76
lbl75:
                // 1 sources

                return var23_5;
lbl76:
                // 1 sources

                ** GOTO lbl86
            }
            case 2: {
                snapshotsToDelete = (List<String>)$continuation.L$3;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$2;
                log = (Logger)$continuation.L$1;
                this = (DeletingState)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl86:
                    // 2 sources

                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.IN_PROGRESS, false, this.getSnapshotDeletionStartedMessage(snapshotsToDelete), false, null, null, 58, null).setDeletionStarted(snapshotsToDelete);
                }
                catch (RemoteTransportException ex) {
                    v3 = ExceptionsHelper.unwrapCause((Throwable)ex);
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    unwrappedException = (Exception)v3;
                    return this.handleException(unwrappedException, snapshotsToDelete, metadataBuilder, log);
                }
                catch (Exception ex) {
                    return this.handleException(ex, snapshotsToDelete, metadataBuilder, log);
                }
lbl96:
                // 2 sources

                return new SMResult.Next(metadataBuilder);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SMResult handleException(Exception ex, List<String> snapshotsToDelete, SMMetadata.Builder metadataBuilder, Logger log) {
        if (ex instanceof ConcurrentSnapshotExecutionException) {
            log.error("Concurrent snapshot exception happened, retrying...", (Throwable)ex);
            SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, "Concurrent snapshot exception happened, retrying...", false, null, null, 58, null);
            return new SMResult.Stay(metadataBuilder);
        }
        log.error(this.getDeleteSnapshotErrorMessage(snapshotsToDelete), (Throwable)ex);
        SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, this.getDeleteSnapshotErrorMessage(snapshotsToDelete), false, ex, null, 42, null);
        return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION, null, 4, null);
    }

    private final String getSnapshotDeletionStartedMessage(List<String> snapshotNames) {
        return "Snapshots " + snapshotNames + " deletion has been started and waiting for completion.";
    }

    private final String getSnapshotsMissingMessage() {
        return "No snapshots found under policy while getting snapshots to decide which snapshots to delete.";
    }

    private final String getSnapshotsErrorMessage() {
        return "Caught exception while getting snapshots to decide which snapshots to delete.";
    }

    private final String getDeleteSnapshotErrorMessage(List<String> snapshotNames) {
        return "Caught exception while deleting snapshot " + snapshotNames + ".";
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> filterByDeleteCondition(List<SnapshotInfo> snapshots, SMPolicy.DeleteCondition deleteCondition, Logger log) {
        void $this$mapTo$iv$iv;
        log.debug("Filter by delete condition: snapshotInfos " + snapshots);
        Iterable $this$sortedBy$iv = snapshots;
        boolean $i$f$sortedBy = false;
        List snapshotInfos = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SnapshotInfo it = (SnapshotInfo)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.startTime());
                it = (SnapshotInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.startTime()));
            }
        });
        log.debug("snapshotInfos sorted " + snapshotInfos);
        int thresholdCount = 0;
        if (deleteCondition.getMaxAge() != null) {
            Object e;
            block6: {
                Instant timeThreshold = Instant.now().minusSeconds(deleteCondition.getMaxAge().seconds());
                log.debug("Time threshold: " + timeThreshold);
                List list = snapshotInfos;
                ListIterator listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    Object e2 = listIterator.previous();
                    SnapshotInfo it = (SnapshotInfo)e2;
                    boolean bl = false;
                    if (!Instant.ofEpochMilli(it.startTime()).isBefore(timeThreshold)) continue;
                    e = e2;
                    break block6;
                }
                e = null;
            }
            SnapshotInfo thresholdSnapshot = (SnapshotInfo)e;
            log.debug("ThresholdSnapshot: " + thresholdSnapshot);
            thresholdCount = CollectionsKt.indexOf((List)snapshotInfos, (Object)thresholdSnapshot) + 1;
            log.debug("ThresholdCount: " + thresholdCount);
            int minCount = deleteCondition.getMinCount();
            if (snapshotInfos.size() - thresholdCount < minCount) {
                thresholdCount = this.offSetThresholdCount(snapshotInfos.size() - minCount);
            }
        }
        Integer n = deleteCondition.getMaxCount();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (snapshotInfos.size() - thresholdCount > deleteCondition.getMaxCount()) {
                thresholdCount = snapshotInfos.size() - deleteCondition.getMaxCount();
            }
        }
        Iterable $this$map$iv = snapshotInfos.subList(0, thresholdCount);
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SnapshotInfo bl = (SnapshotInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.snapshotId().getName());
        }
        return (List)destination$iv$iv;
    }

    private final int offSetThresholdCount(int count) {
        if (count < 0) {
            return 0;
        }
        return count;
    }
}

