/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregatorSupplier;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregator;
import org.opensearch.geo.search.aggregations.bucket.geogrid.InternalGeoTileGrid;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.CellIdSource;
import org.opensearch.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellIdSource;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.GeoTileUtils;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.internal.SearchContext;

public class GeoTileGridAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int precision;
    private final int requiredSize;
    private final int shardSize;
    private final GeoBoundingBox geoBoundingBox;

    GeoTileGridAggregatorFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.precision = precision;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.geoBoundingBox = geoBoundingBox;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        InternalGeoTileGrid aggregation = new InternalGeoTileGrid(this.name, this.requiredSize, Collections.emptyList(), metadata);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata, (InternalAggregation)aggregation){
            final /* synthetic */ InternalAggregation val$aggregation;
            {
                this.val$aggregation = internalAggregation;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public InternalAggregation buildEmptyAggregation() {
                return this.val$aggregation;
            }
        };
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((GeoGridAggregatorSupplier)this.queryShardContext.getValuesSourceRegistry().getAggregator(GeoTileGridAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.config.getValuesSource(), this.precision, this.geoBoundingBox, this.requiredSize, this.shardSize, searchContext, parent, cardinality, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEOPOINT, (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata) -> {
            CellIdSource cellIdSource = new CellIdSource((ValuesSource.GeoPoint)valuesSource, precision, geoBoundingBox, GeoTileUtils::longEncode);
            return new GeoTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
        }, true);
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEO_SHAPE, (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata) -> {
            GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((ValuesSource.GeoShape)valuesSource, precision, geoBoundingBox, GeoTileUtils::encodeShape);
            return new GeoTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
        }, true);
    }
}

