/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.scan;

import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.response.DefaultQueryRangeFunctionResponseHandle;
import org.opensearch.sql.prometheus.functions.response.QueryRangeFunctionResponseHandle;
import org.opensearch.sql.prometheus.request.PrometheusQueryRequest;
import org.opensearch.sql.storage.TableScanOperator;

public class QueryRangeFunctionTableScanOperator
extends TableScanOperator {
    private final PrometheusClient prometheusClient;
    private final PrometheusQueryRequest request;
    private QueryRangeFunctionResponseHandle prometheusResponseHandle;
    private static final Logger LOG = LogManager.getLogger();

    public void open() {
        super.open();
        this.prometheusResponseHandle = AccessController.doPrivileged(() -> {
            try {
                JSONObject responseObject = this.prometheusClient.queryRange(this.request.getPromQl(), this.request.getStartTime(), this.request.getEndTime(), this.request.getStep());
                return new DefaultQueryRangeFunctionResponseHandle(responseObject);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(String.format("Error fetching data from prometheus server: %s", e.getMessage()));
            }
        });
    }

    public void close() {
        super.close();
    }

    public boolean hasNext() {
        return this.prometheusResponseHandle.hasNext();
    }

    public ExprValue next() {
        return this.prometheusResponseHandle.next();
    }

    public String explain() {
        return String.format(Locale.ROOT, "query_range(%s, %s, %s, %s)", this.request.getPromQl(), this.request.getStartTime(), this.request.getEndTime(), this.request.getStep());
    }

    public ExecutionEngine.Schema schema() {
        return this.prometheusResponseHandle.schema();
    }

    @Generated
    public QueryRangeFunctionTableScanOperator(PrometheusClient prometheusClient, PrometheusQueryRequest request) {
        this.prometheusClient = prometheusClient;
        this.request = request;
    }
}

