/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.ChainedAlertTrigger;
import org.opensearch.commons.alerting.model.CompositeInput;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.WorkflowInput;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ^2\u00020\u0001:\u0002^_B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0093\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0;J\t\u0010=\u001a\u00020\u0006H\u00c6\u0003J\t\u0010>\u001a\u00020\u0016H\u00c6\u0003J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018H\u00c6\u0003J\u0010\u0010B\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\t\u0010C\u001a\u00020\bH\u00c6\u0003J\t\u0010D\u001a\u00020\u0006H\u00c6\u0003J\t\u0010E\u001a\u00020\u000bH\u00c6\u0003J\t\u0010F\u001a\u00020\rH\u00c6\u0003J\t\u0010G\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010I\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u00ae\u0001\u0010K\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010LJ \u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000bH\u0002J\u0013\u0010S\u001a\u00020\u000b2\b\u0010T\u001a\u0004\u0018\u00010<H\u00d6\u0003J\u0018\u0010U\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010V\u001a\u00020\u0016H\u00d6\u0001J\t\u0010W\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010X\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020QH\u0016J\u0016\u0010Y\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020QJ\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0016R\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010'R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010)R\u0014\u00102\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010'R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006`"}, d2={"Lorg/opensearch/commons/alerting/model/Workflow;", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "id", "", "version", "", "name", "enabled", "", "schedule", "Lorg/opensearch/commons/alerting/model/Schedule;", "lastUpdateTime", "Ljava/time/Instant;", "enabledTime", "workflowType", "Lorg/opensearch/commons/alerting/model/Workflow$WorkflowType;", "user", "Lorg/opensearch/commons/authuser/User;", "schemaVersion", "", "inputs", "", "Lorg/opensearch/commons/alerting/model/WorkflowInput;", "owner", "triggers", "Lorg/opensearch/commons/alerting/model/Trigger;", "auditDelegateMonitorAlerts", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/commons/alerting/model/Workflow$WorkflowType;Lorg/opensearch/commons/authuser/User;ILjava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)V", "getAuditDelegateMonitorAlerts", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnabled", "()Z", "getEnabledTime", "()Ljava/time/Instant;", "getId", "()Ljava/lang/String;", "getInputs", "()Ljava/util/List;", "getLastUpdateTime", "getName", "getOwner", "getSchedule", "()Lorg/opensearch/commons/alerting/model/Schedule;", "getSchemaVersion", "()I", "getTriggers", "type", "getType", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getVersion", "()J", "getWorkflowType", "()Lorg/opensearch/commons/alerting/model/Workflow$WorkflowType;", "asTemplateArg", "", "", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/commons/alerting/model/Workflow$WorkflowType;Lorg/opensearch/commons/authuser/User;ILjava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)Lorg/opensearch/commons/alerting/model/Workflow;", "createXContentBuilder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "secure", "equals", "other", "fromDocument", "hashCode", "toString", "toXContent", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "WorkflowType", "common-utils"})
public final class Workflow
implements ScheduledJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    @NotNull
    private final String name;
    private final boolean enabled;
    @NotNull
    private final Schedule schedule;
    @NotNull
    private final Instant lastUpdateTime;
    @Nullable
    private final Instant enabledTime;
    @NotNull
    private final WorkflowType workflowType;
    @Nullable
    private final User user;
    private final int schemaVersion;
    @NotNull
    private final List<WorkflowInput> inputs;
    @Nullable
    private final String owner;
    @NotNull
    private final List<Trigger> triggers;
    @Nullable
    private final Boolean auditDelegateMonitorAlerts;
    @NotNull
    private final String type;
    @NotNull
    public static final String WORKFLOW_TYPE = "workflow";
    @NotNull
    public static final String TYPE_FIELD = "type";
    @NotNull
    public static final String WORKFLOW_TYPE_FIELD = "workflow_type";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    @NotNull
    public static final String INPUTS_FIELD = "inputs";
    @NotNull
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String TRIGGERS_FIELD = "triggers";
    @NotNull
    public static final String OWNER_FIELD = "owner";
    @NotNull
    public static final String AUDIT_DELEGATE_MONITOR_ALERTS_FIELD = "audit_delegate_monitor_alerts";
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(ScheduledJob.class, new ParseField("workflow", new String[0]), Workflow::XCONTENT_REGISTRY$lambda-6);
    @NotNull
    private static final String DEFAULT_OWNER = "alerting";

    public Workflow(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull WorkflowType workflowType, @Nullable User user, int schemaVersion, @NotNull List<? extends WorkflowInput> inputs, @Nullable String owner, @NotNull List<? extends Trigger> triggers, @Nullable Boolean auditDelegateMonitorAlerts) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)workflowType), (String)"workflowType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        this.id = id;
        this.version = version;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.workflowType = workflowType;
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.inputs = inputs;
        this.owner = owner;
        this.triggers = triggers;
        this.auditDelegateMonitorAlerts = auditDelegateMonitorAlerts;
        this.type = WORKFLOW_TYPE;
        if (this.getEnabled()) {
            if (this.getEnabledTime() == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
        } else if (!(this.getEnabledTime() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.inputs.size() <= 1)) {
            boolean $i$a$-require-Workflow$22 = false;
            String $i$a$-require-Workflow$22 = "Workflows can only have 1 search input.";
            throw new IllegalArgumentException($i$a$-require-Workflow$22.toString());
        }
        Iterable $this$forEach$iv = this.triggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Trigger trigger = (Trigger)element$iv;
            boolean bl = false;
            Workflow $this$lambda_u2d3_u24lambda_u2d2 = this;
            boolean bl2 = false;
            if (trigger instanceof ChainedAlertTrigger) continue;
            boolean bl3 = false;
            String string = "Incompatible trigger [" + trigger.getName() + "] for workflow. ";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Workflow(String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, WorkflowType workflowType, User user, int n, List list, String string3, List list2, Boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = 1L;
        }
        if ((n2 & 0x200) != 0) {
            n = 0;
        }
        if ((n2 & 0x800) != 0) {
            string3 = DEFAULT_OWNER;
        }
        if ((n2 & 0x2000) != 0) {
            bl2 = true;
        }
        this(string, l, string2, bl, schedule, instant, instant2, workflowType, user, n, list, string3, list2, bl2);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @NotNull
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    @NotNull
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Nullable
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    @NotNull
    public final WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<WorkflowInput> getInputs() {
        return this.inputs;
    }

    @Nullable
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final List<Trigger> getTriggers() {
        return this.triggers;
    }

    @Nullable
    public final Boolean getAuditDelegateMonitorAlerts() {
        return this.auditDelegateMonitorAlerts;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    public Workflow(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        long l = sin.readLong();
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string2 = object;
        boolean bl = sin.readBoolean();
        Schedule schedule = Schedule.Companion.readFrom(sin);
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        Object object2 = object;
        Instant instant = sin.readOptionalInstant();
        object = sin.readEnum(WorkflowType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readEnum(WorkflowType::class.java)");
        WorkflowType workflowType = (WorkflowType)((Object)object);
        User user = sin.readBoolean() ? new User(sin) : null;
        int n = sin.readInt();
        object = sin.readList(WorkflowInput.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList((WorkflowInput)::readFrom)");
        Object object3 = object;
        String string3 = sin.readOptionalString();
        object = sin.readList(Trigger.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList((Trigger)::readFrom)");
        this(string, l, string2, bl, schedule, (Instant)object2, instant, workflowType, user, n, (List<? extends WorkflowInput>)object3, string3, (List<? extends Trigger>)object, sin.readOptionalBoolean());
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_id", (Object)this.getId()), TuplesKt.to((Object)"_version", (Object)this.getVersion()), TuplesKt.to((Object)NAME_FIELD, (Object)this.getName()), TuplesKt.to((Object)ENABLED_FIELD, (Object)this.getEnabled())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, false);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, true);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, boolean secure) {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(this.getType());
        }
        builder.field(TYPE_FIELD, this.getType()).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(NAME_FIELD, this.getName()).field(WORKFLOW_TYPE_FIELD, (Object)this.workflowType);
        if (!secure) {
            IndexUtilsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        XContentBuilder xContentBuilder = builder.field(ENABLED_FIELD, this.getEnabled());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(ENABLED_FIELD, enabled)");
        Collection $this$toTypedArray$iv = this.inputs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        WorkflowInput[] workflowInputArray = thisCollection$iv.toArray(new WorkflowInput[0]);
        if (workflowInputArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$toTypedArray$iv = this.triggers;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Trigger[] triggerArray = thisCollection$iv.toArray(new Trigger[0]);
        if (triggerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        XContentBuilder xContentBuilder2 = IndexUtilsKt.optionalTimeField(xContentBuilder, ENABLED_TIME_FIELD, this.getEnabledTime()).field(SCHEDULE_FIELD, (ToXContent)this.getSchedule()).field(INPUTS_FIELD, (Object)workflowInputArray).field(TRIGGERS_FIELD, (Object)triggerArray);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.field(ENABLED_FI\u2026 triggers.toTypedArray())");
        IndexUtilsKt.optionalTimeField(xContentBuilder2, LAST_UPDATE_TIME_FIELD, this.getLastUpdateTime());
        builder.field(OWNER_FIELD, this.owner);
        if (this.auditDelegateMonitorAlerts != null) {
            builder.field(AUDIT_DELEGATE_MONITOR_ALERTS_FIELD, this.auditDelegateMonitorAlerts.booleanValue());
        }
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        xContentBuilder2 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endObject()");
        return xContentBuilder2;
    }

    @Override
    @NotNull
    public Workflow fromDocument(@NotNull String id, long version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Workflow.copy$default(this, id, version, null, false, null, null, null, null, null, 0, null, null, null, null, 16380, null);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        BaseModel it;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeLong(this.getVersion());
        out.writeString(this.getName());
        out.writeBoolean(this.getEnabled());
        if (this.getSchedule() instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.getSchedule().writeTo(out);
        out.writeInstant(this.getLastUpdateTime());
        out.writeOptionalInstant(this.getEnabledTime());
        out.writeEnum((Enum)this.workflowType);
        out.writeBoolean(this.user != null);
        User user = this.user;
        if (user != null) {
            user.writeTo(out);
        }
        out.writeInt(this.schemaVersion);
        out.writeVInt(this.inputs.size());
        Iterable $this$forEach$iv = this.inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WorkflowInput)element$iv;
            boolean bl = false;
            if (it instanceof CompositeInput) {
                out.writeEnum((Enum)WorkflowInput.Type.COMPOSITE_INPUT);
            }
            it.writeTo(out);
        }
        out.writeOptionalString(this.owner);
        out.writeVInt(this.triggers.size());
        $this$forEach$iv = this.triggers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Trigger)element$iv;
            boolean bl = false;
            if (!(it instanceof ChainedAlertTrigger)) {
                throw new IOException("Unsupported trigger type for workflow");
            }
            out.writeEnum((Enum)Trigger.Type.CHAINED_ALERT_TRIGGER);
            it.writeTo(out);
        }
        out.writeOptionalBoolean(this.auditDelegateMonitorAlerts);
    }

    @Override
    @NotNull
    public XContentBuilder toXContentWithType(@NotNull XContentBuilder builder) {
        return ScheduledJob.DefaultImpls.toXContentWithType(this, builder);
    }

    @NotNull
    public final String component1() {
        return this.getId();
    }

    public final long component2() {
        return this.getVersion();
    }

    @NotNull
    public final String component3() {
        return this.getName();
    }

    public final boolean component4() {
        return this.getEnabled();
    }

    @NotNull
    public final Schedule component5() {
        return this.getSchedule();
    }

    @NotNull
    public final Instant component6() {
        return this.getLastUpdateTime();
    }

    @Nullable
    public final Instant component7() {
        return this.getEnabledTime();
    }

    @NotNull
    public final WorkflowType component8() {
        return this.workflowType;
    }

    @Nullable
    public final User component9() {
        return this.user;
    }

    public final int component10() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<WorkflowInput> component11() {
        return this.inputs;
    }

    @Nullable
    public final String component12() {
        return this.owner;
    }

    @NotNull
    public final List<Trigger> component13() {
        return this.triggers;
    }

    @Nullable
    public final Boolean component14() {
        return this.auditDelegateMonitorAlerts;
    }

    @NotNull
    public final Workflow copy(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull WorkflowType workflowType, @Nullable User user, int schemaVersion, @NotNull List<? extends WorkflowInput> inputs, @Nullable String owner, @NotNull List<? extends Trigger> triggers, @Nullable Boolean auditDelegateMonitorAlerts) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)workflowType), (String)"workflowType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        return new Workflow(id, version, name, enabled, schedule, lastUpdateTime, enabledTime, workflowType, user, schemaVersion, inputs, owner, triggers, auditDelegateMonitorAlerts);
    }

    public static /* synthetic */ Workflow copy$default(Workflow workflow, String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, WorkflowType workflowType, User user, int n, List list, String string3, List list2, Boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = workflow.getId();
        }
        if ((n2 & 2) != 0) {
            l = workflow.getVersion();
        }
        if ((n2 & 4) != 0) {
            string2 = workflow.getName();
        }
        if ((n2 & 8) != 0) {
            bl = workflow.getEnabled();
        }
        if ((n2 & 0x10) != 0) {
            schedule = workflow.getSchedule();
        }
        if ((n2 & 0x20) != 0) {
            instant = workflow.getLastUpdateTime();
        }
        if ((n2 & 0x40) != 0) {
            instant2 = workflow.getEnabledTime();
        }
        if ((n2 & 0x80) != 0) {
            workflowType = workflow.workflowType;
        }
        if ((n2 & 0x100) != 0) {
            user = workflow.user;
        }
        if ((n2 & 0x200) != 0) {
            n = workflow.schemaVersion;
        }
        if ((n2 & 0x400) != 0) {
            list = workflow.inputs;
        }
        if ((n2 & 0x800) != 0) {
            string3 = workflow.owner;
        }
        if ((n2 & 0x1000) != 0) {
            list2 = workflow.triggers;
        }
        if ((n2 & 0x2000) != 0) {
            bl2 = workflow.auditDelegateMonitorAlerts;
        }
        return workflow.copy(string, l, string2, bl, schedule, instant, instant2, workflowType, user, n, list, string3, list2, bl2);
    }

    @NotNull
    public String toString() {
        return "Workflow(id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", enabled=" + this.getEnabled() + ", schedule=" + this.getSchedule() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", enabledTime=" + this.getEnabledTime() + ", workflowType=" + this.workflowType + ", user=" + this.user + ", schemaVersion=" + this.schemaVersion + ", inputs=" + this.inputs + ", owner=" + this.owner + ", triggers=" + this.triggers + ", auditDelegateMonitorAlerts=" + this.auditDelegateMonitorAlerts + ")";
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = result * 31 + Long.hashCode(this.getVersion());
        result = result * 31 + this.getName().hashCode();
        int n = this.getEnabled() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.getSchedule().hashCode();
        result = result * 31 + this.getLastUpdateTime().hashCode();
        result = result * 31 + (this.getEnabledTime() == null ? 0 : this.getEnabledTime().hashCode());
        result = result * 31 + this.workflowType.hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + ((Object)this.triggers).hashCode();
        result = result * 31 + (this.auditDelegateMonitorAlerts == null ? 0 : ((Object)this.auditDelegateMonitorAlerts).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Workflow)) {
            return false;
        }
        Workflow workflow = (Workflow)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)workflow.getId())) {
            return false;
        }
        if (this.getVersion() != workflow.getVersion()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)workflow.getName())) {
            return false;
        }
        if (this.getEnabled() != workflow.getEnabled()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getSchedule(), (Object)workflow.getSchedule())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getLastUpdateTime(), (Object)workflow.getLastUpdateTime())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEnabledTime(), (Object)workflow.getEnabledTime())) {
            return false;
        }
        if (this.workflowType != workflow.workflowType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)workflow.user)) {
            return false;
        }
        if (this.schemaVersion != workflow.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, workflow.inputs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)workflow.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.triggers, workflow.triggers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.auditDelegateMonitorAlerts, (Object)workflow.auditDelegateMonitorAlerts);
    }

    private static final Workflow XCONTENT_REGISTRY$lambda-6(XContentParser it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return org.opensearch.commons.alerting.model.Workflow$Companion.parse$default(Companion, it, null, 0L, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Workflow parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @Nullable
    public static final Workflow readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Workflow parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Workflow parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/opensearch/commons/alerting/model/Workflow$WorkflowType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "toString", "COMPOSITE", "common-utils"})
    public static final class WorkflowType
    extends Enum<WorkflowType> {
        @NotNull
        private final String value;
        public static final /* enum */ WorkflowType COMPOSITE = new WorkflowType("composite");
        private static final /* synthetic */ WorkflowType[] $VALUES;

        private WorkflowType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.value;
        }

        public static WorkflowType[] values() {
            return (WorkflowType[])$VALUES.clone();
        }

        public static WorkflowType valueOf(String value) {
            return Enum.valueOf(WorkflowType.class, value);
        }

        static {
            $VALUES = workflowTypeArray = new WorkflowType[]{WorkflowType.COMPOSITE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020\rH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\"H\u0007J,\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010$2\u0018\u0010%\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/opensearch/commons/alerting/model/Workflow$Companion;", "", "()V", "AUDIT_DELEGATE_MONITOR_ALERTS_FIELD", "", "DEFAULT_OWNER", "ENABLED_FIELD", "ENABLED_TIME_FIELD", "INPUTS_FIELD", "LAST_UPDATE_TIME_FIELD", "NAME_FIELD", "NO_ID", "NO_VERSION", "", "OWNER_FIELD", "SCHEDULE_FIELD", "SCHEMA_VERSION_FIELD", "TRIGGERS_FIELD", "TYPE_FIELD", "USER_FIELD", "WORKFLOW_TYPE", "WORKFLOW_TYPE_FIELD", "XCONTENT_REGISTRY", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "parse", "Lorg/opensearch/commons/alerting/model/Workflow;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "version", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "suppressWarning", "", "map", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Workflow parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            String string;
            Object object;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String name = null;
            String workflowType = WorkflowType.COMPOSITE.toString();
            User user = null;
            Schedule schedule = null;
            Instant lastUpdateTime = null;
            Instant enabledTime = null;
            boolean enabled = true;
            int schemaVersion = 0;
            List inputs = new ArrayList();
            List triggers = new ArrayList();
            String owner = Workflow.DEFAULT_OWNER;
            boolean auditDelegateMonitorAlerts = true;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block28: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                block52: {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    object = fieldName;
                    if (object == null) break block52;
                    int n = -1;
                    switch (((String)object).hashCode()) {
                        case 1684719674: {
                            if (((String)object).equals(Workflow.SCHEMA_VERSION_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -1219796725: {
                            if (((String)object).equals(Workflow.ENABLED_TIME_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 106164915: {
                            if (((String)object).equals(Workflow.OWNER_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case -697920873: {
                            if (((String)object).equals(Workflow.SCHEDULE_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 2020321370: {
                            if (((String)object).equals(Workflow.LAST_UPDATE_TIME_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1183866391: {
                            if (((String)object).equals(Workflow.INPUTS_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 3373707: {
                            if (((String)object).equals(Workflow.NAME_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 1141993402: {
                            if (((String)object).equals(Workflow.WORKFLOW_TYPE_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case 1503093179: {
                            if (((String)object).equals(Workflow.TRIGGERS_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                        case 3599307: {
                            if (((String)object).equals(Workflow.USER_FIELD)) {
                                n = 10;
                            }
                            break;
                        }
                        case -1609594047: {
                            if (((String)object).equals(Workflow.ENABLED_FIELD)) {
                                n = 11;
                            }
                            break;
                        }
                        case -1475494222: {
                            if (((String)object).equals(Workflow.AUDIT_DELEGATE_MONITOR_ALERTS_FIELD)) {
                                n = 12;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            schemaVersion = xcp.intValue();
                            continue block28;
                        }
                        case 7: {
                            name = xcp.text();
                            continue block28;
                        }
                        case 8: {
                            void $this$mapTo$iv$iv;
                            string = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                            workflowType = string;
                            WorkflowType[] $this$map$iv = WorkflowType.values();
                            boolean $i$f$map = false;
                            WorkflowType[] workflowTypeArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                void var29_32 = item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getValue());
                            }
                            List allowedTypes = (List)destination$iv$iv;
                            if (allowedTypes.contains(workflowType)) continue block28;
                            throw new IllegalStateException("Workflow type should be one of " + allowedTypes);
                        }
                        case 10: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse(xcp);
                            continue block28;
                        }
                        case 11: {
                            enabled = xcp.booleanValue();
                            continue block28;
                        }
                        case 4: {
                            schedule = Schedule.Companion.parse(xcp);
                            continue block28;
                        }
                        case 9: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                triggers.add(Trigger.Companion.parse(xcp));
                            }
                            continue block28;
                        }
                        case 6: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                WorkflowInput input = WorkflowInput.Companion.parse(xcp);
                                inputs.add(input);
                            }
                            continue block28;
                        }
                        case 2: {
                            enabledTime = IndexUtilsKt.instant(xcp);
                            continue block28;
                        }
                        case 5: {
                            lastUpdateTime = IndexUtilsKt.instant(xcp);
                            continue block28;
                        }
                        case 12: {
                            auditDelegateMonitorAlerts = xcp.booleanValue();
                            continue block28;
                        }
                        case 3: {
                            String string2;
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                                string2 = owner;
                            } else {
                                string = xcp.text();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                                string2 = string;
                            }
                            owner = string2;
                            continue block28;
                        }
                    }
                }
                xcp.skipChildren();
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            String string3 = id;
            long l = version;
            String string4 = name;
            if (string4 == null) {
                long l2 = l;
                String string5 = string3;
                boolean $i$a$-requireNotNull-Workflow$Companion$parse$32 = false;
                String string6 = "Workflow name is null";
                String string7 = string5;
                long l3 = l2;
                String $i$a$-requireNotNull-Workflow$Companion$parse$32 = string6;
                throw new IllegalArgumentException($i$a$-requireNotNull-Workflow$Companion$parse$32.toString());
            }
            boolean bl = enabled;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                boolean bl2 = bl;
                String string8 = string4;
                long l4 = l;
                String string9 = string3;
                boolean bl3 = false;
                String string10 = "Workflow schedule is null";
                String string11 = string9;
                long l5 = l4;
                String string12 = string8;
                boolean bl4 = bl2;
                String string13 = string10;
                throw new IllegalArgumentException(string13.toString());
            }
            Instant instant = lastUpdateTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Instant instant2 = instant;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"lastUpdateTime ?: Instant.now()");
            object = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
            string = workflowType.toUpperCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(locale)");
            Boolean bl5 = auditDelegateMonitorAlerts;
            List list = triggers;
            String string14 = owner;
            List list2 = CollectionsKt.toList((Iterable)inputs);
            int n = schemaVersion;
            User user2 = user;
            WorkflowType workflowType2 = WorkflowType.valueOf(string);
            Instant instant3 = enabledTime;
            Instant instant4 = instant2;
            Schedule schedule3 = schedule2;
            boolean bl6 = bl;
            String string15 = string4;
            long l6 = l;
            String string16 = string3;
            return new Workflow(string16, l6, string15, bl6, schedule3, instant4, instant3, workflowType2, user2, n, list2, string14, list, bl5);
        }

        public static /* synthetic */ Workflow parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Workflow.NO_ID;
            }
            if ((n & 4) != 0) {
                l = 1L;
            }
            return companion.parse(xContentParser, string, l);
        }

        @JvmStatic
        @Nullable
        public final Workflow readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Workflow(sin);
        }

        @NotNull
        public final Map<String, Object> suppressWarning(@Nullable Map<String, Object> map) {
            Map<String, Object> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            return TypeIntrinsics.asMutableMap(map2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Workflow parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.commons.alerting.model.Workflow$Companion.parse$default(this, xcp, id, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Workflow parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.commons.alerting.model.Workflow$Companion.parse$default(this, xcp, null, 0L, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

