/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.parameter.rcf;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;

@MLAlgoParameter(algorithms={FunctionName.BATCH_RCF})
public class BatchRCFParams
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.BATCH_RCF.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> BatchRCFParams.parse(it));
    public static final String NUMBER_OF_TREES = "number_of_trees";
    public static final String SHINGLE_SIZE = "shingle_size";
    public static final String SAMPLE_SIZE = "sample_size";
    public static final String OUTPUT_AFTER = "output_after";
    public static final String TRAINING_DATA_SIZE = "training_data_size";
    public static final String ANOMALY_SCORE_THRESHOLD = "anomaly_score_threshold";
    private Integer numberOfTrees;
    private Integer shingleSize;
    private Integer sampleSize;
    private Integer outputAfter;
    private Integer trainingDataSize;
    private Double anomalyScoreThreshold;

    public BatchRCFParams(Integer numberOfTrees, Integer shingleSize, Integer sampleSize, Integer outputAfter, Integer trainingDataSize, Double anomalyScoreThreshold) {
        this.numberOfTrees = numberOfTrees;
        this.shingleSize = shingleSize;
        this.sampleSize = sampleSize;
        this.outputAfter = outputAfter;
        this.trainingDataSize = trainingDataSize;
        this.anomalyScoreThreshold = anomalyScoreThreshold;
    }

    public BatchRCFParams(StreamInput in) throws IOException {
        this.numberOfTrees = in.readOptionalInt();
        this.shingleSize = in.readOptionalInt();
        this.sampleSize = in.readOptionalInt();
        this.outputAfter = in.readOptionalInt();
        this.trainingDataSize = in.readOptionalInt();
        this.anomalyScoreThreshold = in.readOptionalDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numberOfTrees);
        out.writeOptionalInt(this.shingleSize);
        out.writeOptionalInt(this.sampleSize);
        out.writeOptionalInt(this.outputAfter);
        out.writeOptionalInt(this.trainingDataSize);
        out.writeOptionalDouble(this.anomalyScoreThreshold);
    }

    public static BatchRCFParams parse(XContentParser parser) throws IOException {
        Integer numberOfTrees = null;
        Integer shingleSize = null;
        Integer sampleSize = null;
        Integer outputAfter = null;
        Integer trainingDataSize = null;
        Double anomalyScoreThreshold = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "number_of_trees": {
                    numberOfTrees = parser.intValue(false);
                    continue block16;
                }
                case "shingle_size": {
                    shingleSize = parser.intValue(false);
                    continue block16;
                }
                case "sample_size": {
                    sampleSize = parser.intValue(false);
                    continue block16;
                }
                case "output_after": {
                    outputAfter = parser.intValue(false);
                    continue block16;
                }
                case "training_data_size": {
                    trainingDataSize = parser.intValue(false);
                    continue block16;
                }
                case "anomaly_score_threshold": {
                    anomalyScoreThreshold = parser.doubleValue(false);
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new BatchRCFParams(numberOfTrees, shingleSize, sampleSize, outputAfter, trainingDataSize, anomalyScoreThreshold);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfTrees != null) {
            builder.field(NUMBER_OF_TREES, this.numberOfTrees);
        }
        if (this.shingleSize != null) {
            builder.field(SHINGLE_SIZE, this.shingleSize);
        }
        if (this.sampleSize != null) {
            builder.field(SAMPLE_SIZE, this.sampleSize);
        }
        if (this.outputAfter != null) {
            builder.field(OUTPUT_AFTER, this.outputAfter);
        }
        if (this.trainingDataSize != null) {
            builder.field(TRAINING_DATA_SIZE, this.trainingDataSize);
        }
        if (this.anomalyScoreThreshold != null) {
            builder.field(ANOMALY_SCORE_THRESHOLD, this.anomalyScoreThreshold);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static BatchRCFParamsBuilder builder() {
        return new BatchRCFParamsBuilder();
    }

    @Generated
    public Integer getNumberOfTrees() {
        return this.numberOfTrees;
    }

    @Generated
    public Integer getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @Generated
    public Integer getOutputAfter() {
        return this.outputAfter;
    }

    @Generated
    public Integer getTrainingDataSize() {
        return this.trainingDataSize;
    }

    @Generated
    public Double getAnomalyScoreThreshold() {
        return this.anomalyScoreThreshold;
    }

    @Generated
    public void setNumberOfTrees(Integer numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    @Generated
    public void setShingleSize(Integer shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Generated
    public void setOutputAfter(Integer outputAfter) {
        this.outputAfter = outputAfter;
    }

    @Generated
    public void setTrainingDataSize(Integer trainingDataSize) {
        this.trainingDataSize = trainingDataSize;
    }

    @Generated
    public void setAnomalyScoreThreshold(Double anomalyScoreThreshold) {
        this.anomalyScoreThreshold = anomalyScoreThreshold;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchRCFParams)) {
            return false;
        }
        BatchRCFParams other = (BatchRCFParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numberOfTrees = this.getNumberOfTrees();
        Integer other$numberOfTrees = other.getNumberOfTrees();
        if (this$numberOfTrees == null ? other$numberOfTrees != null : !((Object)this$numberOfTrees).equals(other$numberOfTrees)) {
            return false;
        }
        Integer this$shingleSize = this.getShingleSize();
        Integer other$shingleSize = other.getShingleSize();
        if (this$shingleSize == null ? other$shingleSize != null : !((Object)this$shingleSize).equals(other$shingleSize)) {
            return false;
        }
        Integer this$sampleSize = this.getSampleSize();
        Integer other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !((Object)this$sampleSize).equals(other$sampleSize)) {
            return false;
        }
        Integer this$outputAfter = this.getOutputAfter();
        Integer other$outputAfter = other.getOutputAfter();
        if (this$outputAfter == null ? other$outputAfter != null : !((Object)this$outputAfter).equals(other$outputAfter)) {
            return false;
        }
        Integer this$trainingDataSize = this.getTrainingDataSize();
        Integer other$trainingDataSize = other.getTrainingDataSize();
        if (this$trainingDataSize == null ? other$trainingDataSize != null : !((Object)this$trainingDataSize).equals(other$trainingDataSize)) {
            return false;
        }
        Double this$anomalyScoreThreshold = this.getAnomalyScoreThreshold();
        Double other$anomalyScoreThreshold = other.getAnomalyScoreThreshold();
        return !(this$anomalyScoreThreshold == null ? other$anomalyScoreThreshold != null : !((Object)this$anomalyScoreThreshold).equals(other$anomalyScoreThreshold));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BatchRCFParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numberOfTrees = this.getNumberOfTrees();
        result = result * 59 + ($numberOfTrees == null ? 43 : ((Object)$numberOfTrees).hashCode());
        Integer $shingleSize = this.getShingleSize();
        result = result * 59 + ($shingleSize == null ? 43 : ((Object)$shingleSize).hashCode());
        Integer $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : ((Object)$sampleSize).hashCode());
        Integer $outputAfter = this.getOutputAfter();
        result = result * 59 + ($outputAfter == null ? 43 : ((Object)$outputAfter).hashCode());
        Integer $trainingDataSize = this.getTrainingDataSize();
        result = result * 59 + ($trainingDataSize == null ? 43 : ((Object)$trainingDataSize).hashCode());
        Double $anomalyScoreThreshold = this.getAnomalyScoreThreshold();
        result = result * 59 + ($anomalyScoreThreshold == null ? 43 : ((Object)$anomalyScoreThreshold).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BatchRCFParams(numberOfTrees=" + this.getNumberOfTrees() + ", shingleSize=" + this.getShingleSize() + ", sampleSize=" + this.getSampleSize() + ", outputAfter=" + this.getOutputAfter() + ", trainingDataSize=" + this.getTrainingDataSize() + ", anomalyScoreThreshold=" + this.getAnomalyScoreThreshold() + ")";
    }

    @Generated
    public static class BatchRCFParamsBuilder {
        @Generated
        private Integer numberOfTrees;
        @Generated
        private Integer shingleSize;
        @Generated
        private Integer sampleSize;
        @Generated
        private Integer outputAfter;
        @Generated
        private Integer trainingDataSize;
        @Generated
        private Double anomalyScoreThreshold;

        @Generated
        BatchRCFParamsBuilder() {
        }

        @Generated
        public BatchRCFParamsBuilder numberOfTrees(Integer numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return this;
        }

        @Generated
        public BatchRCFParamsBuilder shingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        @Generated
        public BatchRCFParamsBuilder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        @Generated
        public BatchRCFParamsBuilder outputAfter(Integer outputAfter) {
            this.outputAfter = outputAfter;
            return this;
        }

        @Generated
        public BatchRCFParamsBuilder trainingDataSize(Integer trainingDataSize) {
            this.trainingDataSize = trainingDataSize;
            return this;
        }

        @Generated
        public BatchRCFParamsBuilder anomalyScoreThreshold(Double anomalyScoreThreshold) {
            this.anomalyScoreThreshold = anomalyScoreThreshold;
            return this;
        }

        @Generated
        public BatchRCFParams build() {
            return new BatchRCFParams(this.numberOfTrees, this.shingleSize, this.sampleSize, this.outputAfter, this.trainingDataSize, this.anomalyScoreThreshold);
        }

        @Generated
        public String toString() {
            return "BatchRCFParams.BatchRCFParamsBuilder(numberOfTrees=" + this.numberOfTrees + ", shingleSize=" + this.shingleSize + ", sampleSize=" + this.sampleSize + ", outputAfter=" + this.outputAfter + ", trainingDataSize=" + this.trainingDataSize + ", anomalyScoreThreshold=" + this.anomalyScoreThreshold + ")";
        }
    }
}

