/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.sync;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class MLSyncUpInput
implements Writeable {
    private boolean getDeployedModels;
    private Map<String, String[]> addedWorkerNodes;
    private Map<String, String[]> removedWorkerNodes;
    private Map<String, Set<String>> modelRoutingTable;
    private Map<String, Set<String>> runningDeployModelTasks;
    private boolean clearRoutingTable;
    private boolean syncRunningDeployModelTasks;
    private Map<String, Boolean> deployToAllNodes;

    public MLSyncUpInput(boolean getDeployedModels, Map<String, String[]> addedWorkerNodes, Map<String, String[]> removedWorkerNodes, Map<String, Set<String>> modelRoutingTable, Map<String, Set<String>> runningDeployModelTasks, Map<String, Boolean> deployToAllNodes, boolean clearRoutingTable, boolean syncRunningDeployModelTasks) {
        this.getDeployedModels = getDeployedModels;
        this.addedWorkerNodes = addedWorkerNodes;
        this.removedWorkerNodes = removedWorkerNodes;
        this.modelRoutingTable = modelRoutingTable;
        this.runningDeployModelTasks = runningDeployModelTasks;
        this.deployToAllNodes = deployToAllNodes;
        this.clearRoutingTable = clearRoutingTable;
        this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
    }

    public MLSyncUpInput() {
    }

    public MLSyncUpInput(StreamInput in) throws IOException {
        this.getDeployedModels = in.readBoolean();
        if (in.readBoolean()) {
            this.addedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.removedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.modelRoutingTable = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        if (in.readBoolean()) {
            this.runningDeployModelTasks = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        if (in.readBoolean()) {
            this.deployToAllNodes = in.readMap(StreamInput::readString, StreamInput::readOptionalBoolean);
        }
        this.clearRoutingTable = in.readBoolean();
        this.syncRunningDeployModelTasks = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.getDeployedModels);
        if (this.addedWorkerNodes != null && this.addedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.addedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.removedWorkerNodes != null && this.removedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.removedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelRoutingTable != null && this.modelRoutingTable.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelRoutingTable, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        if (this.runningDeployModelTasks != null && this.runningDeployModelTasks.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.runningDeployModelTasks, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        if (this.deployToAllNodes != null && this.deployToAllNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.deployToAllNodes, StreamOutput::writeString, StreamOutput::writeOptionalBoolean);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.clearRoutingTable);
        out.writeBoolean(this.syncRunningDeployModelTasks);
    }

    @Generated
    public static MLSyncUpInputBuilder builder() {
        return new MLSyncUpInputBuilder();
    }

    @Generated
    public boolean isGetDeployedModels() {
        return this.getDeployedModels;
    }

    @Generated
    public Map<String, String[]> getAddedWorkerNodes() {
        return this.addedWorkerNodes;
    }

    @Generated
    public Map<String, String[]> getRemovedWorkerNodes() {
        return this.removedWorkerNodes;
    }

    @Generated
    public Map<String, Set<String>> getModelRoutingTable() {
        return this.modelRoutingTable;
    }

    @Generated
    public Map<String, Set<String>> getRunningDeployModelTasks() {
        return this.runningDeployModelTasks;
    }

    @Generated
    public boolean isClearRoutingTable() {
        return this.clearRoutingTable;
    }

    @Generated
    public boolean isSyncRunningDeployModelTasks() {
        return this.syncRunningDeployModelTasks;
    }

    @Generated
    public Map<String, Boolean> getDeployToAllNodes() {
        return this.deployToAllNodes;
    }

    @Generated
    public void setGetDeployedModels(boolean getDeployedModels) {
        this.getDeployedModels = getDeployedModels;
    }

    @Generated
    public void setAddedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
        this.addedWorkerNodes = addedWorkerNodes;
    }

    @Generated
    public void setRemovedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
        this.removedWorkerNodes = removedWorkerNodes;
    }

    @Generated
    public void setModelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
        this.modelRoutingTable = modelRoutingTable;
    }

    @Generated
    public void setRunningDeployModelTasks(Map<String, Set<String>> runningDeployModelTasks) {
        this.runningDeployModelTasks = runningDeployModelTasks;
    }

    @Generated
    public void setClearRoutingTable(boolean clearRoutingTable) {
        this.clearRoutingTable = clearRoutingTable;
    }

    @Generated
    public void setSyncRunningDeployModelTasks(boolean syncRunningDeployModelTasks) {
        this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
    }

    @Generated
    public void setDeployToAllNodes(Map<String, Boolean> deployToAllNodes) {
        this.deployToAllNodes = deployToAllNodes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLSyncUpInput)) {
            return false;
        }
        MLSyncUpInput other = (MLSyncUpInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGetDeployedModels() != other.isGetDeployedModels()) {
            return false;
        }
        if (this.isClearRoutingTable() != other.isClearRoutingTable()) {
            return false;
        }
        if (this.isSyncRunningDeployModelTasks() != other.isSyncRunningDeployModelTasks()) {
            return false;
        }
        Map<String, String[]> this$addedWorkerNodes = this.getAddedWorkerNodes();
        Map<String, String[]> other$addedWorkerNodes = other.getAddedWorkerNodes();
        if (this$addedWorkerNodes == null ? other$addedWorkerNodes != null : !((Object)this$addedWorkerNodes).equals(other$addedWorkerNodes)) {
            return false;
        }
        Map<String, String[]> this$removedWorkerNodes = this.getRemovedWorkerNodes();
        Map<String, String[]> other$removedWorkerNodes = other.getRemovedWorkerNodes();
        if (this$removedWorkerNodes == null ? other$removedWorkerNodes != null : !((Object)this$removedWorkerNodes).equals(other$removedWorkerNodes)) {
            return false;
        }
        Map<String, Set<String>> this$modelRoutingTable = this.getModelRoutingTable();
        Map<String, Set<String>> other$modelRoutingTable = other.getModelRoutingTable();
        if (this$modelRoutingTable == null ? other$modelRoutingTable != null : !((Object)this$modelRoutingTable).equals(other$modelRoutingTable)) {
            return false;
        }
        Map<String, Set<String>> this$runningDeployModelTasks = this.getRunningDeployModelTasks();
        Map<String, Set<String>> other$runningDeployModelTasks = other.getRunningDeployModelTasks();
        if (this$runningDeployModelTasks == null ? other$runningDeployModelTasks != null : !((Object)this$runningDeployModelTasks).equals(other$runningDeployModelTasks)) {
            return false;
        }
        Map<String, Boolean> this$deployToAllNodes = this.getDeployToAllNodes();
        Map<String, Boolean> other$deployToAllNodes = other.getDeployToAllNodes();
        return !(this$deployToAllNodes == null ? other$deployToAllNodes != null : !((Object)this$deployToAllNodes).equals(other$deployToAllNodes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLSyncUpInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGetDeployedModels() ? 79 : 97);
        result = result * 59 + (this.isClearRoutingTable() ? 79 : 97);
        result = result * 59 + (this.isSyncRunningDeployModelTasks() ? 79 : 97);
        Map<String, String[]> $addedWorkerNodes = this.getAddedWorkerNodes();
        result = result * 59 + ($addedWorkerNodes == null ? 43 : ((Object)$addedWorkerNodes).hashCode());
        Map<String, String[]> $removedWorkerNodes = this.getRemovedWorkerNodes();
        result = result * 59 + ($removedWorkerNodes == null ? 43 : ((Object)$removedWorkerNodes).hashCode());
        Map<String, Set<String>> $modelRoutingTable = this.getModelRoutingTable();
        result = result * 59 + ($modelRoutingTable == null ? 43 : ((Object)$modelRoutingTable).hashCode());
        Map<String, Set<String>> $runningDeployModelTasks = this.getRunningDeployModelTasks();
        result = result * 59 + ($runningDeployModelTasks == null ? 43 : ((Object)$runningDeployModelTasks).hashCode());
        Map<String, Boolean> $deployToAllNodes = this.getDeployToAllNodes();
        result = result * 59 + ($deployToAllNodes == null ? 43 : ((Object)$deployToAllNodes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLSyncUpInput(getDeployedModels=" + this.isGetDeployedModels() + ", addedWorkerNodes=" + this.getAddedWorkerNodes() + ", removedWorkerNodes=" + this.getRemovedWorkerNodes() + ", modelRoutingTable=" + this.getModelRoutingTable() + ", runningDeployModelTasks=" + this.getRunningDeployModelTasks() + ", clearRoutingTable=" + this.isClearRoutingTable() + ", syncRunningDeployModelTasks=" + this.isSyncRunningDeployModelTasks() + ", deployToAllNodes=" + this.getDeployToAllNodes() + ")";
    }

    @Generated
    public static class MLSyncUpInputBuilder {
        @Generated
        private boolean getDeployedModels;
        @Generated
        private Map<String, String[]> addedWorkerNodes;
        @Generated
        private Map<String, String[]> removedWorkerNodes;
        @Generated
        private Map<String, Set<String>> modelRoutingTable;
        @Generated
        private Map<String, Set<String>> runningDeployModelTasks;
        @Generated
        private Map<String, Boolean> deployToAllNodes;
        @Generated
        private boolean clearRoutingTable;
        @Generated
        private boolean syncRunningDeployModelTasks;

        @Generated
        MLSyncUpInputBuilder() {
        }

        @Generated
        public MLSyncUpInputBuilder getDeployedModels(boolean getDeployedModels) {
            this.getDeployedModels = getDeployedModels;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder addedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
            this.addedWorkerNodes = addedWorkerNodes;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder removedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
            this.removedWorkerNodes = removedWorkerNodes;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder modelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
            this.modelRoutingTable = modelRoutingTable;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder runningDeployModelTasks(Map<String, Set<String>> runningDeployModelTasks) {
            this.runningDeployModelTasks = runningDeployModelTasks;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder deployToAllNodes(Map<String, Boolean> deployToAllNodes) {
            this.deployToAllNodes = deployToAllNodes;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder clearRoutingTable(boolean clearRoutingTable) {
            this.clearRoutingTable = clearRoutingTable;
            return this;
        }

        @Generated
        public MLSyncUpInputBuilder syncRunningDeployModelTasks(boolean syncRunningDeployModelTasks) {
            this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
            return this;
        }

        @Generated
        public MLSyncUpInput build() {
            return new MLSyncUpInput(this.getDeployedModels, this.addedWorkerNodes, this.removedWorkerNodes, this.modelRoutingTable, this.runningDeployModelTasks, this.deployToAllNodes, this.clearRoutingTable, this.syncRunningDeployModelTasks);
        }

        @Generated
        public String toString() {
            return "MLSyncUpInput.MLSyncUpInputBuilder(getDeployedModels=" + this.getDeployedModels + ", addedWorkerNodes=" + this.addedWorkerNodes + ", removedWorkerNodes=" + this.removedWorkerNodes + ", modelRoutingTable=" + this.modelRoutingTable + ", runningDeployModelTasks=" + this.runningDeployModelTasks + ", deployToAllNodes=" + this.deployToAllNodes + ", clearRoutingTable=" + this.clearRoutingTable + ", syncRunningDeployModelTasks=" + this.syncRunningDeployModelTasks + ")";
        }
    }
}

