/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.authinterceptors;

import java.io.IOException;
import lombok.NonNull;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BasicAuthenticationInterceptor
implements Interceptor {
    private String credentials;

    public BasicAuthenticationInterceptor(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.credentials = Credentials.basic((String)username, (String)password);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request authenticatedRequest = request.newBuilder().header("Authorization", this.credentials).build();
        return chain.proceed(authenticatedRequest);
    }
}

