# This file has been autogenerated by the pywayland scanner

# Copyright © 2014      Jonas Ådahl
# Copyright © 2015      Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlPointer
from ..wayland import WlRegion
from ..wayland import WlSurface
from .zwp_confined_pointer_v1 import ZwpConfinedPointerV1
from .zwp_locked_pointer_v1 import ZwpLockedPointerV1


class ZwpPointerConstraintsV1(Interface):
    """Constrain the movement of a pointer

    The global interface exposing pointer constraining functionality. It
    exposes two requests: lock_pointer for locking the pointer to its position,
    and confine_pointer for locking the pointer to a region.

    The lock_pointer and confine_pointer requests create the objects
    wp_locked_pointer and wp_confined_pointer respectively, and the client can
    use these objects to interact with the lock.

    For any surface, only one lock or confinement may be active across all
    :class:`~pywayland.protocol.wayland.WlPointer` objects of the same seat. If
    a lock or confinement is requested when another lock or confinement is
    active or requested on the same surface and with any of the
    :class:`~pywayland.protocol.wayland.WlPointer` objects of the same seat, an
    'already_constrained' error will be raised.
    """

    name = "zwp_pointer_constraints_v1"
    version = 1

    class error(enum.IntEnum):
        already_constrained = 1

    class lifetime(enum.IntEnum):
        oneshot = 1
        persistent = 2


class ZwpPointerConstraintsV1Proxy(Proxy[ZwpPointerConstraintsV1]):
    interface = ZwpPointerConstraintsV1

    @ZwpPointerConstraintsV1.request()
    def destroy(self) -> None:
        """Destroy the pointer constraints manager object

        Used by the client to notify the server that it will no longer use this
        pointer constraints object.
        """
        self._marshal(0)
        self._destroy()

    @ZwpPointerConstraintsV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLockedPointerV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlPointer),
        Argument(ArgumentType.Object, interface=WlRegion, nullable=True),
        Argument(ArgumentType.Uint),
    )
    def lock_pointer(self, surface: WlSurface, pointer: WlPointer, region: WlRegion | None, lifetime: int) -> Proxy[ZwpLockedPointerV1]:
        """Lock pointer to a position

        The lock_pointer request lets the client request to disable movements
        of the virtual pointer (i.e. the cursor), effectively locking the
        pointer to a position. This request may not take effect immediately; in
        the future, when the compositor deems implementation-specific
        constraints are satisfied, the pointer lock will be activated and the
        compositor sends a locked event.

        The protocol provides no guarantee that the constraints are ever
        satisfied, and does not require the compositor to send an error if the
        constraints cannot ever be satisfied. It is thus possible to request a
        lock that will never activate.

        There may not be another pointer constraint of any kind requested or
        active on the surface for any of the
        :class:`~pywayland.protocol.wayland.WlPointer` objects of the seat of
        the passed pointer when requesting a lock. If there is, an error will
        be raised. See general pointer lock documentation for more details.

        The intersection of the region passed with this request and the input
        region of the surface is used to determine where the pointer must be in
        order for the lock to activate. It is up to the compositor whether to
        warp the pointer or require some kind of user interaction for the lock
        to activate. If the region is null the surface input region is used.

        A surface may receive pointer focus without the lock being activated.

        The request creates a new object wp_locked_pointer which is used to
        interact with the lock as well as receive updates about its state. See
        the the description of wp_locked_pointer for further information.

        Note that while a pointer is locked, the
        :class:`~pywayland.protocol.wayland.WlPointer` objects of the
        corresponding seat will not emit any :func:`WlPointer.motion()
        <pywayland.protocol.wayland.WlPointer.motion>` events, but relative
        motion events will still be emitted via wp_relative_pointer objects of
        the same seat. :func:`WlPointer.axis()
        <pywayland.protocol.wayland.WlPointer.axis>` and
        :func:`WlPointer.button()
        <pywayland.protocol.wayland.WlPointer.button>` events are unaffected.

        :param surface:
            surface to lock pointer to
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param pointer:
            the pointer that should be locked
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :param region:
            region of surface
        :type region:
            :class:`~pywayland.protocol.wayland.WlRegion` or `None`
        :param lifetime:
            lock lifetime
        :type lifetime:
            `ArgumentType.Uint`
        :returns:
            :class:`~pywayland.protocol.pointer_constraints_unstable_v1.ZwpLockedPointerV1`
        """
        id = self._marshal_constructor(1, ZwpLockedPointerV1, surface, pointer, region, lifetime)
        return id

    @ZwpPointerConstraintsV1.request(
        Argument(ArgumentType.NewId, interface=ZwpConfinedPointerV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlPointer),
        Argument(ArgumentType.Object, interface=WlRegion, nullable=True),
        Argument(ArgumentType.Uint),
    )
    def confine_pointer(self, surface: WlSurface, pointer: WlPointer, region: WlRegion | None, lifetime: int) -> Proxy[ZwpConfinedPointerV1]:
        """Confine pointer to a region

        The confine_pointer request lets the client request to confine the
        pointer cursor to a given region. This request may not take effect
        immediately; in the future, when the compositor deems implementation-
        specific constraints are satisfied, the pointer confinement will be
        activated and the compositor sends a confined event.

        The intersection of the region passed with this request and the input
        region of the surface is used to determine where the pointer must be in
        order for the confinement to activate. It is up to the compositor
        whether to warp the pointer or require some kind of user interaction
        for the confinement to activate. If the region is null the surface
        input region is used.

        The request will create a new object wp_confined_pointer which is used
        to interact with the confinement as well as receive updates about its
        state. See the the description of wp_confined_pointer for further
        information.

        :param surface:
            surface to lock pointer to
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param pointer:
            the pointer that should be confined
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :param region:
            region of surface
        :type region:
            :class:`~pywayland.protocol.wayland.WlRegion` or `None`
        :param lifetime:
            confinement lifetime
        :type lifetime:
            `ArgumentType.Uint`
        :returns:
            :class:`~pywayland.protocol.pointer_constraints_unstable_v1.ZwpConfinedPointerV1`
        """
        id = self._marshal_constructor(2, ZwpConfinedPointerV1, surface, pointer, region, lifetime)
        return id


class ZwpPointerConstraintsV1Resource(Resource):
    interface = ZwpPointerConstraintsV1


class ZwpPointerConstraintsV1Global(Global):
    interface = ZwpPointerConstraintsV1


ZwpPointerConstraintsV1._gen_c()
ZwpPointerConstraintsV1.proxy_class = ZwpPointerConstraintsV1Proxy
ZwpPointerConstraintsV1.resource_class = ZwpPointerConstraintsV1Resource
ZwpPointerConstraintsV1.global_class = ZwpPointerConstraintsV1Global
