"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ppl_datasource = require("../../adaptors/ppl_datasource");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PPLFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            query: request.body.query
          }
        };

        if (request.body.format !== 'jdbc') {
          params['format'] = request.body.format;
        }

        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const pplDataSource = new _ppl_datasource.PPLDataSource(queryRes, request.body.format);
        res['success'] = true;
        res['data'] = pplDataSource.getDataSource();
      } catch (err) {
        console.error('PPL query fetch err: ', err);
        res['data'] = err;
      }

      return res;
    });

    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'ppl.pplQuery', 'json');
    });

    this.client = client;
  }

}

exports.default = PPLFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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