/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.pickfast;

import com.sun.j3d.utils.pickfast.PickTool;
import java.awt.event.MouseEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Locale;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickRay;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PickCanvas
extends PickTool {
    Canvas3D canvas;
    float tolerance = 2.0f;
    int save_xpos;
    int save_ypos;

    public PickCanvas(Canvas3D canvas3D, BranchGroup branchGroup) {
        super(branchGroup);
        this.canvas = canvas3D;
    }

    public PickCanvas(Canvas3D canvas3D, Locale locale) {
        super(locale);
        this.canvas = canvas3D;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    public void setTolerance(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.tolerance = f;
        if (this.pickShape != null && !this.userDefineShape) {
            this.pickShape = null;
            this.setShapeLocation(this.save_xpos, this.save_ypos);
        }
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setShapeLocation(MouseEvent mouseEvent) {
        this.setShapeLocation(mouseEvent.getX(), mouseEvent.getY());
    }

    public void setShapeLocation(int n, int n2) {
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        this.save_xpos = n;
        this.save_ypos = n2;
        this.canvas.getCenterEyeInImagePlate(point3d);
        this.canvas.getPixelLocationInImagePlate(n, n2, point3d2);
        if (this.canvas.getView() != null && this.canvas.getView().getProjectionPolicy() == 0) {
            point3d.x = point3d2.x;
            point3d.y = point3d2.y;
            bl = true;
        }
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        double d3 = vector3d2.length();
        Point3d point3d3 = new Point3d();
        this.canvas.getPixelLocationInImagePlate(n + 1, n2, point3d3);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub((Tuple3d)point3d2, (Tuple3d)point3d3);
        double d4 = vector3d3.length();
        d4 *= (double)this.tolerance;
        this.canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        this.start = new Point3d(point3d);
        transform3D.transform(point3d2);
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        vector3d.normalize();
        if ((double)this.tolerance == 0.0) {
            if (this.pickShape != null && this.pickShape instanceof PickRay) {
                ((PickRay)this.pickShape).set(point3d, vector3d);
            } else {
                this.pickShape = new PickRay(point3d, vector3d);
            }
        } else if (bl) {
            d4 *= transform3D.getScale();
            if (this.pickShape != null && this.pickShape instanceof PickCylinderRay) {
                ((PickCylinderRay)this.pickShape).set(point3d, vector3d, d4);
            } else {
                this.pickShape = new PickCylinderRay(point3d, vector3d, d4);
            }
        } else {
            d2 = Math.atan(d4 / d3);
            if (this.pickShape != null && this.pickShape instanceof PickConeRay) {
                ((PickConeRay)this.pickShape).set(point3d, vector3d, d2);
            } else {
                this.pickShape = new PickConeRay(point3d, vector3d, d2);
            }
        }
    }
}

