/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionResponse;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class AnomalyResultResponse
extends ActionResponse
implements ToXContentObject {
    public static final String ANOMALY_GRADE_JSON_KEY = "anomalyGrade";
    public static final String CONFIDENCE_JSON_KEY = "confidence";
    public static final String ANOMALY_SCORE_JSON_KEY = "anomalyScore";
    public static final String ERROR_JSON_KEY = "error";
    public static final String FEATURES_JSON_KEY = "features";
    public static final String FEATURE_VALUE_JSON_KEY = "value";
    public static final String RCF_TOTAL_UPDATES_JSON_KEY = "rcfTotalUpdates";
    public static final String DETECTOR_INTERVAL_IN_MINUTES_JSON_KEY = "detectorIntervalInMinutes";
    public static final String RELATIVE_INDEX_FIELD_JSON_KEY = "relativeIndex";
    public static final String RELEVANT_ATTRIBUTION_FIELD_JSON_KEY = "relevantAttribution";
    public static final String PAST_VALUES_FIELD_JSON_KEY = "pastValues";
    public static final String EXPECTED_VAL_LIST_FIELD_JSON_KEY = "expectedValuesList";
    public static final String LIKELIHOOD_FIELD_JSON_KEY = "likelihoodOfValues";
    public static final String THRESHOLD_FIELD_JSON_KEY = "threshold";
    private Double anomalyGrade;
    private Double confidence;
    private Double anomalyScore;
    private String error;
    private List<FeatureData> features;
    private Long rcfTotalUpdates;
    private Long detectorIntervalInMinutes;
    private Boolean isHCDetector;
    private Integer relativeIndex;
    private double[] relevantAttribution;
    private double[] pastValues;
    private double[][] expectedValuesList;
    private double[] likelihoodOfValues;
    private Double threshold;

    public AnomalyResultResponse(List<FeatureData> features, String error, Long rcfTotalUpdates, Long detectorIntervalInMinutes, Boolean isHCDetector) {
        this(Double.NaN, Double.NaN, Double.NaN, features, error, rcfTotalUpdates, detectorIntervalInMinutes, isHCDetector, null, null, null, null, null, Double.NaN);
    }

    public AnomalyResultResponse(Double anomalyGrade, Double confidence, Double anomalyScore, List<FeatureData> features, String error, Long rcfTotalUpdates, Long detectorIntervalInMinutes, Boolean isHCDetector, Integer relativeIndex, double[] currentTimeAttribution, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, Double threshold) {
        this.anomalyGrade = anomalyGrade;
        this.confidence = confidence;
        this.anomalyScore = anomalyScore;
        this.features = features;
        this.error = error;
        this.rcfTotalUpdates = rcfTotalUpdates;
        this.detectorIntervalInMinutes = detectorIntervalInMinutes;
        this.isHCDetector = isHCDetector;
        this.relativeIndex = relativeIndex;
        this.relevantAttribution = currentTimeAttribution;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.likelihoodOfValues = likelihoodOfValues;
        this.threshold = threshold;
    }

    public AnomalyResultResponse(StreamInput in) throws IOException {
        super(in);
        this.anomalyGrade = in.readDouble();
        this.confidence = in.readDouble();
        this.anomalyScore = in.readDouble();
        int size = in.readVInt();
        this.features = new ArrayList<FeatureData>();
        for (int i = 0; i < size; ++i) {
            this.features.add(new FeatureData(in));
        }
        this.error = in.readOptionalString();
        this.rcfTotalUpdates = in.readOptionalLong();
        this.detectorIntervalInMinutes = in.readOptionalLong();
        this.isHCDetector = in.readOptionalBoolean();
        this.relativeIndex = in.readOptionalInt();
        this.relevantAttribution = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        this.pastValues = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        if (in.readBoolean()) {
            int numberofExpectedVals = in.readVInt();
            this.expectedValuesList = new double[numberofExpectedVals][];
            for (int i = 0; i < numberofExpectedVals; ++i) {
                this.expectedValuesList[i] = in.readDoubleArray();
            }
        } else {
            this.expectedValuesList = null;
        }
        this.likelihoodOfValues = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        this.threshold = in.readOptionalDouble();
    }

    public double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    public List<FeatureData> getFeatures() {
        return this.features;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    public String getError() {
        return this.error;
    }

    public Long getRcfTotalUpdates() {
        return this.rcfTotalUpdates;
    }

    public Long getDetectorIntervalInMinutes() {
        return this.detectorIntervalInMinutes;
    }

    public Boolean isHCDetector() {
        return this.isHCDetector;
    }

    public Integer getRelativeIndex() {
        return this.relativeIndex;
    }

    public double[] getCurrentTimeAttribution() {
        return this.relevantAttribution;
    }

    public double[] getOldValues() {
        return this.pastValues;
    }

    public double[][] getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public double[] getLikelihoodOfValues() {
        return this.likelihoodOfValues;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.anomalyGrade.doubleValue());
        out.writeDouble(this.confidence.doubleValue());
        out.writeDouble(this.anomalyScore.doubleValue());
        out.writeVInt(this.features.size());
        for (FeatureData feature : this.features) {
            feature.writeTo(out);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalLong(this.rcfTotalUpdates);
        out.writeOptionalLong(this.detectorIntervalInMinutes);
        out.writeOptionalBoolean(this.isHCDetector);
        out.writeOptionalInt(this.relativeIndex);
        if (this.relevantAttribution != null) {
            out.writeBoolean(true);
            out.writeDoubleArray(this.relevantAttribution);
        } else {
            out.writeBoolean(false);
        }
        if (this.pastValues != null) {
            out.writeBoolean(true);
            out.writeDoubleArray(this.pastValues);
        } else {
            out.writeBoolean(false);
        }
        if (this.expectedValuesList != null) {
            out.writeBoolean(true);
            int numberofExpectedVals = this.expectedValuesList.length;
            out.writeVInt(this.expectedValuesList.length);
            for (int i = 0; i < numberofExpectedVals; ++i) {
                out.writeDoubleArray(this.expectedValuesList[i]);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.likelihoodOfValues != null) {
            out.writeBoolean(true);
            out.writeDoubleArray(this.likelihoodOfValues);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalDouble(this.threshold);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ANOMALY_GRADE_JSON_KEY, this.anomalyGrade);
        builder.field(CONFIDENCE_JSON_KEY, this.confidence);
        builder.field(ANOMALY_SCORE_JSON_KEY, this.anomalyScore);
        builder.field(ERROR_JSON_KEY, this.error);
        builder.startArray(FEATURES_JSON_KEY);
        for (FeatureData feature : this.features) {
            feature.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(RCF_TOTAL_UPDATES_JSON_KEY, this.rcfTotalUpdates);
        builder.field(DETECTOR_INTERVAL_IN_MINUTES_JSON_KEY, this.detectorIntervalInMinutes);
        builder.field(RELATIVE_INDEX_FIELD_JSON_KEY, this.relativeIndex);
        builder.field(RELEVANT_ATTRIBUTION_FIELD_JSON_KEY, (Object)this.relevantAttribution);
        builder.field(PAST_VALUES_FIELD_JSON_KEY, (Object)this.pastValues);
        builder.field(EXPECTED_VAL_LIST_FIELD_JSON_KEY, (Object)this.expectedValuesList);
        builder.field(LIKELIHOOD_FIELD_JSON_KEY, (Object)this.likelihoodOfValues);
        builder.field(THRESHOLD_FIELD_JSON_KEY, this.threshold);
        builder.endObject();
        return builder;
    }

    /*
     * Exception decompiling
     */
    public static AnomalyResultResponse fromActionResponse(ActionResponse actionResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AnomalyResult toAnomalyResult(String detectorId, Instant dataStartInstant, Instant dataEndInstant, Instant executionStartInstant, Instant executionEndInstant, Integer schemaVersion, User user, String error) {
        long detectorIntervalMilli = Duration.between(dataStartInstant, dataEndInstant).toMillis();
        return AnomalyResult.fromRawTRCFResult(detectorId, detectorIntervalMilli, null, this.anomalyScore, this.anomalyGrade, this.confidence, this.features, dataStartInstant, dataEndInstant, executionStartInstant, executionEndInstant, error, null, user, schemaVersion, null, this.relevantAttribution, this.relativeIndex, this.pastValues, this.expectedValuesList, this.likelihoodOfValues, this.threshold);
    }
}

