"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;

var _ppl = require("./ppl");

var _ppl_facet = _interopRequireDefault(require("../services/facets/ppl_facet"));

var _dsl = require("./dsl");

var _dsl_facet = _interopRequireDefault(require("../services/facets/dsl_facet"));

var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));

var _panels_router = require("./custom_panels/panels_router");

var _visualizations_router = require("./custom_panels/visualizations_router");

var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");

var _paraRouter = require("./notebooks/paraRouter");

var _noteRouter = require("./notebooks/noteRouter");

var _vizRouter = require("./notebooks/vizRouter");

var _queryService = _interopRequireDefault(require("../services/queryService"));

var _sqlRouter = require("./notebooks/sqlRouter");

var _event_analytics_router = require("./event_analytics/event_analytics_router");

var _app_analytics_router = require("./application_analytics/app_analytics_router");

var _metrics_rounter = require("./metrics/metrics_rounter");

var _integrations_router = require("./integrations/integrations_router");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupRoutes({
  router,
  client
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.default(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.default(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router); // TODO remove trace analytics route when DSL route for autocomplete is added

  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router); // notebooks routes

  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.default(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
  (0, _integrations_router.registerIntegrationsRoute)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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