from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.GeomAbs import *


class LProp_SequenceOfCIType:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> LProp_CIType: ...
    def Last(self) -> LProp_CIType: ...
    def Length(self) -> int: ...
    def Append(self, theItem: LProp_CIType) -> LProp_CIType: ...
    def Prepend(self, theItem: LProp_CIType) -> LProp_CIType: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> LProp_CIType: ...
    def SetValue(self, theIndex: int, theValue: LProp_CIType) -> None: ...

class LProp_Status(IntEnum):
    LProp_Undecided: int = ...
    LProp_Undefined: int = ...
    LProp_Defined: int = ...
    LProp_Computed: int = ...

LProp_Undecided = LProp_Status.LProp_Undecided
LProp_Undefined = LProp_Status.LProp_Undefined
LProp_Defined = LProp_Status.LProp_Defined
LProp_Computed = LProp_Status.LProp_Computed

class LProp_CIType(IntEnum):
    LProp_Inflection: int = ...
    LProp_MinCur: int = ...
    LProp_MaxCur: int = ...

LProp_Inflection = LProp_CIType.LProp_Inflection
LProp_MinCur = LProp_CIType.LProp_MinCur
LProp_MaxCur = LProp_CIType.LProp_MaxCur

class LProp_AnalyticCurInf:
    def __init__(self) -> None: ...
    def Perform(self, T: GeomAbs_CurveType, UFirst: float, ULast: float, Result: LProp_CurAndInf) -> None: ...

class LProp_CurAndInf:
    def __init__(self) -> None: ...
    def AddExtCur(self, Param: float, IsMin: bool) -> None: ...
    def AddInflection(self, Param: float) -> None: ...
    def Clear(self) -> None: ...
    def IsEmpty(self) -> bool: ...
    def NbPoints(self) -> int: ...
    def Parameter(self, N: int) -> float: ...
    def Type(self, N: int) -> LProp_CIType: ...

# harray1 classes
# harray2 classes
# hsequence classes

