"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RamlWrapper = require("./raml10parser");
function getWrapperConstructor(definition) {
    if (!definition.isBuiltIn())
        return null;
    return classMap[definition.nameId()];
}
/**
 * @hidden
 * Build Wrapper node corresponding to the High Level node
 **/
function buildWrapperNode(node, setAsTopLevel) {
    if (setAsTopLevel === void 0) { setAsTopLevel = true; }
    var definition = node.definition();
    var nodeClassName = definition.nameId();
    var wrapperConstructor = getWrapperConstructor(definition);
    if (!wrapperConstructor) {
        var priorities = determineSuperclassesPriorities(definition);
        var superTypes = definition.allSuperTypes().sort(function (x, y) { return priorities[x.nameId()] - priorities[y.nameId()]; });
        var wr = null;
        for (var i = 0; i < superTypes.length; i++) {
            var superTypeName = superTypes[i].nameId();
            wrapperConstructor = getWrapperConstructor(superTypes[i]);
            if (superTypeName == "DataElement") {
                wr = superTypeName;
                //This is only case of nested hierarchy
                continue;
            }
            if (superTypeName == "hl.BasicNode") {
                //depth first
                continue;
            }
            if (wrapperConstructor) {
                break;
            }
        }
        if (!wrapperConstructor) {
            wr = superTypeName;
        }
    }
    if (!wrapperConstructor) {
        wrapperConstructor = classMap["hl.BasicNode"];
    }
    return wrapperConstructor(node, setAsTopLevel);
}
exports.buildWrapperNode = buildWrapperNode;
function determineSuperclassesPriorities(td, priorities, path) {
    if (priorities === void 0) { priorities = {}; }
    if (path === void 0) { path = {}; }
    var typeName = td.nameId();
    if (path[typeName]) {
        return;
    }
    path[typeName] = true;
    var rank = (priorities[typeName] != null && priorities[typeName] + 1) || 0;
    var superTypes = td.superTypes();
    superTypes.forEach(function (x) {
        var name = x.nameId();
        var r = priorities[name];
        if (r == null || rank > r) {
            priorities[name] = rank;
            determineSuperclassesPriorities(x, priorities, path);
        }
    });
    delete path[typeName];
    return priorities;
}
var classMap = {
    "AbstractSecurityScheme": function (x, y) { return new RamlWrapper.AbstractSecuritySchemeImpl(x, y); },
    "Annotable": function (x, y) { return new RamlWrapper.AnnotableImpl(x, y); },
    "AnnotationRef": function (x) { return new RamlWrapper.AnnotationRefImpl(x); },
    "AnnotationTarget": function (x) { return new RamlWrapper.AnnotationTargetImpl(x); },
    "AnyType": function (x) { return new RamlWrapper.AnyTypeImpl(x); },
    "Api": function (x, y) { return new RamlWrapper.ApiImpl(x, y); },
    "ArrayTypeDeclaration": function (x, y) { return new RamlWrapper.ArrayTypeDeclarationImpl(x, y); },
    "BasicSecurityScheme": function (x, y) { return new RamlWrapper.BasicSecuritySchemeImpl(x, y); },
    "BooleanType": function (x) { return new RamlWrapper.BooleanTypeImpl(x); },
    "BooleanTypeDeclaration": function (x, y) { return new RamlWrapper.BooleanTypeDeclarationImpl(x, y); },
    "ContentType": function (x) { return new RamlWrapper.ContentTypeImpl(x); },
    "CustomSecurityScheme": function (x, y) { return new RamlWrapper.CustomSecuritySchemeImpl(x, y); },
    "DateOnlyType": function (x) { return new RamlWrapper.DateOnlyTypeImpl(x); },
    "DateOnlyTypeDeclaration": function (x, y) { return new RamlWrapper.DateOnlyTypeDeclarationImpl(x, y); },
    "DateTimeOnlyType": function (x) { return new RamlWrapper.DateTimeOnlyTypeImpl(x); },
    "DateTimeOnlyTypeDeclaration": function (x, y) { return new RamlWrapper.DateTimeOnlyTypeDeclarationImpl(x, y); },
    "DateTimeType": function (x) { return new RamlWrapper.DateTimeTypeImpl(x); },
    "DateTimeTypeDeclaration": function (x, y) { return new RamlWrapper.DateTimeTypeDeclarationImpl(x, y); },
    "DigestSecurityScheme": function (x, y) { return new RamlWrapper.DigestSecuritySchemeImpl(x, y); },
    "DocumentationItem": function (x, y) { return new RamlWrapper.DocumentationItemImpl(x, y); },
    "Extension": function (x, y) { return new RamlWrapper.ExtensionImpl(x, y); },
    "FileType": function (x) { return new RamlWrapper.FileTypeImpl(x); },
    "FileTypeDeclaration": function (x, y) { return new RamlWrapper.FileTypeDeclarationImpl(x, y); },
    "FixedUriString": function (x) { return new RamlWrapper.FixedUriStringImpl(x); },
    "FragmentDeclaration": function (x, y) { return new RamlWrapper.FragmentDeclarationImpl(x, y); },
    "FullUriTemplateString": function (x) { return new RamlWrapper.FullUriTemplateStringImpl(x); },
    "IntegerType": function (x) { return new RamlWrapper.IntegerTypeImpl(x); },
    "IntegerTypeDeclaration": function (x, y) { return new RamlWrapper.IntegerTypeDeclarationImpl(x, y); },
    "Library": function (x, y) { return new RamlWrapper.LibraryImpl(x, y); },
    "LibraryBase": function (x, y) { return new RamlWrapper.LibraryBaseImpl(x, y); },
    "LocationKind": function (x) { return new RamlWrapper.LocationKindImpl(x); },
    "MarkdownString": function (x) { return new RamlWrapper.MarkdownStringImpl(x); },
    "Method": function (x, y) { return new RamlWrapper.MethodImpl(x, y); },
    "MethodBase": function (x, y) { return new RamlWrapper.MethodBaseImpl(x, y); },
    "MimeType": function (x) { return new RamlWrapper.MimeTypeImpl(x); },
    "ModelLocation": function (x) { return new RamlWrapper.ModelLocationImpl(x); },
    "NullType": function (x) { return new RamlWrapper.NullTypeImpl(x); },
    "NumberType": function (x) { return new RamlWrapper.NumberTypeImpl(x); },
    "NumberTypeDeclaration": function (x, y) { return new RamlWrapper.NumberTypeDeclarationImpl(x, y); },
    "OAuth1SecurityScheme": function (x, y) { return new RamlWrapper.OAuth1SecuritySchemeImpl(x, y); },
    "OAuth1SecuritySchemeSettings": function (x, y) { return new RamlWrapper.OAuth1SecuritySchemeSettingsImpl(x, y); },
    "OAuth2SecurityScheme": function (x, y) { return new RamlWrapper.OAuth2SecuritySchemeImpl(x, y); },
    "OAuth2SecuritySchemeSettings": function (x, y) { return new RamlWrapper.OAuth2SecuritySchemeSettingsImpl(x, y); },
    "ObjectTypeDeclaration": function (x, y) { return new RamlWrapper.ObjectTypeDeclarationImpl(x, y); },
    "Operation": function (x, y) { return new RamlWrapper.OperationImpl(x, y); },
    "Overlay": function (x, y) { return new RamlWrapper.OverlayImpl(x, y); },
    "PassThroughSecurityScheme": function (x, y) { return new RamlWrapper.PassThroughSecuritySchemeImpl(x, y); },
    "Reference": function (x) { return new RamlWrapper.ReferenceImpl(x); },
    "RelativeUriString": function (x) { return new RamlWrapper.RelativeUriStringImpl(x); },
    "Resource": function (x, y) { return new RamlWrapper.ResourceImpl(x, y); },
    "ResourceBase": function (x, y) { return new RamlWrapper.ResourceBaseImpl(x, y); },
    "ResourceType": function (x, y) { return new RamlWrapper.ResourceTypeImpl(x, y); },
    "ResourceTypeRef": function (x) { return new RamlWrapper.ResourceTypeRefImpl(x); },
    "Response": function (x, y) { return new RamlWrapper.ResponseImpl(x, y); },
    "SchemaString": function (x) { return new RamlWrapper.SchemaStringImpl(x); },
    "SecuritySchemePart": function (x, y) { return new RamlWrapper.SecuritySchemePartImpl(x, y); },
    "SecuritySchemeRef": function (x) { return new RamlWrapper.SecuritySchemeRefImpl(x); },
    "SecuritySchemeSettings": function (x, y) { return new RamlWrapper.SecuritySchemeSettingsImpl(x, y); },
    "StatusCodeString": function (x) { return new RamlWrapper.StatusCodeStringImpl(x); },
    "StringType": function (x) { return new RamlWrapper.StringTypeImpl(x); },
    "StringTypeDeclaration": function (x, y) { return new RamlWrapper.StringTypeDeclarationImpl(x, y); },
    "TimeOnlyType": function (x) { return new RamlWrapper.TimeOnlyTypeImpl(x); },
    "TimeOnlyTypeDeclaration": function (x, y) { return new RamlWrapper.TimeOnlyTypeDeclarationImpl(x, y); },
    "Trait": function (x, y) { return new RamlWrapper.TraitImpl(x, y); },
    "TraitRef": function (x) { return new RamlWrapper.TraitRefImpl(x); },
    "TypeDeclaration": function (x, y) { return new RamlWrapper.TypeDeclarationImpl(x, y); },
    "UnionTypeDeclaration": function (x, y) { return new RamlWrapper.UnionTypeDeclarationImpl(x, y); },
    "UriTemplate": function (x) { return new RamlWrapper.UriTemplateImpl(x); },
    "UsesDeclaration": function (x, y) { return new RamlWrapper.UsesDeclarationImpl(x, y); },
    "ValueType": function (x) { return new RamlWrapper.ValueTypeImpl(x); },
    "XMLFacetInfo": function (x, y) { return new RamlWrapper.XMLFacetInfoImpl(x, y); }
};
//# sourceMappingURL=raml10factory.js.map