/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.plugin.script.addons.AddOnDetailsPanel;
import org.freeplane.plugin.script.addons.AddonRenderer;
import org.freeplane.plugin.script.addons.ButtonsInCellRenderer;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;

public class ManageAddOnsPanel
extends JPanel {
    private static final AddonRenderer ADDON_RENDERER = new AddonRenderer();
    private AddOnTableModel tableModel;
    private static final int iconColumn = 0;
    private static final int textColumn = 1;
    private static final int buttonsColumn = 2;

    public ManageAddOnsPanel(List<AddOnProperties> addOns) {
        ManageAddOnsPanel panel = this;
        panel.setLayout(new GridLayout(2, 1));
        this.tableModel = new AddOnTableModel(addOns);
        final JTable jTable = this.createTable(this.tableModel);
        JScrollPane tableScrollPane = new JScrollPane(jTable, 20, 30);
        UITools.setScrollbarIncrement((JScrollPane)tableScrollPane);
        tableScrollPane.getViewport().setBackground(Color.white);
        final JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        final JScrollPane descriptionScrollPane = new JScrollPane(emptyPanel, 20, 30);
        UITools.setScrollbarIncrement((JScrollPane)descriptionScrollPane);
        descriptionScrollPane.getViewport().setBackground(Color.white);
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (jTable.getSelectedRowCount() != 1) {
                    descriptionScrollPane.setViewportView(emptyPanel);
                } else {
                    int row = jTable.getSelectedRow();
                    AddOnProperties addon = (AddOnProperties)ManageAddOnsPanel.this.tableModel.getValueAt(row, 1);
                    AddOnDetailsPanel detailsPanel = new AddOnDetailsPanel(addon);
                    detailsPanel.setOpaque(false);
                    descriptionScrollPane.setViewportView(detailsPanel);
                }
            }
        });
        panel.add(tableScrollPane);
        panel.add(descriptionScrollPane);
    }

    private JTable createTable(AddOnTableModel tableModel) {
        JTable table = new JTable(tableModel);
        table.setTableHeader(null);
        int rowHeight = UITools.getDefaultLabelFont().getSize() * 5;
        table.setRowHeight(rowHeight);
        table.setBackground(Color.white);
        table.setShowVerticalLines(false);
        TableColumnModel columnModel = table.getColumnModel();
        JButton[] buttons = new JButton[]{this.createButton("configure"), this.createButton("deactivate"), this.createButton("activate"), this.createButton("deinstall")};
        columnModel.getColumn(0).setMinWidth(rowHeight);
        columnModel.getColumn(0).setPreferredWidth(rowHeight);
        columnModel.getColumn(1).setPreferredWidth(10000);
        columnModel.getColumn(2).setMinWidth(this.getPreferredWidth(buttons));
        columnModel.getColumn(2).setPreferredWidth(this.getPreferredWidth(buttons));
        Action[] actions = new Action[]{this.createConfigureAction(tableModel), this.createDeactivateAction(tableModel), this.createActivateAction(tableModel), this.createDeinstallAction(tableModel)};
        table.getColumnModel().getColumn(1).setCellRenderer(ADDON_RENDERER);
        new ButtonsInCellRenderer(table, buttons, actions, 2);
        table.setFocusable(false);
        return table;
    }

    private int getPreferredWidth(JButton[] buttons) {
        double maxButtonWidth = 0.0;
        for (JButton button : buttons) {
            Dimension size = button.getPreferredSize();
            if (!(size.getWidth() > maxButtonWidth)) continue;
            maxButtonWidth = size.getWidth();
        }
        int spacer = 4;
        return (int)((double)(buttons.length - 1) * (maxButtonWidth + (double)spacer)) + spacer;
    }

    private AbstractAction createConfigureAction(final AddOnTableModel tableModel) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                AddOnProperties addOn = tableModel.getAddOnAt(row);
                if (!addOn.supportsOperation("configure")) {
                    JOptionPane.showMessageDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("cannot.configure", new Object[]{addOn.getTranslatedName()}), "Freeplane", 0);
                } else {
                    OptionPanelBuilder optionPanelBuilder = new OptionPanelBuilder();
                    optionPanelBuilder.load((Reader)new StringReader(addOn.getPreferencesXml()));
                    MModeController.createShowPreferencesAction((OptionPanelBuilder)optionPanelBuilder, (boolean)false).actionPerformed(e);
                }
            }
        };
    }

    private AbstractAction createDeactivateAction(final AddOnTableModel tableModel) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                AddOnProperties addOn = tableModel.getAddOnAt(row);
                if (!addOn.supportsOperation("deactivate")) {
                    JOptionPane.showMessageDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("cannot.deactivate", new Object[]{addOn.getTranslatedName()}), "Freeplane", 0);
                } else {
                    addOn.setActive(false);
                    ManageAddOnsPanel.this.saveAddOn(addOn);
                    JOptionPane.showMessageDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("deactivation.success", new Object[]{addOn.getTranslatedName()}), "Freeplane", 1);
                }
            }
        };
    }

    private AbstractAction createActivateAction(final AddOnTableModel tableModel) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                AddOnProperties addOn = tableModel.getAddOnAt(row);
                if (!addOn.supportsOperation("activate")) {
                    JOptionPane.showMessageDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("cannot.activate", new Object[]{addOn.getTranslatedName()}), "Freeplane", 0);
                } else {
                    addOn.setActive(true);
                    ManageAddOnsPanel.this.saveAddOn(addOn);
                    JOptionPane.showMessageDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("activation.success", new Object[]{addOn.getTranslatedName()}), "Freeplane", 1);
                }
            }
        };
    }

    private AbstractAction createDeinstallAction(final AddOnTableModel tableModel) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                AddOnProperties addOn = tableModel.getAddOnAt(row);
                if (!addOn.supportsOperation("deinstall")) {
                    UITools.errorMessage((Object)ManageAddOnsPanel.getText("cannot.deinstall", new Object[]{addOn.getTranslatedName()}));
                } else {
                    int result = JOptionPane.showConfirmDialog(ManageAddOnsPanel.this, ManageAddOnsPanel.getText("really.deinstall", new Object[]{TextUtils.getText((String)addOn.getNameKey())}), ManageAddOnsPanel.getText("deinstall", new Object[0]), 2);
                    if (result == 0) {
                        this.deinstall(tableModel, addOn);
                        ManageAddOnsPanel.this.repaint();
                        UITools.informationMessage((String)ManageAddOnsPanel.getText("deinstallation.success", new Object[]{addOn.getTranslatedName()}));
                    }
                }
            }

            private void deinstall(AddOnTableModel tableModel2, AddOnProperties addOn) {
                try {
                    AddOnsController.getController().deinstall(addOn);
                    tableModel2.removeAddOn(addOn);
                }
                finally {
                    Controller.getCurrentController().getViewController().setWaitingCursor(false);
                }
            }
        };
    }

    private JButton createButton(String name) {
        JButton button = new JButton(ManageAddOnsPanel.getText(name, new Object[0]));
        button.setName(name);
        return button;
    }

    private void saveAddOn(AddOnProperties addOn) {
        try {
            AddOnsController.getController().save(addOn);
        }
        catch (IOException e) {
            UITools.errorMessage((Object)("Cannot save add-on settings: " + e.getMessage()));
        }
    }

    public AddOnTableModel getTableModel() {
        return this.tableModel;
    }

    private static String getText(String key, Object ... parameters) {
        return ManageAddOnsDialog.getText(key, parameters);
    }

    public static final class AddOnTableModel
    extends AbstractTableModel {
        private final List<AddOnProperties> addOns;
        private HashMap<AddOnProperties, Icon> icons = new HashMap();

        private AddOnTableModel(List<AddOnProperties> addOns) {
            this.addOns = new ArrayList<AddOnProperties>(addOns);
        }

        @Override
        public int getRowCount() {
            return this.addOns.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            AddOnProperties addOn = this.addOns.get(row);
            switch (col) {
                case 0: {
                    return this.createIcon(addOn);
                }
                case 1: {
                    return addOn;
                }
                case 2: {
                    return "";
                }
            }
            throw new RuntimeException("unexpected column " + col);
        }

        private Icon createIcon(AddOnProperties addOn) {
            Icon icon = this.icons.get(addOn);
            if (icon != null) {
                return icon;
            }
            String iconName = addOn.getName() + "-icon";
            icon = IconNotFound.createIconOrReturnNotFoundIcon((String[])new String[]{iconName + ".svg", iconName + ".png"});
            this.icons.put(addOn, icon);
            return icon;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 2;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            this.fireTableCellUpdated(row, column);
        }

        public AddOnProperties getAddOnAt(int row) {
            return this.addOns.get(row);
        }

        public void addAddOn(AddOnProperties addOn) {
            int row = this.addOns.size();
            this.addOns.add(addOn);
            this.fireTableRowsInserted(row, row);
        }

        public void removeAddOn(AddOnProperties addOn) {
            int row = this.addOns.indexOf(addOn);
            if (row == -1) {
                return;
            }
            this.addOns.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

