/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class EvaluationDependencies
implements IExtension {
    private final WeakHashMap<MapModel, DependentNodeReferences> onMapDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, DependentNodeReferences> onNodeDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, DependentNodeReferences> onBranchDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, Void> onAnyNodeDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, Void> onGlobalNodeDependencies = new WeakHashMap();

    public static EvaluationDependencies of(MapModel map) {
        EvaluationDependencies dependencies = (EvaluationDependencies)map.getExtension(EvaluationDependencies.class);
        if (dependencies == null) {
            dependencies = new EvaluationDependencies();
            map.addExtension((IExtension)dependencies);
        }
        return dependencies;
    }

    public void getChangedDependencies(Set<NodeModel> accessingNodes, NodeModel accessedNode) {
        Iterable onNode = this.onNodeDependencies.get(accessedNode);
        if (onNode != null) {
            this.getRecursively(accessingNodes, onNode);
        }
        ArrayList<Map.Entry<NodeModel, DependentNodeReferences>> onBranchDependencyList = new ArrayList<Map.Entry<NodeModel, DependentNodeReferences>>(this.onBranchDependencies.entrySet());
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : onBranchDependencyList) {
            NodeModel branchNode = entry.getKey();
            if (!accessedNode.isDescendantOf(branchNode)) continue;
            this.onBranchDependencies.get(branchNode);
            this.getRecursively(accessingNodes, entry.getValue());
        }
        if (!this.onAnyNodeDependencies.isEmpty()) {
            ArrayList<NodeModel> onAnyNodeDependendingNodes = new ArrayList<NodeModel>(this.onAnyNodeDependencies.keySet());
            this.onAnyNodeDependencies.clear();
            this.getRecursively(accessingNodes, onAnyNodeDependendingNodes);
        }
    }

    public void getGlobalDependencies(Set<NodeModel> accessingNodes) {
        this.getRecursively(accessingNodes, this.onGlobalNodeDependencies.keySet());
    }

    public void removeAndReturnChangedDependencies(Set<NodeModel> accessingNodes, MapModel accessedMap) {
        Iterable onMap = this.onMapDependencies.remove(accessedMap);
        if (onMap != null) {
            this.getRecursively(accessingNodes, onMap);
        }
    }

    private void getRecursively(Set<NodeModel> accessingNodes, Iterable<NodeModel> changedAccessedNodes) {
        for (NodeModel node : changedAccessedNodes) {
            if (!accessingNodes.add(node)) continue;
            this.getChangedDependencies(accessingNodes, node);
        }
    }

    public void accessNode(NodeModel accessingNode, NodeModel accessedNode) {
        this.provideDependencySet(accessedNode, this.onNodeDependencies).add(accessingNode);
        this.addAccessedMap(accessingNode, accessedNode);
    }

    public void accessBranch(NodeModel accessingNode, NodeModel accessedNode) {
        this.provideDependencySet(accessedNode, this.onBranchDependencies).add(accessingNode);
        this.addAccessedMap(accessingNode, accessedNode);
    }

    private void addAccessedMap(NodeModel accessingNode, NodeModel accessedNode) {
        MapModel accessedMap = accessedNode.getMap();
        if (accessedMap != accessingNode.getMap()) {
            this.provideDependencySet(accessedMap, this.onMapDependencies).add(accessingNode);
        }
    }

    public void accessAll(NodeModel accessingNode) {
        this.onAnyNodeDependencies.put(accessingNode, null);
    }

    public void accessGlobalNode(NodeModel accessingNode) {
        this.onGlobalNodeDependencies.put(accessingNode, null);
    }

    private <T> DependentNodeReferences provideDependencySet(T accessed, WeakHashMap<T, DependentNodeReferences> dependenciesMap) {
        DependentNodeReferences set = dependenciesMap.get(accessed);
        if (set == null) {
            set = new DependentNodeReferences();
            dependenciesMap.put(accessed, set);
        }
        return set;
    }

    public Iterable<NodeModel> getPossibleDependencies(NodeModel node) {
        List<NodeModel> dependencies = (List<NodeModel>)((Object)this.onNodeDependencies.get(node));
        return dependencies != null ? dependencies : Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onNodeDependencies.entrySet()) {
            builder.append("onNode (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onBranchDependencies.entrySet()) {
            builder.append("onBranch (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        if (!this.onAnyNodeDependencies.isEmpty()) {
            builder.append("onAnyNode:\n");
            for (NodeModel nodeModel : this.onAnyNodeDependencies.keySet()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        return builder.toString();
    }

    static class DependentNodeReferences
    implements Iterable<NodeModel> {
        private final WeakHashMap<NodeModel, Void> references = new WeakHashMap();

        DependentNodeReferences() {
        }

        void add(NodeModel node) {
            this.references.put(node, null);
        }

        @Override
        public Iterator<NodeModel> iterator() {
            return this.references.keySet().iterator();
        }
    }

    static enum Access {
        NODE,
        BRANCH,
        ALL;

    }
}

