/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.PopupDialog;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.IconFont;

public class ButtonSelectorPanel {
    private static final Action CLICK = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JToggleButton)e.getSource()).doClick();
        }
    };
    private final JPanel buttonPanel;
    private final Vector<String> possibleValues = new Vector();
    private final Vector<JToggleButton> buttons;
    private int selectedIndex = 0;
    private Runnable callback;
    private static final String RESET_RESOURCE = "reset_property_text";
    private static final String TEXT = TextUtils.getText("reset_property_text");

    public static Vector<Object> translate(String[] possibles) {
        Vector<Object> displayedItems = new Vector<Object>(possibles.length);
        for (int i = 0; i < possibles.length; ++i) {
            String alternativeKey = possibles[i];
            String alternativeText = TextUtils.getText(alternativeKey, null);
            String key = "OptionPanel." + alternativeKey;
            String text = alternativeText != null ? TextUtils.getText(key, alternativeText) : TextUtils.getText(key);
            displayedItems.add(text);
        }
        return displayedItems;
    }

    public ButtonSelectorPanel(Collection<String> values, Collection<ButtonIcon> displayedItems) {
        this.possibleValues.addAll(values);
        this.buttonPanel = new JPanel(ToolbarLayout.fix());
        this.buttonPanel.addComponentListener(SizeChanger.INSTANCE);
        this.buttons = new Vector(displayedItems.size());
        int i = 0;
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke("ENTER");
        KeyStroke spaceKeyStroke = KeyStroke.getKeyStroke("SPACE");
        JToggleButton prototypeButton = null;
        for (ButtonIcon item : displayedItems) {
            JToggleButton button = prototypeButton = new JToggleButton(item.icon);
            button.setName(item.name);
            button.setToolTipText(item.tooltip);
            this.buttons.add(button);
            int buttonIndex = i++;
            button.addActionListener(event -> {
                this.setSelected(button);
                this.selectedIndex = buttonIndex;
                if (this.callback != null) {
                    this.callback.run();
                }
            });
            button.getInputMap().put(enterKeyStroke, "ON_CLICK");
            button.getInputMap().put(spaceKeyStroke, "ON_CLICK");
            button.getActionMap().put("ON_CLICK", CLICK);
            if (item.componentBefore == ComponentBefore.SEPARATOR) {
                this.buttonPanel.add(new JSeparator());
            }
            this.buttonPanel.add(button);
        }
        this.addRevertButton(prototypeButton);
    }

    private void addRevertButton(AbstractButton sizePrototype) {
        JButton button = new JButton();
        button.setPreferredSize(sizePrototype.getPreferredSize());
        button.setFont(IconFont.FONT.deriveFont(0.8f * (float)sizePrototype.getIcon().getIconHeight()));
        JButton revertButton = button;
        revertButton.setText("\ue901");
        revertButton.setToolTipText(TEXT);
        revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonSelectorPanel.this.selectedIndex = -1;
                if (ButtonSelectorPanel.this.callback != null) {
                    ButtonSelectorPanel.this.callback.run();
                }
            }
        });
        this.buttonPanel.add(revertButton);
    }

    private void setSelected(JToggleButton button) {
        this.buttons.forEach(b -> b.setSelected(b == button));
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    public String getValue() {
        return this.selectedIndex >= 0 ? this.possibleValues.get(this.selectedIndex) : null;
    }

    public Vector<String> getPossibleValues() {
        return this.possibleValues;
    }

    public void setEnabled(boolean pEnabled) {
        this.buttons.forEach(b -> b.setEnabled(pEnabled));
    }

    public void setValue(String value) {
        int index;
        this.selectedIndex = index = this.indexOf(value);
        if (this.selectedIndex >= 0) {
            this.setSelected(this.buttons.elementAt(this.selectedIndex));
        }
    }

    public JToggleButton getSelectedButton() {
        return this.buttons.get(this.selectedIndex >= 0 ? this.selectedIndex : this.buttons.size() - 1);
    }

    public JToggleButton getButton(String value) {
        int index = this.indexOf(value);
        return index >= 0 ? this.buttons.elementAt(index) : null;
    }

    public int indexOf(String value) {
        if (this.possibleValues.contains(value)) {
            int index = this.possibleValues.indexOf(value);
            return index;
        }
        LogUtils.severe("Can't find value:" + value + " in buttons containing values " + this.possibleValues);
        if (this.possibleValues.size() > 0) {
            return 0;
        }
        return -1;
    }

    public Component getButtonPanel() {
        return this.buttonPanel;
    }

    public void showButtonDialog(Component parentComponent, Runnable callback) {
        EventQueue.invokeLater(() -> this.showButtonDialogNow(parentComponent, callback));
    }

    private void showButtonDialogNow(Component parentComponent, Runnable callback) {
        Window owner = SwingUtilities.getWindowAncestor(parentComponent);
        JDialog dialog = new JDialog(owner, Dialog.ModalityType.MODELESS);
        dialog.setResizable(false);
        dialog.setUndecorated(true);
        dialog.getRootPane().applyComponentOrientation(owner.getComponentOrientation());
        dialog.getContentPane().add(this.getButtonPanel());
        PopupDialog.closeWhenOwnerIsFocused(dialog);
        PopupDialog.closeOnEscape(dialog);
        Point eventLocation = new Point(0, parentComponent.getHeight());
        SwingUtilities.convertPointToScreen(eventLocation, parentComponent);
        dialog.pack();
        UITools.setBounds(dialog, eventLocation.x, eventLocation.y, dialog.getWidth(), dialog.getHeight());
        JToggleButton selectedButton = this.getSelectedButton();
        selectedButton.requestFocusInWindow();
        this.setCallback(() -> {
            dialog.dispose();
            callback.run();
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ButtonSelectorPanel.this.setCallback(null);
            }
        });
        dialog.setVisible(true);
    }

    private static class SizeChanger
    extends ComponentAdapter {
        static final SizeChanger INSTANCE = new SizeChanger();

        private SizeChanger() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component component = e.getComponent();
            Dimension preferredSize = component.getPreferredSize();
            int width = component.getWidth();
            int height = component.getHeight();
            if (width != preferredSize.width || height != preferredSize.height) {
                component.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
                component.revalidate();
            }
        }
    }

    public static class ButtonIcon {
        public final Icon icon;
        public final String tooltip;
        public final ComponentBefore componentBefore;
        public final String name;

        public ButtonIcon(String name, Icon icon, String tooltip, ComponentBefore componentBefore) {
            this.name = name;
            this.icon = icon;
            this.tooltip = tooltip;
            this.componentBefore = componentBefore;
        }
    }

    public static enum ComponentBefore {
        NOTHING,
        SEPARATOR;

    }
}

