/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileFilter;

public class CaseSensitiveFileNameExtensionFilter
extends FileFilter {
    private String description = null;
    private String fullDescription = null;
    private String mainExtension = null;
    private boolean useExtensionsInDescription = true;
    private HashSet<String> extensions = new LinkedHashSet<String>();

    public CaseSensitiveFileNameExtensionFilter() {
    }

    public CaseSensitiveFileNameExtensionFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public CaseSensitiveFileNameExtensionFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.extensions.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        if (this.mainExtension == null) {
            this.mainExtension = extension;
        }
        this.extensions.add(extension.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                this.fullDescription = this.fullDescription + this.extensions.stream().collect(Collectors.joining(", .", ".", ""));
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    private String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public String getExtensionProposal() {
        return this.mainExtension;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }
}

