/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.commandsearch.IconItem;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;

public class IconIndexer {
    private List<IconItem> iconItems = new LinkedList<IconItem>();

    IconIndexer() {
        this.load();
    }

    public List<IconItem> getIconItems() {
        return this.iconItems;
    }

    private void load() {
        MIconController iconController = (MIconController)IconController.getController();
        Map iconActions = iconController.getAllIconActions();
        for (IconGroup iconGroup : IconStoreFactory.ICON_STORE.getGroups()) {
            this.addIconGroup("", iconGroup, iconActions);
        }
    }

    private void addIconGroup(String prefix, IconGroup group, Map<String, AFreeplaneAction> iconActions) {
        if (group.getIcons().size() < 1) {
            return;
        }
        String groupPath = prefix + group.getDescription();
        String subgroupPrefix = groupPath + "->";
        for (IconGroup childGroup : group.getGroups()) {
            if (childGroup.isLeaf()) {
                MindIcon mindIcon = childGroup.getGroupIcon();
                AFreeplaneAction action = iconActions.get(mindIcon.getName());
                IconItem iconItem = new IconItem(mindIcon.getIcon(), action, action.getRawText(), groupPath);
                this.iconItems.add(iconItem);
                continue;
            }
            this.addIconGroup(subgroupPrefix, childGroup, iconActions);
        }
    }
}

