/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.commandsearch.PreferencesItem;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class PreferencesIndexer {
    private final List<String> path;
    private final List<PreferencesItem> prefs = new LinkedList<PreferencesItem>();

    public PreferencesIndexer() {
        this.path = new ArrayList<String>(2);
        this.load();
    }

    public List<PreferencesItem> getPrefs() {
        return this.prefs;
    }

    private void load() {
        Controller controller = Controller.getCurrentController();
        MModeController modeController = (MModeController)controller.getModeController("MindMap");
        OptionPanelBuilder optionPanelBuilder = modeController.getOptionPanelBuilder();
        DefaultMutableTreeNode node = optionPanelBuilder.getRoot();
        this.load(node, 0);
    }

    public void load(TreeNode parent, int level) {
        Enumeration<? extends TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            IPropertyControlCreator userObject = (IPropertyControlCreator)child.getUserObject();
            if (userObject != null) {
                String propertyName = userObject.getPropertyName();
                String translatedText = HtmlUtils.htmlToPlain(userObject.getTranslatedText());
                if (!propertyName.isEmpty()) {
                    if (ResourceController.getResourceController().getBooleanProperty(propertyName + ".hide")) continue;
                    String tooltipText = HtmlUtils.htmlToPlain(userObject.getTranslatedTooltipText());
                    String currentTabTranslated = this.path.get(0);
                    if (this.path.size() > 1) {
                        String currentSeparatorTranslated = this.path.get(1);
                        if (parent.getChildCount() < 20) {
                            String prefPath = currentSeparatorTranslated + "->" + translatedText;
                            this.prefs.add(new PreferencesItem(currentTabTranslated, propertyName, prefPath, tooltipText));
                        } else {
                            this.prefs.add(new PreferencesItem(currentTabTranslated, propertyName, translatedText, tooltipText));
                        }
                    } else {
                        this.prefs.add(new PreferencesItem(currentTabTranslated, propertyName, translatedText, tooltipText));
                    }
                } else {
                    this.path.add(translatedText);
                }
                if (level < 2) {
                    this.load(child, level + 1);
                }
                if (!propertyName.isEmpty()) continue;
                this.path.remove(this.path.size() - 1);
                continue;
            }
            this.load(child, level);
        }
    }
}

