/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.AliasCondition;
import org.freeplane.features.filter.StringMatchingStrategy;

class AliasEqualsCondition
extends AliasCondition {
    public static final String NAME = "alias_equals";
    private final StringMatchingStrategy stringMatchingStrategy;

    AliasEqualsCondition(String alias, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(alias, matchCase, matchApproximately, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkAlias(String alias) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(alias), false);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_alias");
        String simpleCondition = TextUtils.getText("filter_is_equal_to");
        return this.createDescription(condition, simpleCondition, this.getAlias());
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

