/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.menubuilders.menu.JUnitPanel;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionNotSatisfiedDecorator;
import org.freeplane.features.filter.condition.DecoratedConditionFactory;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;

public class FilterConditionEditor {
    private static final String PROPERTY_FILTER_MATCH_CASE = "filter_match_case";
    private static final String PROPERTY_FILTER_APPROXIMATE_MATCH = "filter_match_approximately";
    private static final String PROPERTY_FILTER_IGNORE_DIACRITICS = "filter_ignore_diacritics";
    private static final String PROPERTY_FILTER_DENY = "filter_deny";
    private static final DecoratedConditionFactory DECORATED_CONDITION_FACTORY = new DecoratedConditionFactory();
    private final JToggleButton caseSensitive;
    private final JToggleButton approximateMatching;
    private final JToggleButton ignoreDiacritics;
    private final JComboBox filterTargetSelector;
    private final JComboBox elementaryConditions;
    private final FilterController filterController;
    private final JComboBox filteredPropertiesComponent;
    private final ExtendedComboBoxModel filteredPropertiesModel;
    private WeakReference<Filter> lastFilter;
    private final JComboBox values;
    private ActionListener enterKeyActionListener;
    private final JToggleButton btnDeny;
    private final JComponent panel = new JPanel(new GridBagLayout());
    private final JComponent optionPanel;

    private void setValuesEnterKeyListener() {
        if (this.enterKeyActionListener != null) {
            this.values.getEditor().removeActionListener(this.enterKeyActionListener);
            this.values.getEditor().addActionListener(this.enterKeyActionListener);
        }
    }

    public void setSearchingBusyCursor() {
        RootPaneContainer root = (RootPaneContainer)((Object)this.panel.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        root.getGlassPane().setVisible(true);
    }

    public void setSearchingDefaultCursor() {
        RootPaneContainer root = (RootPaneContainer)((Object)this.panel.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        root.getGlassPane().setVisible(false);
    }

    private void setValuesEditor() {
        Object selectedProperty = this.filteredPropertiesComponent.getSelectedItem();
        IElementaryConditionController conditionController = this.filterController.getConditionFactory().getConditionController(selectedProperty);
        TranslatedObject selectedCondition = (TranslatedObject)this.elementaryConditions.getSelectedItem();
        boolean canSelectValues = conditionController.canSelectValues(selectedProperty, selectedCondition);
        this.values.setEnabled(canSelectValues);
        this.values.setEditable(false);
        this.values.setModel(conditionController.getValuesForProperty(selectedProperty, selectedCondition));
        ComboBoxEditor valueEditor = conditionController.getValueEditor(selectedProperty, selectedCondition);
        this.values.setEditor(valueEditor != null ? valueEditor : new FixedBasicComboBoxEditor());
        this.setValuesEnterKeyListener();
        ListCellRenderer valueRenderer = conditionController.getValueRenderer(selectedProperty, selectedCondition);
        this.values.setRenderer(valueRenderer != null ? valueRenderer : this.filterController.getConditionRenderer());
        this.values.setEditable(conditionController.canEditValues(selectedProperty, selectedCondition));
        if (this.values.getModel().getSize() > 0) {
            this.values.setSelectedIndex(0);
        }
        this.caseSensitive.setEnabled(canSelectValues && conditionController.isCaseDependent(selectedProperty, selectedCondition));
        this.approximateMatching.setEnabled(canSelectValues && conditionController.supportsApproximateMatching(selectedProperty, selectedCondition));
        this.ignoreDiacritics.setEnabled(canSelectValues && conditionController.supportsApproximateMatching(selectedProperty, selectedCondition));
    }

    public FilterConditionEditor(FilterController filterController, Variant variant) {
        this(filterController, 5, variant);
    }

    public FilterConditionEditor(FilterController filterController, int borderWidth, Variant variant) {
        this(filterController, borderWidth, variant, new FreeplaneToolBar(0));
    }

    public FilterConditionEditor(FilterController filterController, int borderWidth, Variant variant, JComponent optionPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, borderWidth, 0, borderWidth);
        this.filterController = filterController;
        if (variant == Variant.FILTER_COMPOSER) {
            this.filterTargetSelector = JComboBoxFactory.create();
            this.filterTargetSelector.setEditable(false);
            this.filterTargetSelector.setModel(new DefaultComboBoxModel<TranslatedObject>(DECORATED_CONDITION_FACTORY.getKeys()));
            GridBagConstraints constraintVariant = (GridBagConstraints)gridBagConstraints.clone();
            constraintVariant.fill = 2;
            constraintVariant.gridheight = 2;
            this.panel.add((Component)this.filterTargetSelector, constraintVariant);
        } else {
            this.filterTargetSelector = null;
        }
        this.filteredPropertiesComponent = JComboBoxFactory.create();
        this.filteredPropertiesModel = new ExtendedComboBoxModel();
        this.filteredPropertiesComponent.setModel(this.filteredPropertiesModel);
        this.filteredPropertiesComponent.addItemListener(new FilteredPropertyChangeListener());
        this.filteredPropertiesComponent.setRenderer(filterController.getConditionRenderer());
        this.panel.add((Component)this.filteredPropertiesComponent, gridBagConstraints);
        this.elementaryConditions = JComboBoxFactory.create();
        this.elementaryConditions.addItemListener(new ElementaryConditionChangeListener());
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.elementaryConditions, gridBagConstraints);
        this.elementaryConditions.setRenderer(filterController.getConditionRenderer());
        this.values = JComboBoxFactory.create();
        this.values.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        gridBagConstraints.gridy = 0;
        this.panel.add((Component)this.values, gridBagConstraints);
        this.values.setEditable(true);
        this.setValuesEnterKeyListener();
        this.optionPanel = optionPanel;
        this.caseSensitive = TranslatedElementFactory.createToggleButtonWithIcon("filter_match_case.icon", "filter_match_case.tooltip");
        this.caseSensitive.setModel(filterController.getCaseSensitiveButtonModel());
        optionPanel.add((Component)this.caseSensitive, gridBagConstraints);
        this.caseSensitive.setSelected(ResourceController.getResourceController().getBooleanProperty(PROPERTY_FILTER_MATCH_CASE));
        this.approximateMatching = TranslatedElementFactory.createToggleButtonWithIcon("filter_match_approximately.icon", "filter_match_approximately.tooltip");
        this.approximateMatching.setModel(filterController.getApproximateMatchingButtonModel());
        optionPanel.add((Component)this.approximateMatching, gridBagConstraints);
        this.approximateMatching.setSelected(ResourceController.getResourceController().getBooleanProperty(PROPERTY_FILTER_APPROXIMATE_MATCH));
        this.ignoreDiacritics = TranslatedElementFactory.createToggleButtonWithIcon("filter_ignore_diacritics.icon", "filter_ignore_diacritics.tooltip");
        this.ignoreDiacritics.setModel(filterController.getIgnoreDiacriticsButtonModel());
        optionPanel.add((Component)this.ignoreDiacritics, gridBagConstraints);
        this.ignoreDiacritics.setSelected(ResourceController.getResourceController().getBooleanProperty(PROPERTY_FILTER_IGNORE_DIACRITICS));
        this.btnDeny = TranslatedElementFactory.createToggleButtonWithIcon("filter_deny.icon", "filter_deny.tooltip");
        optionPanel.add((Component)this.btnDeny, gridBagConstraints);
        if (variant != Variant.FILTER_TOOLBAR) {
            gridBagConstraints.weightx = 1.0;
            optionPanel.add((Component)new JUnitPanel(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panel.add((Component)optionPanel, gridBagConstraints);
        IMapSelection selection = Controller.getCurrentController().getSelection();
        this.filterChanged(selection != null ? selection.getFilter() : null);
    }

    public void focusInputField(boolean selectAll) {
        if (this.values.isEnabled()) {
            this.values.requestFocus();
            Component editorComponent = this.values.getEditor().getEditorComponent();
            if (selectAll && editorComponent instanceof JTextComponent) {
                ((JTextComponent)editorComponent).selectAll();
            }
            return;
        }
    }

    public boolean isInputFieldFocused() {
        if (this.values.isFocusOwner()) {
            return true;
        }
        return this.values.isPopupVisible() || this.values.getEditor().getEditorComponent().isFocusOwner();
    }

    public ASelectableCondition getCondition() {
        Object value = this.values.isEditable() ? this.values.getEditor().getItem() : this.values.getSelectedItem();
        if (value == null) {
            value = "";
        }
        TranslatedObject simpleCond = (TranslatedObject)this.elementaryConditions.getSelectedItem();
        boolean matchCase = this.caseSensitive.isSelected();
        boolean matchApproximately = this.approximateMatching.isSelected();
        ResourceController.getResourceController().setProperty(PROPERTY_FILTER_MATCH_CASE, matchCase);
        Object selectedItem = this.filteredPropertiesComponent.getSelectedItem();
        ASelectableCondition newCond = this.filterController.getConditionFactory().createCondition(selectedItem, simpleCond, value, matchCase, matchApproximately, this.ignoreDiacritics.isSelected());
        if (this.values.isEditable() && !value.equals("")) {
            DefaultComboBoxModel list = (DefaultComboBoxModel)this.values.getModel();
            int indexOfValue = list.getIndexOf(value);
            if (indexOfValue > 0) {
                list.removeElementAt(indexOfValue);
            }
            if (indexOfValue == -1 || list.getIndexOf(value) != indexOfValue) {
                this.values.insertItemAt(value, 0);
                this.values.setSelectedIndex(0);
            } else if (indexOfValue != -1) {
                this.values.setSelectedIndex(indexOfValue);
            }
            if (this.values.getItemCount() >= 10) {
                this.values.removeItemAt(9);
            }
        }
        return this.decorate(newCond);
    }

    private ASelectableCondition decorate(ASelectableCondition decoratedCondition) {
        if (decoratedCondition == null) {
            return decoratedCondition;
        }
        if (this.filterTargetSelector != null) {
            decoratedCondition = DECORATED_CONDITION_FACTORY.createRelativeCondition((TranslatedObject)this.filterTargetSelector.getSelectedItem(), decoratedCondition);
        }
        if (this.btnDeny.isSelected()) {
            decoratedCondition = new ConditionNotSatisfiedDecorator(decoratedCondition);
        }
        return decoratedCondition;
    }

    public void filterChanged(Filter newFilter) {
        if (newFilter != null) {
            if (this.lastFilter != null && this.lastFilter.get() == newFilter) {
                return;
            }
            this.filteredPropertiesModel.removeAllElements();
            Iterator<IElementaryConditionController> conditionIterator = this.filterController.getConditionFactory().conditionIterator();
            while (conditionIterator.hasNext()) {
                IElementaryConditionController next = conditionIterator.next();
                this.filteredPropertiesModel.addExtensionList(next.getFilteredProperties());
                this.filteredPropertiesModel.setSelectedItem(this.filteredPropertiesModel.getElementAt(0));
            }
        } else {
            this.filteredPropertiesComponent.setSelectedIndex(-1);
            this.filteredPropertiesModel.setExtensionList(null);
        }
        this.lastFilter = new WeakReference<Filter>(newFilter);
    }

    public void setEnterKeyActionListener(ActionListener enterKeyActionListener) {
        if (enterKeyActionListener == null) {
            throw new NullPointerException("null value in setEnterKeyActionListener()!");
        }
        if (this.enterKeyActionListener != null) {
            this.values.getEditor().removeActionListener(this.enterKeyActionListener);
        }
        this.enterKeyActionListener = enterKeyActionListener;
        this.values.getEditor().addActionListener(enterKeyActionListener);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public JComponent getOptionPanel() {
        return this.optionPanel;
    }

    public void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component c = this.panel.getComponent(i);
            c.setEnabled(enabled);
            if (!(c instanceof JComboBox)) continue;
            ((JComboBox)c).getEditor().getEditorComponent().setEnabled(enabled);
        }
    }

    public static enum Variant {
        FILTER_TOOLBAR,
        FILTER_COMPOSER,
        NODE_CONDITION,
        SEARCH_DIALOG;

    }

    private class FilteredPropertyChangeListener
    implements ItemListener {
        private FilteredPropertyChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object selectedProperty = FilterConditionEditor.this.filteredPropertiesComponent.getSelectedItem();
                IElementaryConditionController conditionController = FilterConditionEditor.this.filterController.getConditionFactory().getConditionController(selectedProperty);
                ComboBoxModel simpleConditionComboBoxModel = conditionController.getConditionsForProperty(selectedProperty);
                FilterConditionEditor.this.elementaryConditions.setModel(simpleConditionComboBoxModel);
                FilterConditionEditor.this.elementaryConditions.setEnabled(simpleConditionComboBoxModel.getSize() > 0);
                FilterConditionEditor.this.setValuesEditor();
                return;
            }
        }
    }

    private class ElementaryConditionChangeListener
    implements ItemListener {
        private ElementaryConditionChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FilterConditionEditor.this.setValuesEditor();
            }
        }
    }
}

