/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.CopyIDAction;
import org.freeplane.features.map.clipboard.CopyNodeURIAction;
import org.freeplane.features.map.clipboard.CopySingleAction;
import org.freeplane.features.map.clipboard.MindMapHTMLWriter;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.clipboard.MindMapPlainTextWriter;
import org.freeplane.features.map.clipboard.SingleCopySource;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;

public class MapClipboardController
implements IExtension,
ClipboardController,
INodeDuplicator {
    public static final String NODESEPARATOR = "<nodeseparator>";
    private final ModeController modeController;

    public static MapClipboardController getController() {
        return Controller.getCurrentModeController().getExtension(MapClipboardController.class);
    }

    public static void install(MapClipboardController clipboardController) {
        Controller.getCurrentModeController().addExtension(MapClipboardController.class, clipboardController);
    }

    public MapClipboardController(ModeController modeController) {
        this.modeController = modeController;
        this.createActions();
    }

    public void setClipboardContents(Transferable transferable) {
        ClipboardAccessor.getInstance().setClipboardContents(transferable);
    }

    public MindMapNodesSelection copy(Collection<NodeModel> selectedNodes) {
        try {
            String forNodesFlavor = this.createForNodesFlavor(selectedNodes);
            String plainText = MindMapPlainTextWriter.INSTANCE.getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getAsHTML(selectedNodes));
        }
        catch (UnsupportedFlavorException ex) {
            LogUtils.severe(ex);
        }
        catch (IOException ex) {
            LogUtils.severe(ex);
        }
        return null;
    }

    public Transferable copy(IMapSelection selection) {
        return this.copy(selection.getSortedSelection(true));
    }

    public Transferable copy(NodeModel node) {
        StringWriter stringWriter = new StringWriter();
        try {
            Controller.getCurrentModeController().getMapController().getMapWriter().writeNodeAsXml(stringWriter, node, MapWriter.Mode.CLIPBOARD, true, true, false);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
        return new MindMapNodesSelection(stringWriter.toString());
    }

    public Transferable copySingle(Collection<NodeModel> source) {
        int size = source.size();
        Vector<NodeModel> target = new Vector<NodeModel>(size);
        target.setSize(size);
        int i = 0;
        for (NodeModel node : source) {
            target.set(i, new SingleCopySource(node));
            ++i;
        }
        return this.copy(target);
    }

    private void createActions() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        modeController.addAction(new CopySingleAction());
        if (!Compat.isApplet()) {
            modeController.addAction(new CopyIDAction());
        }
        modeController.addAction(new CopyNodeURIAction());
    }

    public String createForNodesFlavor(Collection<NodeModel> selectedNodes) throws UnsupportedFlavorException, IOException {
        String forNodesFlavor = "";
        boolean firstLoop = true;
        for (NodeModel tmpNode : selectedNodes) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                forNodesFlavor = forNodesFlavor + NODESEPARATOR;
            }
            forNodesFlavor = forNodesFlavor + this.copy(tmpNode).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
        }
        return forNodesFlavor;
    }

    public String getAsHTML(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            try (BufferedWriter fileout = new BufferedWriter(stringWriter);){
                this.writeHTML(selectedNodes, fileout);
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public void saveHTML(NodeModel rootNodeOfBranch, File file) throws IOException {
        this.saveHTML(Collections.singletonList(rootNodeOfBranch), file);
    }

    public void saveHTML(List<NodeModel> branchRootNodes, File file) throws IOException {
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.configureCharset("UTF-8");
        htmlWriter.writeHTML(branchRootNodes);
    }

    @Override
    public NodeModel duplicate(NodeModel source, MapModel targetMap, boolean withChildren) {
        try {
            StringWriter writer = new StringWriter();
            MapWriter.Mode copyMode = source.getUserObject() instanceof IStyle ? MapWriter.Mode.STYLE : MapWriter.Mode.CLIPBOARD;
            this.modeController.getMapController().getMapWriter().writeNodeAsXml(writer, source, copyMode, true, withChildren, false);
            String result = writer.toString();
            NodeModel copy = this.modeController.getMapController().getMapReader().createNodeTreeFromXml(targetMap, (Reader)new StringReader(result), copyMode);
            copy.setFolded(false);
            return copy;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public void writeHTML(Collection<NodeModel> selectedNodes, Writer fileout) throws IOException {
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.writeHTML(selectedNodes);
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy() {
        Transferable copy;
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        if (selection != null && (copy = this.copy(selection)) != null) {
            ClipboardAccessor.getInstance().setClipboardContents(copy);
        }
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

