/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.RectanglePainter;

class BubblePainter
extends RectanglePainter {
    BubblePainter(MainView mainView, NodeGeometryModel shapeConfiguration) {
        super(mainView, shapeConfiguration);
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        int zoomedEdgeWidth = (int)this.mainView.getPaintedBorderWidth();
        int arcWidth = this.getArcWidth();
        g.drawRoundRect(zoomedEdgeWidth / 2, zoomedEdgeWidth / 2, this.mainView.getWidth() - zoomedEdgeWidth, this.mainView.getHeight() - zoomedEdgeWidth, arcWidth, arcWidth);
    }

    private int getArcWidth() {
        int minimumArcWidth = this.mainView.getNodeView().getMap().getZoomed(10);
        return minimumArcWidth;
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        int arcWidth = this.getArcWidth();
        graphics.fillRoundRect(0, 0, this.mainView.getWidth(), this.mainView.getHeight(), arcWidth, arcWidth);
    }
}

