/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MainViewPainter;
import org.freeplane.view.swing.map.NodeView;

class ForkPainter
extends MainViewPainter {
    private static final int SINGLE_CHILD_SHIFT = -2;

    ForkPainter(MainView mainView) {
        super(mainView);
    }

    @Override
    Point getLeftPoint() {
        int edgeWidth = (int)this.mainView.getPaintedBorderWidth();
        Point in = new Point(0, this.mainView.getHeight() - edgeWidth / 2);
        return in;
    }

    @Override
    int getMainViewHeightWithFoldingMark(boolean onlyFolded) {
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.usesHorizontalLayout()) {
            return super.getMainViewHeightWithFoldingMark(onlyFolded);
        }
        int height = this.mainView.getHeight();
        if (!onlyFolded || nodeView.isFolded()) {
            height += this.mainView.getZoomedFoldingMarkHalfWidth();
        }
        return height;
    }

    @Override
    public Point getRightPoint() {
        int edgeWidth = (int)this.mainView.getPaintedBorderWidth();
        Point in = new Point(this.mainView.getWidth() - 1, this.mainView.getHeight() - edgeWidth / 2);
        return in;
    }

    @Override
    void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.getModel() == null) {
            return;
        }
        this.mainView.paintBackgound(g);
        this.mainView.paintDragOver(g);
        super.paintComponent(g);
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.mainView.getWidth(), this.mainView.getHeight() - (int)this.mainView.getPaintedBorderWidth());
    }

    @Override
    void paintDecoration(NodeView nodeView, Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(UITools.createStroke(this.mainView.getPaintedBorderWidth(), this.mainView.getDash().variant, 0));
        Color oldColor = g.getColor();
        g.setColor(this.mainView.getBorderColor());
        Point leftLinePoint = this.getLeftPoint();
        g.drawLine(leftLinePoint.x, leftLinePoint.y, leftLinePoint.x + this.mainView.getWidth(), leftLinePoint.y);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        super.paintDecoration(nodeView, g);
    }

    @Override
    Insets getInsets() {
        return this.getInsets(null);
    }

    @Override
    Insets getInsets(Insets insets) {
        NodeView nodeView = this.mainView.getNodeView();
        int edgeWidth = nodeView.getEdgeWidth();
        edgeWidth = Math.round(this.mainView.getUnzoomedBorderWidth());
        if (insets == null) {
            insets = new Insets(0, 2, edgeWidth, 2);
        } else {
            insets.set(0, 2, edgeWidth, 2);
        }
        return insets;
    }

    @Override
    int getSingleChildShift() {
        return -2;
    }

    @Override
    NodeGeometryModel getShapeConfiguration() {
        return NodeGeometryModel.FORK;
    }
}

