/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

class NodeViewLayoutHelper {
    private NodeView view;
    private int topOverlap;
    private int bottomOverlap;

    NodeViewLayoutHelper(NodeView view) {
        this.view = view;
    }

    Dimension calculateContentSize() {
        Dimension contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(this.view);
        return this.usesHorizontallayout(this.view.getContent()) ? new Dimension(contentSize.height, contentSize.width) : contentSize;
    }

    int getAdditionalCloudHeigth() {
        return CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(this.view);
    }

    int getComponentCount() {
        return this.view.getComponentCount();
    }

    NodeViewLayoutHelper getComponent(int n) {
        Component component = this.view.getComponent(n);
        return component instanceof NodeView ? ((NodeView)component).getLayoutHelper() : null;
    }

    MapView getMap() {
        return this.view.getMap();
    }

    NodeModel getModel() {
        return this.view.getModel();
    }

    int getMinimalDistanceBetweenChildren() {
        return this.view.getMinimalDistanceBetweenChildren();
    }

    int getBaseDistanceToChildren() {
        return this.view.getBaseDistanceToChildren();
    }

    int getSpaceAround() {
        return this.view.getSpaceAround();
    }

    ChildNodesAlignment getChildNodesAlignment() {
        return this.view.getChildNodesAlignment();
    }

    int getContentX() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getY() : ((Component)component).getX();
    }

    int getContentY() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getX() : ((Component)component).getY();
    }

    int getContentYForSummary() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(component) ? ((Component)component).getX() : ((Component)component).getY();
    }

    int getContentWidth() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getHeight() : ((Component)component).getWidth();
    }

    int getContentHeight() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getWidth() : ((Component)component).getHeight();
    }

    void setContentBounds(int x, int y, int width, int height) {
        JComponent component = this.view.getContent();
        if (this.usesHorizontallayout(component)) {
            component.setBounds(y, x, height, width);
        } else {
            component.setBounds(x, y, width, height);
        }
    }

    void setContentVisible(boolean aFlag) {
        this.view.getContent().setVisible(aFlag);
    }

    boolean isContentVisible() {
        return this.view.isContentVisible();
    }

    boolean isFolded() {
        return this.view.isFolded();
    }

    boolean isSummary() {
        return this.view.isSummary();
    }

    boolean isFirstGroupNode() {
        return this.view.isFirstGroupNode();
    }

    boolean usesHorizontalLayout() {
        return this.view.usesHorizontalLayout();
    }

    boolean isLeft() {
        return this.view.isTopOrLeft();
    }

    int getHGap() {
        return this.view.getHGap();
    }

    int getShift() {
        return this.view.getShift();
    }

    boolean isFree() {
        return this.view.isFree();
    }

    int getTopOverlap() {
        return this.topOverlap;
    }

    void setTopOverlap(int topOverlap) {
        this.topOverlap = topOverlap;
    }

    int getBottomOverlap() {
        return this.bottomOverlap;
    }

    void setBottomOverlap(int bottomOverlap) {
        this.bottomOverlap = bottomOverlap;
    }

    NodeViewLayoutHelper getParentView() {
        NodeView parentView = this.view.getParentView();
        return parentView != null ? parentView.getLayoutHelper() : null;
    }

    int getZoomed(int i) {
        return this.view.getZoomed(i);
    }

    int getHeight() {
        return this.getHeight(this.view);
    }

    int getWidth() {
        return this.getWidth(this.view);
    }

    int getX() {
        return this.getX(this.view);
    }

    int getY() {
        return this.getY(this.view);
    }

    void setSize(int width, int height) {
        if (this.usesHorizontallayout(this.view.getContent())) {
            this.view.setSize(height, width);
        } else {
            this.view.setSize(width, height);
        }
    }

    void setLocation(int x, int y) {
        if (this.usesHorizontallayout(this.view)) {
            this.view.setLocation(y, x);
        } else {
            this.view.setLocation(x, y);
        }
    }

    private int getX(Component component) {
        return this.usesHorizontallayout(component) ? component.getY() : component.getX();
    }

    private int getY(Component component) {
        return this.usesHorizontallayout(component) ? component.getX() : component.getY();
    }

    private int getWidth(Component component) {
        return this.usesHorizontallayout(component) ? component.getHeight() : component.getWidth();
    }

    private int getHeight(Component component) {
        return this.usesHorizontallayout(component) ? component.getWidth() : component.getHeight();
    }

    String describeComponent(int i) {
        return this.view.getComponent(i).toString();
    }

    String getText() {
        return this.view.getModel().getText();
    }

    boolean usesHorizontallayout(Component component) {
        NodeView parent = component == this.view && this.view.isRoot() ? this.view : (NodeView)component.getParent();
        return parent.usesHorizontalLayout();
    }

    int getMinimumDistanceConsideringHandles() {
        return this.view.getMinimumDistanceConsideringHandles();
    }

    boolean paintsChildrenOnTheLeft() {
        return this.view.paintsChildrenOnTheLeft();
    }

    public String toString() {
        return "NodeViewLayoutHelper [view=" + this.view + "]";
    }

    ChildrenSides childrenSides() {
        return this.view.childrenSides();
    }

    boolean isSubtreeVisible() {
        return this.view.isSubtreeVisible();
    }
}

