/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.VariableInsetsPainter;

class WideHexagonPainter
extends VariableInsetsPainter {
    private static final double VERTICAL_MARGIN_FACTOR = Math.sqrt(2.0);
    private static final double UNIFORM_HEIGHT_TO_WIDTH_RELATION = Math.sqrt(3.0) / 2.0;
    private static final double HORIZONTAL_MARGIN_FACTOR = Math.sqrt(2.0) / UNIFORM_HEIGHT_TO_WIDTH_RELATION;

    WideHexagonPainter(MainView mainView, NodeGeometryModel shapeConfigurationModel) {
        super(mainView, shapeConfigurationModel);
    }

    @Override
    double getVerticalMarginFactor() {
        return VERTICAL_MARGIN_FACTOR;
    }

    @Override
    double getHorizontalMarginFactor() {
        return HORIZONTAL_MARGIN_FACTOR;
    }

    @Override
    Dimension getPreferredSize() {
        if (this.mainView.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.mainView.getMaximumWidth());
            double w = (double)prefSize.width + this.getMinimumHorizontalInset();
            double h = (double)prefSize.height + this.getMinimumVerticalInset();
            double diameter = Math.sqrt(w * w + h * h);
            double width = this.mainView.limitWidth(diameter / UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            prefSize.width = (int)Math.ceil(width);
            prefSize.height = (int)(width * UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        Polygon polygon = this.getPaintedShape();
        g.draw(polygon);
    }

    Polygon getPaintedShape() {
        double[] yCoords;
        double[] xCoords;
        if (this.getShapeConfiguration().isUniform()) {
            xCoords = new double[]{0.0, 0.25, 0.75, 1.0, 0.75, 0.25};
            yCoords = new double[]{0.5, 0.0, 0.0, 0.5, 1.0, 1.0};
        } else {
            double zoomedHorizontalInset = (1.0 - 1.0 / this.getHorizontalMarginFactor()) / 2.0;
            xCoords = new double[]{0.0, zoomedHorizontalInset, 1.0 - zoomedHorizontalInset, 1.0, 1.0 - zoomedHorizontalInset, zoomedHorizontalInset};
            yCoords = new double[]{0.5, 0.0, 0.0, 0.5, 1.0, 1.0};
        }
        return this.polygonOf(xCoords, yCoords);
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fill(this.getPaintedShape());
    }
}

