/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormattedFormula;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeView;

public class AttributePanelManager {
    private final JPanel tablePanel;
    private ModeController modeController;
    private int axis = 1;

    public AttributePanelManager(ModeController modeController) {
        this.modeController = modeController;
        this.tablePanel = new JPanel();
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
        this.tablePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.tablePanel.setAlignmentX(0.5f);
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, this.axis));
        TableCreator tableCreator = new TableCreator();
        MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(tableCreator);
        mapController.addUINodeChangeListener(tableCreator);
    }

    public JPanel getTablePanel() {
        return this.tablePanel;
    }

    private class TableCreator
    implements INodeSelectionListener,
    INodeChangeListener {
        private AttributeView attributeView;
        private JComboBox formatChooser;

        private TableCreator() {
        }

        @Override
        public void onDeselect(NodeModel node) {
            this.removeOldView();
        }

        private void removeOldView() {
            if (this.attributeView != null) {
                AttributePanelManager.this.tablePanel.removeAll();
                AttributePanelManager.this.tablePanel.revalidate();
                AttributePanelManager.this.tablePanel.repaint();
                this.attributeView.viewRemoved();
                this.attributeView = null;
            }
        }

        @Override
        public void onSelect(NodeModel node) {
            this.removeOldView();
            MainView mainView = (MainView)Controller.getCurrentController().getMapViewManager().getSelectedComponent();
            if (mainView == null) {
                return;
            }
            AttributeController.getController(AttributePanelManager.this.modeController).createAttributeTableModel(node);
            NodeView nodeView = mainView.getNodeView();
            if (nodeView == null) {
                LogUtils.severe(new RuntimeException("Node view null for mainView" + String.valueOf(mainView) + " and node " + String.valueOf(node)));
                return;
            }
            this.attributeView = new AttributeView(nodeView, false);
            Box buttonBox = new Box(AttributePanelManager.this.axis);
            buttonBox.setAlignmentX(0.5f);
            AttributePanelManager.this.tablePanel.add(buttonBox);
            Dimension btnSize = new Dimension();
            JButton newAttributeButton = new JButton(TextUtils.getText("attributes_popup_new"));
            newAttributeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TableCreator.this.attributeView.addRow();
                }
            });
            this.increaseSize(btnSize, newAttributeButton);
            buttonBox.add(newAttributeButton);
            JButton optimalWidthButton = new JButton(TextUtils.getText("attributes_popup_optimal_width"));
            optimalWidthButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TableCreator.this.attributeView.setOptimalColumnWidths();
                }
            });
            this.increaseSize(btnSize, optimalWidthButton);
            buttonBox.add(optimalWidthButton);
            this.formatChooser = this.createFormatChooser();
            this.formatChooser.setEnabled(false);
            this.increaseSize(btnSize, this.formatChooser);
            buttonBox.add(this.formatChooser);
            for (int i = 0; i < buttonBox.getComponentCount(); ++i) {
                buttonBox.getComponent(i).setMaximumSize(btnSize);
            }
            this.formatChooser.addItemListener(new ItemListener(){
                boolean handlingEvent = false;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (this.handlingEvent || !TableCreator.this.formatChooser.isEnabled() || e.getStateChange() != 1) {
                        return;
                    }
                    this.handlingEvent = true;
                    PatternFormat newFormat = this.toPatternFormat(e.getItem());
                    AttributeTable table = TableCreator.this.attributeView.getAttributeTable();
                    if (table.getSelectedColumn() == 1 && table.getSelectedRow() != -1) {
                        Object value = table.getValueAt(table.getSelectedRow(), table.getSelectedColumn());
                        try {
                            Object newValue = this.formatValue(newFormat, table, value);
                            if (newValue != null) {
                                table.setValueAt(newValue, table.getSelectedRow(), table.getSelectedColumn());
                            }
                        }
                        catch (Exception e2) {
                            Controller.getCurrentController().getViewController().out("Pattern is not applicable: " + e2.getMessage());
                            LogUtils.warn("pattern is not applicable", e2);
                        }
                    }
                    this.handlingEvent = false;
                }

                public PatternFormat toPatternFormat(Object value) {
                    if (value instanceof PatternFormat) {
                        return (PatternFormat)value;
                    }
                    PatternFormat patternFormat = PatternFormat.guessPatternFormat(value.toString());
                    return patternFormat == null ? PatternFormat.getIdentityPatternFormat() : patternFormat;
                }

                private Object formatValue(PatternFormat newFormat, AttributeTable table, Object objectToBeFormatted) {
                    Object actualObject;
                    if (TableCreator.this.formatChooser.getSelectedItem() == null) {
                        return null;
                    }
                    if (objectToBeFormatted instanceof IFormattedObject && (actualObject = ((IFormattedObject)objectToBeFormatted).getObject()) != objectToBeFormatted) {
                        return this.formatValue(newFormat, table, actualObject);
                    }
                    if (newFormat == PatternFormat.getIdentityPatternFormat()) {
                        return this.makeFormattedObjectForIdentityFormat(objectToBeFormatted);
                    }
                    if (objectToBeFormatted instanceof String && ((String)objectToBeFormatted).startsWith("=")) {
                        return new FormattedFormula((String)objectToBeFormatted, newFormat.getPattern());
                    }
                    return newFormat.formatObject(objectToBeFormatted);
                }

                private FormattedObject makeFormattedObjectForIdentityFormat(Object objectToBeFormatted) {
                    return new FormattedObject((Object)String.valueOf(objectToBeFormatted), "NO_FORMAT");
                }
            });
            this.attributeView.addTableSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (TableCreator.this.attributeView != null && !event.getValueIsAdjusting()) {
                        TableCreator.this.setSelectedFormatItem();
                    }
                }
            });
            AttributePanelManager.this.tablePanel.add(Box.createVerticalStrut(5));
            JComponent c = this.attributeView.getContainer();
            this.attributeView.update();
            c.setAlignmentX(0.5f);
            AttributePanelManager.this.tablePanel.add(c);
            AttributePanelManager.this.tablePanel.add(Box.createGlue());
            AttributePanelManager.this.tablePanel.revalidate();
            AttributePanelManager.this.tablePanel.repaint();
        }

        private void setSelectedFormatItem() {
            AttributeTable table = this.attributeView.getAttributeTable();
            int selectedColumn = table.getSelectedColumn();
            int selectedRow = table.getSelectedRow();
            if (selectedColumn == 1 && selectedRow >= 0 && selectedRow < table.getRowCount()) {
                this.formatChooser.setEnabled(true);
                Object value = table.getValueAt(selectedRow, selectedColumn);
                if (value instanceof IFormattedObject) {
                    String format = ((IFormattedObject)value).getPattern();
                    this.formatChooser.setSelectedItem(PatternFormat.guessPatternFormat(format));
                } else {
                    this.formatChooser.setSelectedItem(null);
                }
            } else {
                this.formatChooser.setEnabled(false);
            }
        }

        private JComboBox createFormatChooser() {
            ArrayList<PatternFormat> formats = FormatController.getController().getAllFormats();
            Vector<PatternFormat> items = new Vector<PatternFormat>(formats);
            for (int i = items.size() - 1; i >= 0; --i) {
                PatternFormat item = items.get(i);
                if (!item.getType().equals("identity") || item.getType().endsWith("NO_FORMAT")) continue;
                items.remove(i);
            }
            JComboBox<PatternFormat> formatChooser = JComboBoxFactory.create(items);
            formatChooser.setEditable(true);
            formatChooser.setSelectedItem(null);
            String NODE_FORMAT = "OptionPanel.nodeformat";
            formatChooser.setToolTipText(TextUtils.getRawText("OptionPanel.nodeformat.tooltip"));
            formatChooser.setAlignmentX(0.0f);
            formatChooser.setBorder(new TitledBorder(TextUtils.getText("value_format")));
            return formatChooser;
        }

        private void increaseSize(Dimension btnSize, JComponent comp) {
            Dimension preferredSize = comp.getPreferredSize();
            btnSize.width = Math.max(btnSize.width, preferredSize.width);
            btnSize.height = Math.max(btnSize.height, preferredSize.height);
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            if (this.attributeView != null && event.getProperty().equals(NodeAttributeTableModel.class)) {
                this.setSelectedFormatItem();
            }
        }
    }
}

