/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.CollisionDetector;
import org.freeplane.view.swing.map.link.InclinationRecommender;
import org.freeplane.view.swing.map.link.PathBBox;
import org.freeplane.view.swing.map.link.TextPainter;

public class ConnectorView
extends AConnectorView {
    private static final String CONNECTOR_VIEW_SHOWS_CONTROL_POINTS = "connectorView.showsControlPoints";
    private static final int NORMAL_LENGTH = 50;
    private static final float[] DOTTED_DASH = new float[]{4.0f, 7.0f};
    static final Stroke DEF_STROKE = new BasicStroke(1.0f);
    private static final int LABEL_GAP = 4;
    private static final double PRECISION = 2.0;
    private Shape arrowLinkCurve;
    private Rectangle sourceTextRectangle;
    private Rectangle middleTextRectangle;
    private Rectangle targetTextRectangle;
    private final Color textColor;
    private final Color color;
    private final BasicStroke stroke;
    private final Color bgColor;
    private final LinkController linkController = this.getLinkController();

    public ConnectorView(ConnectorModel connectorModel, NodeView source, NodeView target, Color bgColor) {
        super(connectorModel, source, target);
        this.textColor = this.linkController.getColor(connectorModel);
        this.bgColor = bgColor;
        int alpha = this.linkController.getOpacity(connectorModel);
        this.color = ColorUtils.alphaToColor(alpha, this.textColor);
        int width = this.linkController.getWidth(connectorModel);
        this.stroke = !this.isSourceVisible() || !this.isTargetVisible() ? new BasicStroke(width) : UITools.createStroke(width, this.linkController.getDashArray(connectorModel), 1);
    }

    @Override
    public boolean detectCollision(Point p, boolean selectedOnly) {
        if (!(!selectedOnly || this.source != null && this.source.isSelected() || this.target != null && this.target.isSelected())) {
            return false;
        }
        if (this.arrowLinkCurve == null) {
            return false;
        }
        return new CollisionDetector().detectCollision(p, this.arrowLinkCurve);
    }

    private Rectangle drawEndPointText(Graphics2D g, String text, Point endPoint, Point controlPoint) {
        if (text == null || text.equals("")) {
            return null;
        }
        TextPainter textPainter = new TextPainter(g, text);
        int textWidth = textPainter.getTextWidth();
        int textHeight = textPainter.getTextHeight();
        int x = controlPoint.x > endPoint.x ? endPoint.x - textWidth - 4 : endPoint.x + 4;
        int y = controlPoint.y > endPoint.y ? endPoint.y + 4 : endPoint.y - textHeight - 4;
        textPainter.draw(x, y, this.textColor, this.bgColor);
        return new Rectangle(x, y, textWidth, textHeight);
    }

    private Rectangle drawMiddleLabel(Graphics2D g, String text, Point centerPoint) {
        if (text == null || text.equals("")) {
            return null;
        }
        TextPainter textPainter = new TextPainter(g, text);
        int textWidth = textPainter.getTextWidth();
        int x = centerPoint.x - textWidth / 2;
        int textHeight = textPainter.getTextHeight();
        int y = centerPoint.y - textHeight / 2;
        textPainter.draw(x, y, this.textColor, this.bgColor);
        return new Rectangle(x, y, textWidth, textHeight);
    }

    Shape getArrowLinkCurve() {
        return this.arrowLinkCurve;
    }

    NodeLinkModel getArrowLinkModel() {
        return this.connectorModel;
    }

    private Point getCenterPoint() {
        if (this.arrowLinkCurve == null) {
            return null;
        }
        double halfLength = this.getHalfLength();
        PathIterator pathIterator = this.arrowLinkCurve.getPathIterator(new AffineTransform(), 2.0);
        double[] lastCoords = new double[6];
        pathIterator.currentSegment(lastCoords);
        double length = 0.0;
        while (true) {
            pathIterator.next();
            double[] nextCoords = new double[6];
            if (pathIterator.isDone() || 4 == pathIterator.currentSegment(nextCoords)) break;
            double dx = nextCoords[0] - lastCoords[0];
            double dy = nextCoords[1] - lastCoords[1];
            double dr = Math.sqrt(dx * dx + dy * dy);
            if ((length += dr) >= halfLength) {
                double k = dr < 1.0 ? 0.5 : (length - halfLength) / dr;
                return new Point((int)Math.rint(nextCoords[0] - k * dx), (int)Math.rint(nextCoords[1] - k * dy));
            }
            lastCoords = nextCoords;
        }
        throw new RuntimeException("center point not found");
    }

    private double getHalfLength() {
        PathIterator pathIterator = this.arrowLinkCurve.getPathIterator(new AffineTransform(), 2.0);
        double[] lastCoords = new double[6];
        pathIterator.currentSegment(lastCoords);
        double length = 0.0;
        while (true) {
            pathIterator.next();
            double[] nextCoords = new double[6];
            if (pathIterator.isDone() || 4 == pathIterator.currentSegment(nextCoords)) break;
            double dx = nextCoords[0] - lastCoords[0];
            double dy = nextCoords[1] - lastCoords[1];
            length += Math.sqrt(dx * dx + dy * dy);
            lastCoords = nextCoords;
        }
        return length / 2.0;
    }

    private ModeController getModeController() {
        NodeView nodeView = this.source;
        if (this.source == null) {
            nodeView = this.target;
        }
        MapView mapView = nodeView.getMap();
        return mapView.getModeController();
    }

    @Override
    public ConnectorModel getModel() {
        return this.connectorModel;
    }

    Point intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return null;
        }
        int xi = (int)(((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d);
        int yi = (int)(((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d);
        if ((double)(xi + 2) < Math.min(x1, x2) || (double)(xi - 2) > Math.max(x1, x2)) {
            return null;
        }
        return new Point(xi, yi);
    }

    Point2D.Double normal(double x1, double y1, double x2, double y2) {
        double ny;
        double nx;
        if (x1 == x2) {
            nx = Math.signum(y2 - y1);
            ny = 0.0;
        } else {
            double f = (y2 - y1) / (x2 - x1);
            nx = f * Math.signum(x2 - x1) / Math.sqrt(1.0 + f * f);
            ny = -1.0 * Math.signum(x2 - x1) / Math.sqrt(1.0 + f * f);
        }
        return new Point2D.Double(nx, ny);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isSourceVisible() && !this.isTargetVisible()) {
            return;
        }
        boolean targetIsLeft = false;
        boolean sourceIsLeft = false;
        Graphics2D g = (Graphics2D)graphics.create();
        Color oldColor = g.getColor();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        Point startInclination = this.connectorModel.getStartInclination();
        Point endInclination = this.connectorModel.getEndInclination();
        if (startInclination == null || endInclination == null) {
            InclinationRecommender recommender = new InclinationRecommender(this.linkController, this);
            if (this.isSourceVisible() && startInclination == null) {
                startInclination = recommender.calcStartInclination();
            }
            if (this.isTargetVisible() && this.connectorModel.getEndInclination() == null) {
                endInclination = recommender.calcEndInclination();
            }
        }
        Point startPoint = null;
        Point endPoint = null;
        if (this.isSourceVisible()) {
            startPoint = this.source.getLinkPoint(startInclination);
            sourceIsLeft = this.source.isTopOrLeft();
        }
        if (this.isTargetVisible()) {
            endPoint = this.target.getLinkPoint(endInclination);
            targetIsLeft = this.target.isTopOrLeft();
        }
        MapView map = this.getMap();
        Point startPoint2 = null;
        if (startPoint != null) {
            startPoint2 = new Point(startPoint);
            if (endPoint == null) {
                this.normalizeLength(50, startInclination);
            }
            startPoint2.translate((sourceIsLeft ? -1 : 1) * map.getZoomed(startInclination.x), map.getZoomed(startInclination.y));
        }
        Point endPoint2 = null;
        if (endPoint != null) {
            endPoint2 = new Point(endPoint);
            if (startPoint == null) {
                this.normalizeLength(50, endInclination);
            }
            endPoint2.translate((targetIsLeft ? -1 : 1) * map.getZoomed(endInclination.x), map.getZoomed(endInclination.y));
        }
        boolean showsConnectors = map.showsConnectorLines();
        this.paintCurve(g, startPoint, startPoint2, endPoint2, endPoint, showsConnectors);
        if (showsConnectors) {
            this.drawLabels(g, startPoint, startPoint2, endPoint2, endPoint);
        }
        g.setColor(oldColor);
    }

    private void normalizeLength(int normalLength, Point startInclination) {
        double k = (double)normalLength / Math.sqrt(startInclination.x * startInclination.x + startInclination.y * startInclination.y);
        startInclination.x = (int)((double)startInclination.x * k);
        startInclination.y = (int)((double)startInclination.y * k);
    }

    private Shape createLine(Point p1, Point p2) {
        return new Line2D.Float(p1, p2);
    }

    private Shape createLinearPath(Point startPoint, Point startPoint2, Point endPoint2, Point endPoint) {
        GeneralPath generalPath = new GeneralPath(1, 4);
        generalPath.moveTo(startPoint.x, startPoint.y);
        generalPath.lineTo(startPoint2.x, startPoint2.y);
        generalPath.lineTo(endPoint2.x, endPoint2.y);
        generalPath.lineTo(endPoint.x, endPoint.y);
        return generalPath;
    }

    private void paintCurve(Graphics2D g, Point startPoint, Point startPoint2, Point endPoint2, Point endPoint, boolean showsConnectors) {
        boolean selfLink = this.getSource() == this.getTarget();
        boolean isLine = ConnectorShape.LINE.equals(this.linkController.getShape(this.connectorModel));
        this.arrowLinkCurve = null;
        if (showsConnectors) {
            if (startPoint != null && endPoint != null) {
                this.arrowLinkCurve = isLine ? (selfLink ? this.createLine(startPoint, startPoint2) : this.createLine(startPoint, endPoint)) : (ConnectorShape.LINEAR_PATH.equals(this.linkController.getShape(this.connectorModel)) ? this.createLinearPath(startPoint, startPoint2, endPoint2, endPoint) : this.createCubicCurve2D(startPoint, startPoint2, endPoint2, endPoint));
            }
            if (this.arrowLinkCurve != null) {
                g.draw(this.arrowLinkCurve);
            }
        }
        if (!(!this.isSourceVisible() || showsConnectors && this.linkController.getArrows((ConnectorModel)this.connectorModel).start.equals((Object)ArrowType.NONE))) {
            if (!selfLink && isLine && endPoint != null) {
                this.paintArrow(g, endPoint, startPoint);
            } else {
                this.paintArrow(g, startPoint2, startPoint);
            }
        }
        if (!(!this.isTargetVisible() || showsConnectors && this.linkController.getArrows((ConnectorModel)this.connectorModel).end.equals((Object)ArrowType.NONE))) {
            if (isLine && startPoint != null) {
                if (selfLink) {
                    this.paintArrow(g, startPoint, startPoint2);
                } else {
                    this.paintArrow(g, startPoint, endPoint);
                }
            } else {
                this.paintArrow(g, endPoint2, endPoint);
            }
        }
        if (showsConnectors) {
            boolean showsControlPoints = this.showsControlPoints();
            if (showsControlPoints) {
                g.setColor(this.textColor);
                g.setStroke(new BasicStroke(this.stroke.getLineWidth(), 1, 1, 0.0f, DOTTED_DASH, 0.0f));
            }
            if (showsControlPoints || !this.isSourceVisible() || !this.isTargetVisible()) {
                if (startPoint != null) {
                    g.drawLine(startPoint.x, startPoint.y, startPoint2.x, startPoint2.y);
                    this.drawCircle(g, startPoint2, this.source.getZoomedFoldingMarkHalfWidth());
                    if (this.arrowLinkCurve == null) {
                        this.arrowLinkCurve = this.createLine(startPoint, startPoint2);
                    }
                }
                if (!(endPoint == null || selfLink && isLine)) {
                    g.drawLine(endPoint.x, endPoint.y, endPoint2.x, endPoint2.y);
                    this.drawCircle(g, endPoint2, this.target.getZoomedFoldingMarkHalfWidth());
                    if (this.arrowLinkCurve == null) {
                        this.arrowLinkCurve = this.createLine(endPoint, endPoint2);
                    }
                }
            }
        }
    }

    public void enableControlPoints() {
        this.getMap().putClientProperty(CONNECTOR_VIEW_SHOWS_CONTROL_POINTS, new WeakReference<ConnectorModel>(this.connectorModel));
    }

    public void disableControlPoints() {
        MapView map = this.getMap();
        if (this.showsControlPoints()) {
            map.putClientProperty(CONNECTOR_VIEW_SHOWS_CONTROL_POINTS, null);
        }
    }

    private boolean showsControlPoints() {
        WeakReference connectorReference = (WeakReference)this.getMap().getClientProperty(CONNECTOR_VIEW_SHOWS_CONTROL_POINTS);
        boolean showsControlPoints = connectorReference != null && connectorReference.get() == this.getModel();
        return showsControlPoints;
    }

    private void drawCircle(Graphics2D g, Point p, int hw) {
        g.setStroke(DEF_STROKE);
        g.fillOval(p.x - hw, p.y - hw, hw * 2, hw * 2);
    }

    private void paintArrow(Graphics2D g, Point from, Point to) {
        this.paintArrow(from, to, g, this.getZoom() * 10.0);
    }

    private void drawLabels(Graphics2D g, Point startPoint, Point startPoint2, Point endPoint2, Point endPoint) {
        String sourceLabel = this.linkController.getSourceLabel(this.connectorModel);
        String middleLabel = this.source != null && MapStyleModel.isDefaultStyleNode(this.source.getModel()) ? TextUtils.getText("connector") : this.linkController.getMiddleLabel(this.connectorModel);
        String targetLabel = this.linkController.getTargetLabel(this.connectorModel);
        if (sourceLabel == null && middleLabel == null && targetLabel == null) {
            return;
        }
        Font oldFont = g.getFont();
        String fontFamily = this.linkController.getLabelFontFamily(this.connectorModel);
        int fontSize = Math.round((float)this.linkController.getLabelFontSize(this.connectorModel) * UITools.FONT_SCALE_FACTOR);
        Font linksFont = new Font(fontFamily, 0, this.getZoomed(fontSize));
        g.setFont(linksFont);
        if (startPoint != null) {
            this.sourceTextRectangle = this.drawEndPointText(g, sourceLabel, startPoint, startPoint2);
            if (endPoint == null) {
                this.middleTextRectangle = this.drawEndPointText(g, middleLabel, startPoint2, startPoint);
            }
        }
        if (endPoint != null) {
            this.targetTextRectangle = this.drawEndPointText(g, targetLabel, endPoint, endPoint2);
            if (startPoint == null) {
                this.middleTextRectangle = this.drawEndPointText(g, middleLabel, endPoint2, endPoint);
            }
        }
        if (startPoint != null && endPoint != null) {
            this.middleTextRectangle = this.drawMiddleLabel(g, middleLabel, this.getCenterPoint());
        }
        g.setFont(oldFont);
    }

    private LinkController getLinkController() {
        return LinkController.getController(this.getModeController());
    }

    private CubicCurve2D createCubicCurve2D(Point startPoint, Point startPoint2, Point endPoint2, Point endPoint) {
        CubicCurve2D.Double arrowLinkCurve = new CubicCurve2D.Double();
        if (startPoint != null && endPoint != null) {
            arrowLinkCurve.setCurve(startPoint, startPoint2, endPoint2, endPoint);
        } else if (startPoint != null) {
            arrowLinkCurve.setCurve(startPoint, startPoint2, startPoint, startPoint2);
        } else if (endPoint != null) {
            arrowLinkCurve.setCurve(endPoint, endPoint2, endPoint, endPoint2);
        }
        return arrowLinkCurve;
    }

    @Override
    public void increaseBounds(Rectangle innerBounds) {
        Shape arrowLinkCurve = this.getArrowLinkCurve();
        if (arrowLinkCurve == null) {
            return;
        }
        Rectangle arrowViewBigBounds = arrowLinkCurve.getBounds();
        if (!innerBounds.contains(arrowViewBigBounds)) {
            Rectangle arrowViewBounds = PathBBox.getBBox(arrowLinkCurve).getBounds();
            innerBounds.add(arrowViewBounds);
        }
        this.increaseBounds(innerBounds, this.sourceTextRectangle);
        this.increaseBounds(innerBounds, this.middleTextRectangle);
        this.increaseBounds(innerBounds, this.targetTextRectangle);
    }

    private void increaseBounds(Rectangle innerBounds, Rectangle rect) {
        if (rect != null) {
            innerBounds.add(rect);
        }
    }
}

