/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicIconFactory;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuSplitter;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.CollapseableBoxBuilder;
import org.freeplane.core.ui.components.resizer.JResizer;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.icon.EmojiIcon;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.FastAccessableIcons;
import org.freeplane.features.icon.mindmapmode.IconAction;
import org.freeplane.features.icon.mindmapmode.IconActionRemovesIconIfExistsPropertyAction;
import org.freeplane.features.icon.mindmapmode.RemoveAllIconsAction;
import org.freeplane.features.icon.mindmapmode.RemoveIconAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.ConditionPredicate;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MIconController
extends IconController {
    public static final String ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION = "SetBooleanPropertyAction.iconActionRemovesIconIfExists";
    public static final String REMOVE_FIRST_ICON_ACTION = "RemoveIcon_0_Action";
    public static final String REMOVE_LAST_ICON_ACTION = "RemoveIconAction";
    public static final String REMOVE_ALL_ICONS_ACTION = "RemoveAllIconsAction";
    private static final String RECENTLY_USED_ICONS_PROPERTY = "recently_used_icons";
    private static final String ADD_EMOJIS_TO_MENU = "add_emojis_to_menu";
    private static final String ADD_EMOJIS_TO_ICON_TOOLBAR = "add_emojis_to_icon_toolbar";
    private static final Insets ICON_SUBMENU_INSETS = new Insets(3, 0, 3, 0);
    private static final ConditionPredicate DEPENDS_ON_ICON = new ConditionPredicate(){

        public boolean test(ICondition condition) {
            return condition instanceof IconContainedCondition || condition instanceof IconExistsCondition;
        }
    };
    private final Map<String, AFreeplaneAction> iconActions = new LinkedHashMap<String, AFreeplaneAction>();
    private final IconStore STORE = IconStoreFactory.ICON_STORE;
    private final JToolBar iconToolBar;
    private final Box iconBox;
    private final FastAccessableIcons recentlyUsedIcons;
    private static final Icon SUBMENU_ICON = BasicIconFactory.getMenuArrowIcon();

    public MIconController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        this.iconToolBar = new FreeplaneToolBar("icon_toolbar", 1);
        JAutoScrollBarPane iconToolBarScrollPane = new JAutoScrollBarPane((Component)this.iconToolBar);
        UITools.setScrollbarIncrement((JScrollPane)iconToolBarScrollPane);
        UITools.addScrollbarIncrementPropertyListener((JScrollPane)iconToolBarScrollPane);
        this.iconBox = new CollapseableBoxBuilder("leftToolbarVisible").createBox((Component)iconToolBarScrollPane, JResizer.Direction.LEFT);
        this.createIconActions(modeController);
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "icon_actions", (EntryVisitor)new IconMenuBuilder(modeController));
        this.recentlyUsedIcons = new FastAccessableIcons(modeController);
    }

    public void install(final ModeController modeController) {
        super.install(modeController);
        modeController.getMapController().addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (event.getProperty().equals("icon") && LogicalStyleController.getController().conditionalStylesOf(node).dependsOnConditionRecursively(DEPENDS_ON_ICON)) {
                    modeController.getMapController().delayedNodeRefresh(node, NodeModel.UNKNOWN_PROPERTY, null, null);
                }
            }
        });
    }

    public void addIconByUserAction(NodeModel node, IconAction action) {
        this.addIcon(node, (NamedIcon)action.getMindIcon());
        this.recentlyUsedIcons.add(action);
    }

    public void addIcon(final NodeModel node, final NamedIcon icon) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon(icon);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon();
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void addIcon(final NodeModel node, final MindIcon icon, final int position) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon((NamedIcon)icon, position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon(position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void changeIconSize(final NodeModel node, final Quantity<LengthUnit> iconSize) {
        IActor actor = new IActor(){
            private Quantity<LengthUnit> oldIconSize;

            public void act() {
                this.oldIconSize = node.getSharedData().getIcons().getIconSize();
                node.getSharedData().getIcons().setIconSize(iconSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon_size", null, (Object)iconSize);
            }

            public String getDescription() {
                return "changeIconSize";
            }

            public void undo() {
                node.getSharedData().getIcons().setIconSize(this.oldIconSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon_size", this.oldIconSize, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private void createIconActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new RemoveIconAction(0));
        modeController.addAction((AFreeplaneAction)new RemoveIconAction(-1));
        modeController.addAction((AFreeplaneAction)new RemoveAllIconsAction());
        modeController.addAction((AFreeplaneAction)new IconActionRemovesIconIfExistsPropertyAction());
        for (MindIcon icon : this.STORE.getMindIcons()) {
            IconAction myAction = new IconAction(icon);
            modeController.addActionIfNotAlreadySet((AFreeplaneAction)myAction);
            this.iconActions.put(icon.getName(), (AFreeplaneAction)myAction);
        }
    }

    public Collection<AFreeplaneAction> getIconActions() {
        return Collections.unmodifiableCollection(this.iconActions.values());
    }

    public Collection<AFreeplaneAction> getIconActions(Predicate<MindIcon> filter) {
        return this.iconActions.values().stream().filter(action -> filter.test(((IconAction)((Object)action)).getMindIcon())).collect(Collectors.toList());
    }

    public Map<String, AFreeplaneAction> getAllIconActions() {
        return Collections.unmodifiableMap(this.iconActions);
    }

    public JComponent getIconToolBarScrollPane() {
        return this.iconBox;
    }

    private JMenu getSubmenu(IconGroup group) {
        JMenu menu = this.createToolbarSubmenu(group);
        this.fillSubmenuOnSelect(menu, group);
        return menu;
    }

    private void fillSubmenuOnSelect(final JMenu menu, final IconGroup group) {
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeMenuListener(this);
                this.fillSubmenu(menu, group);
            }

            private void fillSubmenu(JMenu menu2, IconGroup group2) {
                for (IconGroup childGroup : group2.getGroups()) {
                    if (childGroup.isLeaf()) {
                        MindIcon groupIcon = childGroup.getGroupIcon();
                        MIconController.this.addActionToIconSubmenu(menu2, groupIcon);
                        continue;
                    }
                    JMenu submenu = new JMenu(childGroup.getDescription());
                    submenu.setIcon(childGroup.getGroupIcon().getIcon());
                    MIconController.this.fillSubmenuOnSelect(submenu, childGroup);
                    MIconController.this.addGroupToIconSubmenu(menu2, submenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private JMenu createToolbarSubmenu(IconGroup group) {
        JMenu menu = new JMenu(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Point getPopupMenuOrigin() {
                return new Point(this.getWidth(), 0);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int x = this.getWidth() - SUBMENU_ICON.getIconWidth();
                int y = (this.getHeight() - SUBMENU_ICON.getIconHeight()) / 2;
                SUBMENU_ICON.paintIcon(this, g, x, y);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result.width += SUBMENU_ICON.getIconWidth();
                return result;
            }
        };
        menu.setMargin(ICON_SUBMENU_INSETS);
        menu.setIcon(group.getGroupIcon().getIcon());
        menu.setToolTipText(group.getDescription());
        return menu;
    }

    private void addGroupToIconSubmenu(JMenu menu, JMenu submenu) {
        new MenuSplitter().addMenuComponent(menu, (Component)submenu, menu.getItemCount());
    }

    private void addActionToIconSubmenu(JMenu menu, MindIcon icon) {
        AFreeplaneAction myAction = this.iconActions.get(icon.getName());
        new MenuSplitter().addMenuComponent(menu, (Component)new JMenuItem((Action)myAction), menu.getItemCount());
    }

    private void insertToolbarSubmenus(JToolBar iconToolBar, boolean isStructured) {
        JMenuBar iconMenuBar = new JMenuBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension preferredSize = this.getPreferredSize();
                return new Dimension(Short.MAX_VALUE, preferredSize.height);
            }
        };
        iconMenuBar.setAlignmentX(0.5f);
        iconMenuBar.setLayout(new GridLayout(0, 1));
        for (IconGroup iconGroup : this.STORE.getGroups()) {
            if ((!isStructured || iconGroup.getName().equals("emoji_group") && !this.areEmojisAvailbleOnIconToolbar()) && (!iconGroup.getName().equals("emoji_group") || !this.areEmojisAvailbleOnIconToolbar())) continue;
            iconMenuBar.add(this.getSubmenu(iconGroup));
        }
        iconToolBar.add(iconMenuBar);
    }

    boolean areEmojisAvailbleFromMenu() {
        return ResourceController.getResourceController().getBooleanProperty(ADD_EMOJIS_TO_MENU);
    }

    boolean areEmojisAvailbleOnIconToolbar() {
        return ResourceController.getResourceController().getBooleanProperty(ADD_EMOJIS_TO_ICON_TOOLBAR);
    }

    public void removeAllIcons(NodeModel node) {
        int size = node.getIcons().size();
        MIconController iconController = (MIconController)IconController.getController();
        for (int i = 0; i < size; ++i) {
            iconController.removeIcon(node, 0);
        }
    }

    public int removeIcon(NodeModel node) {
        return this.removeIcon(node, -1);
    }

    public boolean removeIcon(NodeModel node, NamedIcon removedIcon) {
        List icons = node.getIcons();
        int iconCount = icons.size();
        for (int i = 0; i < iconCount; ++i) {
            if (!removedIcon.getName().equals(((NamedIcon)icons.get(i)).getName())) continue;
            this.removeIcon(node, i);
            return true;
        }
        return false;
    }

    public int removeIcon(final NodeModel node, int position) {
        int index;
        int size = node.getIcons().size();
        int n = index = position >= 0 ? position : size + position;
        if (size == 0 || size <= index) {
            return size;
        }
        IActor actor = new IActor(){
            private final NamedIcon icon;
            {
                this.icon = node.getIcon(index);
            }

            public void act() {
                node.removeIcon(index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)this.icon, null);
            }

            public String getDescription() {
                return "removeIcon";
            }

            public void undo() {
                node.addIcon(this.icon, index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)this.icon);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
        return node.getIcons().size();
    }

    private void updateIconToolbar(ModeController modeController) {
        this.iconToolBar.removeAll();
        AbstractButton[] buttons = new AbstractButton[]{FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_FIRST_ICON_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_LAST_ICON_ACTION)), FreeplaneToolBar.createButton((AFreeplaneAction)modeController.getAction(REMOVE_ALL_ICONS_ACTION))};
        FreeplaneToolBar actionPanel = new FreeplaneToolBar(1);
        Stream.of(buttons).forEach(arg_0 -> ((FreeplaneToolBar)actionPanel).add(arg_0));
        this.iconToolBar.add((Component)actionPanel);
        this.iconToolBar.addSeparator();
        this.recentlyUsedIcons.load(ResourceController.getResourceController().getProperty(RECENTLY_USED_ICONS_PROPERTY, ""));
        this.iconToolBar.add((Component)((Object)this.recentlyUsedIcons.createActionPanel(new AFreeplaneAction[0])));
        boolean isStructured = ResourceController.getResourceController().getBooleanProperty("structured_icon_toolbar");
        if (!isStructured && this.areEmojisAvailbleOnIconToolbar()) {
            this.iconToolBar.addSeparator();
        }
        this.insertToolbarSubmenus(this.iconToolBar, isStructured);
        if (!isStructured) {
            this.iconToolBar.addSeparator();
            for (MindIcon mindIcon : this.STORE.getMindIcons()) {
                if (mindIcon instanceof EmojiIcon) continue;
                AFreeplaneAction iconAction = this.iconActions.get(mindIcon.getName());
                this.iconToolBar.add((Action)iconAction).setAlignmentX(0.5f);
            }
        }
    }

    public void saveRecentlyUsedActions() {
        String initializer = this.recentlyUsedIcons.getInitializer();
        ResourceController.getResourceController().setProperty(RECENTLY_USED_ICONS_PROPERTY, initializer);
    }

    public FastAccessableIcons.ActionPanel createActionPanelWithControlActions() {
        ModeController modeController = Controller.getCurrentModeController();
        return this.recentlyUsedIcons.createActionPanel(modeController.getAction(ICON_ACTION_REMOVES_ICON_IF_EXISTS_ACTION), modeController.getAction(REMOVE_FIRST_ICON_ACTION), modeController.getAction(REMOVE_LAST_ICON_ACTION), modeController.getAction(REMOVE_ALL_ICONS_ACTION));
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (key.equals((Object)Keys.ICONS)) {
                this.copyIcons(from, to);
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE)) {
                this.copyIconSize(from, to);
            }
        }

        private void copyIconSize(NodeModel from, NodeModel to) {
            Quantity iconSize = from.getSharedData().getIcons().getIconSize();
            if (iconSize != null) {
                to.getSharedData().getIcons().setIconSize(iconSize);
            }
        }

        private void copyIcons(NodeModel from, NodeModel to) {
            List sourceIcons = from.getIcons();
            List targetIcons = to.getIcons();
            for (NamedIcon icon : sourceIcons) {
                if (targetIcons.contains(icon)) continue;
                to.addIcon(icon);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (key.equals((Object)Keys.ICONS)) {
                while (from.removeIcon() > 0) {
                }
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE)) {
                this.removeIconSize(from);
            }
        }

        private void removeIconSize(NodeModel from) {
            from.getSharedData().getIcons().setIconSize(null);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (key.equals((Object)Keys.ICONS)) {
                this.removeIcons(from, which);
            }
            if (key.equals(LogicalStyleKeys.NODE_STYLE) && which.getSharedData().getIcons().getIconSize() != null) {
                this.removeIconSize(from);
            }
        }

        private void removeIcons(NodeModel from, NodeModel which) {
            List targetIcons = from.getIcons();
            List whichIcons = which.getIcons();
            Iterator targetIconIterator = targetIcons.iterator();
            while (targetIconIterator.hasNext()) {
                NamedIcon icon = (NamedIcon)targetIconIterator.next();
                if (!whichIcons.contains(icon)) continue;
                targetIconIterator.remove();
            }
        }
    }

    private final class IconMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public IconMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        public void visit(Entry target) {
            this.addIcons(target);
            MIconController.this.updateIconToolbar(this.modeController);
        }

        private void addIcons(Entry target) {
            for (IconGroup iconGroup : MIconController.this.STORE.getGroups()) {
                this.addIconGroup(target, iconGroup, false);
            }
        }

        private void addIconGroup(Entry target, IconGroup group, boolean isEmoji) {
            if (group.getIcons().size() < 1) {
                return;
            }
            boolean bl = isEmoji = isEmoji || group.getName().equals("emoji_group");
            if (isEmoji && !MIconController.this.areEmojisAvailbleFromMenu()) {
                return;
            }
            Entry item = new Entry();
            item.setName("icons");
            EntryAccessor entryAccessor = new EntryAccessor();
            entryAccessor.drawMenuIconAlways(item);
            entryAccessor.setIcon(item, group.getGroupIcon().getIcon());
            entryAccessor.setText(item, group.getDescription());
            if (isEmoji) {
                entryAccessor.processUiOnPopup(item);
            }
            target.addChild(item);
            List childGroups = group.getGroups();
            for (IconGroup childGroup : childGroups) {
                if (childGroup.isLeaf()) {
                    MindIcon icon = childGroup.getGroupIcon();
                    Entry actionItem = entryAccessor.addChildAction(item, (AFreeplaneAction)MIconController.this.iconActions.get(icon.getName()));
                    entryAccessor.drawMenuIconAlways(actionItem);
                    continue;
                }
                this.addIconGroup(item, childGroup, isEmoji);
            }
            if (childGroups.isEmpty()) {
                Entry noActions = new Entry();
                noActions.setBuilders(new String[]{"noActions"});
                item.addChild(noActions);
            }
        }

        public boolean shouldSkipChildren(Entry entry) {
            return false;
        }
    }

    public static enum Keys {
        ICONS;

    }
}

