/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;

@SelectableAction(checkOnNodeChange=true)
class HorizontalTextAlignmentAction
extends AMultipleNodeAction {
    private final NodeStyleModel.HorizontalTextAlignment textAlignment;
    private static final long serialVersionUID = 1L;
    private boolean textAlignSet;

    public HorizontalTextAlignmentAction(NodeStyleModel.HorizontalTextAlignment textAlignment) {
        super("TextAlignAction." + textAlignment);
        this.textAlignment = textAlignment;
    }

    public void actionPerformed(ActionEvent e) {
        this.textAlignSet = !this.isHorizontalTextAlignmentSet();
        super.actionPerformed(e);
    }

    protected void actionPerformed(ActionEvent e, NodeModel selected) {
        ((MNodeStyleController)NodeStyleController.getController()).setHorizontalTextAlignment(selected, this.textAlignSet ? this.textAlignment : null);
    }

    boolean isHorizontalTextAlignmentSet() {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        return this.textAlignment.equals((Object)NodeStyleController.getController().getHorizontalTextAlignment(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
    }

    public void setSelected() {
        this.setSelected(this.isHorizontalTextAlignmentSet());
    }
}

