/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Vector;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EnumToStringMapper;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class NodeHorizontalTextAlignmentControlGroup
implements ControlGroup {
    static final String TEXT_ALIGNMENT = "textalignment";
    private static final String[] TEXT_ALIGNMENTS = EnumToStringMapper.getStringValuesOf(NodeStyleModel.HorizontalTextAlignment.class);
    private RevertingProperty mSetNodeTextAlignment;
    private ComboProperty mNodeTextAlignment;
    private NodeTextAlignmentChangeListener propertyChangeListener;

    NodeHorizontalTextAlignmentControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeTextAlignment = new RevertingProperty();
        Vector<String> possibleTranslations = new Vector<String>(TEXT_ALIGNMENTS.length);
        for (int i = 0; i < TEXT_ALIGNMENTS.length; ++i) {
            possibleTranslations.add(TextUtils.getText((String)("TextAlignAction." + TEXT_ALIGNMENTS[i] + ".text")));
        }
        Vector<String> translations = possibleTranslations;
        this.mNodeTextAlignment = new ComboProperty(TEXT_ALIGNMENT, Arrays.asList(TEXT_ALIGNMENTS), translations);
        this.propertyChangeListener = new NodeTextAlignmentChangeListener(this.mSetNodeTextAlignment, new IPropertyControl[]{this.mNodeTextAlignment});
        this.mSetNodeTextAlignment.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeTextAlignment.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeTextAlignment.appendToForm(formBuilder);
        this.mSetNodeTextAlignment.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class NodeTextAlignmentChangeListener
    extends ControlGroupChangeListener {
        public NodeTextAlignmentChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setHorizontalTextAlignment(node, enabled ? NodeStyleModel.HorizontalTextAlignment.valueOf((String)NodeHorizontalTextAlignmentControlGroup.this.mNodeTextAlignment.getValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeStyleModel.HorizontalTextAlignment style = NodeStyleModel.getHorizontalTextAlignment((NodeModel)node);
            NodeStyleModel.HorizontalTextAlignment viewStyle = styleController.getHorizontalTextAlignment(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeHorizontalTextAlignmentControlGroup.this.mSetNodeTextAlignment.setValue(style != null);
            NodeHorizontalTextAlignmentControlGroup.this.mNodeTextAlignment.setValue(viewStyle.name());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, NodeHorizontalTextAlignmentControlGroup.this.mSetNodeTextAlignment);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeHorizontalTextAlignmentControlGroup.this.mNodeTextAlignment);
        }
    }
}

