/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.DelayedRunner;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.CoreTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DateRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DetailTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.FlatNodeTableFilterModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NoteTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TableSorter;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowColumnSetting;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowConfigurationStorage;

class NodeList
implements IExtension {
    private static final String REMINDER_TEXT_CREATED = "reminder.Created";
    private static final String REMINDER_TEXT_REMINDER = "reminder.Reminder";
    private static final String REMINDER_TEXT_ICONS = "reminder.Icons";
    private static final String REMINDER_TEXT_MODIFIED = "reminder.Modified";
    private static final String REMINDER_TEXT_NOTES = "reminder.Notes";
    private static final String REMINDER_TEXT_DETAILS = "reminder.Details";
    private static final String REMINDER_TEXT_MAP = "reminder.Map";
    private static final String REMINDER_TEXT_TEXT = "reminder.Text";
    private static final String REMINDER_TEXT_CLOSE = "reminder.closeButton";
    private static final String REMINDER_TEXT_FIND = "reminder.Find";
    static final String REMINDER_TEXT_WINDOW_TITLE = "reminder.WindowTitle";
    private static String COLUMN_MODIFIED = TextUtils.getText((String)"reminder.Modified");
    private static String COLUMN_CREATED = TextUtils.getText((String)"reminder.Created");
    private static String COLUMN_ICONS = TextUtils.getText((String)"reminder.Icons");
    private static String COLUMN_TEXT = TextUtils.getText((String)"reminder.Text");
    private static String COLUMN_MAP = TextUtils.getText((String)"reminder.Map");
    private static String COLUMN_DETAILS = TextUtils.getText((String)"reminder.Details");
    private static String COLUMN_REMINDER = TextUtils.getText((String)"reminder.Reminder");
    private static String COLUMN_NOTES = TextUtils.getText((String)"reminder.Notes");
    private final String windowPreferenceStorageProperty;
    private final DateRenderer dateRenderer;
    private JDialog dialog;
    private final IconsRenderer iconsRenderer;
    protected final JComboBox<Object> mFilterTextSearchField;
    private final JCheckBox closeAfterSelection;
    protected FlatNodeTableFilterModel mFlatNodeTableFilterModel;
    private final JTextField mNodePath;
    private final TextRenderer textRenderer;
    private final String windowTitle;
    TableSorter sorter;
    protected final JTable tableView;
    private DefaultTableModel tableModel;
    private final boolean searchInAllMaps;
    protected final JCheckBox useRegexInFind;
    protected final JCheckBox matchCase;
    private final boolean modal;
    private final MapChangeListener mapChangeListener;
    protected static final String PAST_REMINDERS_TEXT_WINDOW_TITLE = "reminder.WindowTitle_pastReminders";
    private Set<MapModel> listedMaps = Collections.emptySet();
    private boolean showsStyleIcons = false;
    private int nodeMapColumn = -1;
    int nodeTextColumn = -1;
    private int nodeIconColumn = -1;
    int nodeDetailsColumn = -1;
    int nodeNotesColumn = -1;
    int nodeReminderColumn = -1;
    private int nodeCreatedColumn = -1;
    private int nodeModifiedColumn = -1;
    private static HashSet<Object> changeableProperties = new HashSet<Serializable>(Arrays.asList("node_text", "icon", DetailModel.class, "note_text"));

    NodeList(String windowTitle, boolean searchInAllMaps, String windowPreferenceStorageProperty) {
        this.windowTitle = windowTitle;
        this.modal = false;
        this.searchInAllMaps = searchInAllMaps;
        this.mFilterTextSearchField = JComboBoxFactory.create();
        this.mFilterTextSearchField.setEditable(true);
        FilterTextDocumentListener listener = new FilterTextDocumentListener();
        this.mFilterTextSearchField.addActionListener(listener);
        JTextComponent editorComponent = (JTextComponent)this.mFilterTextSearchField.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener(listener);
        this.useRegexInFind = new JCheckBox(TextUtils.getText((String)"regular_expressions"));
        this.useRegexInFind.addActionListener(listener);
        this.matchCase = new JCheckBox(TextUtils.getText((String)"filter_match_case"));
        this.matchCase.addActionListener(listener);
        this.mapChangeListener = new MapChangeListener();
        this.windowPreferenceStorageProperty = windowPreferenceStorageProperty;
        this.dateRenderer = new DateRenderer();
        this.textRenderer = new TextRenderer();
        this.iconsRenderer = new IconsRenderer();
        this.tableView = new FlatNodeTable();
        this.tableView.setRowHeight(UITools.getDefaultLabelFont().getSize() * 5 / 4);
        this.mNodePath = new JTextField();
        this.closeAfterSelection = TranslatedElementFactory.createPropertyCheckbox((String)"nodelist_close_after_selection", (String)"close_after_selection");
    }

    protected void disposeDialog() {
        Component selectedComponent;
        if (this.dialog == null || !this.dialog.isVisible()) {
            return;
        }
        this.listedMaps = Collections.emptySet();
        TimeWindowConfigurationStorage storage = new TimeWindowConfigurationStorage();
        for (int i = 0; i < this.tableView.getColumnCount(); ++i) {
            TimeWindowColumnSetting setting = new TimeWindowColumnSetting();
            setting.setColumnWidth(this.tableView.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.sorter.getSortingStatus(i));
            storage.addTimeWindowColumnSetting(setting);
        }
        storage.storeDialogPositions(this.dialog, this.windowPreferenceStorageProperty);
        boolean dialogWasFocused = this.dialog.isFocused();
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.removeMapChangeListener((IMapChangeListener)this.mapChangeListener);
        mapController.removeNodeChangeListener((INodeChangeListener)this.mapChangeListener);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        mapController.addMapLifeCycleListener((IMapLifeCycleListener)this.mapChangeListener);
        if (dialogWasFocused && (selectedComponent = mapViewManager.getSelectedComponent()) != null) {
            selectedComponent.requestFocus();
        }
    }

    private void exportSelectedRowsAndClose() {
        int[] selectedRows = this.tableView.getSelectedRows();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            selectedNodes.add(this.getMindMapNode(row));
        }
        ModeController mindMapController = Controller.getCurrentModeController();
        MapModel newMap = MFileManager.getController(mindMapController).newMapFromDefaultTemplate();
        if (newMap != null) {
            for (NodeModel node : selectedNodes) {
                NodeModel copy = MapClipboardController.getController().duplicate(node, newMap, false);
                if (copy == null) continue;
                mindMapController.getMapController().insertNodeIntoWithoutUndo(copy, newMap.getRootNode());
            }
        }
        this.disposeDialog();
    }

    protected NodeModel getMindMapNode(int row) {
        NodeModel selectedNode = ((TextHolder)this.tableView.getModel().getValueAt(row, this.nodeTextColumn)).getNode();
        return selectedNode;
    }

    private void selectNodes(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            NodeModel focussedNode = this.getMindMapNode(focussedRow);
            MapModel map = focussedNode.getMap();
            ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
            for (int row : selectedRows) {
                NodeModel node = this.getMindMapNode(row);
                if (!node.getMap().equals(map)) continue;
                selectedNodes.add(node);
            }
            this.selectMap(map);
            Controller.getCurrentModeController().getMapController().selectMultipleNodes(focussedNode, selectedNodes);
            if (this.closeAfterSelection.isSelected()) {
                this.disposeDialog();
            }
        }
    }

    private void selectMap(MapModel map) {
        if (map.equals(Controller.getCurrentController().getMap())) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        Map maps = mapViewManager.getMaps("MindMap");
        for (Map.Entry entry : maps.entrySet()) {
            if (!map.equals(entry.getValue())) continue;
            mapViewManager.tryToChangeToMapView((String)entry.getKey());
        }
    }

    private void selectSelectedRows() {
        this.selectNodes(this.tableView.getSelectedRow(), this.tableView.getSelectedRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(NodeFilter nodeFilter) {
        if (this.dialog != null) {
            this.dialog.toFront();
            return;
        }
        ViewController viewController = Controller.getCurrentController().getViewController();
        viewController.setWaitingCursor(true);
        try {
            DefaultTableModel model = this.createTableModel();
            this.fillTableModel(model, nodeFilter);
            this.tableModel = model;
            String mapTitle = Controller.getCurrentController().getSelection().getMap().getTitle();
            this.initializeUI(mapTitle);
        }
        finally {
            viewController.setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(List<NodeModel> nodes) {
        if (this.dialog != null) {
            this.dialog.toFront();
            return;
        }
        ViewController viewController = Controller.getCurrentController().getViewController();
        viewController.setWaitingCursor(true);
        try {
            DefaultTableModel model = this.createTableModel();
            this.fillTableModel(model, nodes);
            this.tableModel = model;
            this.initializeUI("");
        }
        finally {
            viewController.setWaitingCursor(false);
        }
    }

    private void initializeUI(String mapTitle) {
        TimeWindowConfigurationStorage result;
        this.mFlatNodeTableFilterModel = new FlatNodeTableFilterModel(this.tableModel, new int[]{this.nodeTextColumn, this.nodeDetailsColumn, this.nodeNotesColumn});
        this.sorter = new TableSorter(this.mFlatNodeTableFilterModel);
        this.dialog = new JDialog(UITools.getCurrentFrame(), this.modal);
        this.dialog.setTitle(TextUtils.format((String)this.windowTitle, (Object[])new Object[]{mapTitle}));
        this.dialog.setDefaultCloseOperation(0);
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                NodeList.this.mFilterTextSearchField.getEditor().selectAll();
            }

            @Override
            public void windowClosing(WindowEvent event) {
                NodeList.this.disposeDialog();
            }
        };
        this.dialog.addWindowListener(windowListener);
        this.dialog.addWindowFocusListener(windowListener);
        UITools.addEscapeActionToDialog((JDialog)this.dialog, (Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        });
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridheight = 1;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.weighty = 0.0;
        layoutConstraints.anchor = 17;
        layoutConstraints.fill = 2;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)REMINDER_TEXT_FIND)), layoutConstraints);
        layoutConstraints.gridwidth = 1;
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.matchCase, layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.useRegexInFind, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add(this.mFilterTextSearchField, layoutConstraints);
        this.createSpecificUI(contentPane, layoutConstraints);
        this.tableView.addKeyListener(new FlatNodeTableKeyListener());
        this.tableView.addMouseListener(new FlatNodeTableMouseAdapter());
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableView.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableView.getTableHeader());
        this.sorter.setColumnComparator(Date.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setColumnComparator(NodeModel.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(IconsHolder.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setSortingStatus(this.nodeReminderColumn, 1);
        JScrollPane nodeContentScrollPane = new JScrollPane(this.tableView);
        UITools.setScrollbarIncrement((JScrollPane)nodeContentScrollPane);
        ++layoutConstraints.gridy;
        GridBagConstraints tableConstraints = (GridBagConstraints)layoutConstraints.clone();
        tableConstraints.weightx = 1.0;
        tableConstraints.weighty = 10.0;
        tableConstraints.fill = 1;
        contentPane.add((Component)nodeContentScrollPane, tableConstraints);
        this.mNodePath.setEditable(false);
        ++layoutConstraints.gridy;
        GridBagConstraints treeConstraints = (GridBagConstraints)layoutConstraints.clone();
        treeConstraints.fill = 1;
        JScrollPane nodePathScrollPane = new JScrollPane(this.mNodePath, 21, 32);
        UITools.setScrollbarIncrement((JScrollPane)nodePathScrollPane);
        contentPane.add((Component)nodePathScrollPane, treeConstraints);
        final AbstractAction exportAction = new AbstractAction(TextUtils.getText((String)"reminder.Export")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.exportSelectedRowsAndClose();
            }
        };
        JButton exportButton = new JButton(exportAction);
        final AbstractAction gotoAction = new AbstractAction(TextUtils.getText((String)"reminder.Goto")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.selectSelectedRows();
            }
        };
        JButton gotoButton = new JButton(gotoAction);
        AbstractAction disposeAction = new AbstractAction(TextUtils.getText((String)REMINDER_TEXT_CLOSE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        };
        JButton cancelButton = new JButton(disposeAction);
        gotoAction.setEnabled(false);
        exportAction.setEnabled(false);
        Box bar = Box.createHorizontalBox();
        bar.add(Box.createHorizontalGlue());
        bar.add(cancelButton);
        bar.add(exportButton);
        this.createSpecificButtons(bar);
        bar.add(gotoButton);
        bar.add(this.closeAfterSelection);
        bar.add(Box.createHorizontalGlue());
        ++layoutConstraints.gridy;
        contentPane.add((Component)bar, layoutConstraints);
        MnemonicSetter.INSTANCE.setComponentMnemonics(new Container[]{contentPane});
        ListSelectionModel rowSM = this.tableView.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                gotoAction.setEnabled(enable);
                exportAction.setEnabled(enable);
            }
        });
        rowSM.addListSelectionListener(new ListSelectionListener(){

            String getNodeTextWithAncestorNodes(NodeModel node) {
                String nodeText = TextController.getController().getShortPlainText(node);
                if (node.isRoot()) {
                    return nodeText;
                }
                return this.getNodeTextWithAncestorNodes(node.getParentNode()) + " -> " + nodeText;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    NodeList.this.mNodePath.setText("");
                    return;
                }
                int selectedRow = lsm.getLeadSelectionIndex();
                if (selectedRow >= 0) {
                    NodeModel mindMapNode = NodeList.this.getMindMapNode(selectedRow);
                    NodeList.this.mNodePath.setText(this.getNodeTextWithAncestorNodes(mindMapNode));
                } else {
                    NodeList.this.mNodePath.setText("");
                }
            }
        });
        String marshalled = ResourceController.getResourceController().getProperty(this.windowPreferenceStorageProperty);
        TimeWindowConfigurationStorage storage = result = TimeWindowConfigurationStorage.decorateDialog(marshalled, this.dialog);
        if (storage != null) {
            this.tableView.setAutoResizeMode(0);
            int column = 0;
            for (TimeWindowColumnSetting setting : storage.getListTimeWindowColumnSettingList()) {
                this.tableView.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.sorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
        }
        this.mFlatNodeTableFilterModel.setFilter((String)this.mFilterTextSearchField.getSelectedItem(), this.matchCase.isSelected(), this.useRegexInFind.isSelected());
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addUIMapChangeListener((IMapChangeListener)this.mapChangeListener);
        mapController.addUINodeChangeListener((INodeChangeListener)this.mapChangeListener);
        mapController.addMapLifeCycleListener((IMapLifeCycleListener)this.mapChangeListener);
        this.dialog.setVisible(true);
    }

    protected void createSpecificButtons(Container container) {
    }

    protected void createSpecificUI(Container contentPane, GridBagConstraints layoutConstraints) {
    }

    private void fillTableModel(DefaultTableModel model, List<NodeModel> nodes) {
        for (NodeModel node : nodes) {
            ReminderExtension hook = ReminderExtension.getExtension(node);
            Vector<?> row = this.createTableRowData(node, hook);
            model.addRow(row);
        }
    }

    private void fillTableModel(DefaultTableModel model, NodeFilter nodeFilter) {
        if (!this.searchInAllMaps) {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (selection != null) {
                this.listedMaps = Collections.singleton(selection.getMap());
                NodeModel node = selection.getSelectionRoot();
                this.fillModel(model, node, nodeFilter);
            }
        } else {
            this.listedMaps = new HashSet<MapModel>();
            Map maps = Controller.getCurrentController().getMapViewManager().getMaps("MindMap");
            for (MapModel map : maps.values()) {
                this.listedMaps.add(map);
                NodeModel node = map.getRootNode();
                this.fillModel(model, node, nodeFilter);
            }
        }
    }

    private DefaultTableModel createTableModel() {
        this.showsStyleIcons = ResourceController.getResourceController().getBooleanProperty("nodelist_shows_style_icons");
        this.nodeMapColumn = this.searchInAllMaps ? 0 : -1;
        this.nodeTextColumn = this.nodeMapColumn + 1;
        this.nodeIconColumn = this.nodeTextColumn + 1;
        this.nodeDetailsColumn = this.nodeIconColumn + 1;
        this.nodeNotesColumn = this.nodeDetailsColumn + 1;
        this.nodeReminderColumn = this.nodeNotesColumn + 1;
        this.nodeCreatedColumn = this.nodeReminderColumn + 1;
        this.nodeModifiedColumn = this.nodeCreatedColumn + 1;
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == NodeList.this.nodeReminderColumn || column == NodeList.this.nodeCreatedColumn || column == NodeList.this.nodeModifiedColumn) {
                    return Date.class;
                }
                if (column == NodeList.this.nodeTextColumn || column == NodeList.this.nodeNotesColumn || column == NodeList.this.nodeDetailsColumn) {
                    return TextHolder.class;
                }
                if (column == NodeList.this.nodeMapColumn) {
                    return String.class;
                }
                if (column == NodeList.this.nodeIconColumn) {
                    return IconsHolder.class;
                }
                return Object.class;
            }
        };
        if (this.searchInAllMaps) {
            model.addColumn(COLUMN_MAP);
        }
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_DETAILS);
        model.addColumn(COLUMN_NOTES);
        model.addColumn(COLUMN_REMINDER);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        return model;
    }

    private void fillModel(DefaultTableModel model, NodeModel node, NodeFilter nodeFilter) {
        ReminderExtension hook = ReminderExtension.getExtension(node);
        if (nodeFilter.showsNode(node, hook)) {
            Vector<?> row = this.createTableRowData(node, hook);
            model.addRow(row);
        }
        for (NodeModel child : node.getChildren()) {
            this.fillModel(model, child, nodeFilter);
        }
    }

    private Vector<?> createTableRowData(NodeModel node, ReminderExtension hook) {
        Date date = hook != null ? new Date(hook.getRemindUserAt()) : null;
        int columnNumber = 7;
        if (this.searchInAllMaps) {
            ++columnNumber;
        }
        Vector<Object> row = new Vector<Object>(++columnNumber);
        if (this.searchInAllMaps) {
            row.add(node.getMap().getTitle());
        }
        row.add(new TextHolder(new CoreTextAccessor(node)));
        row.add(new IconsHolder(node, this.showsStyleIcons));
        row.add(new TextHolder(new DetailTextAccessor(node)));
        row.add(new TextHolder(new NoteTextAccessor(node)));
        row.add(date);
        row.add(node.getHistoryInformation().getCreatedAt());
        row.add(node.getHistoryInformation().getLastModifiedAt());
        return row;
    }

    private boolean hasTableFieldValueChanged(Object property) {
        return changeableProperties.contains(property);
    }

    private final class FilterTextDocumentListener
    implements DocumentListener,
    ActionListener {
        private Timer mTypeDelayTimer = null;
        private String selectedItem = "";
        private boolean shouldMatchCase = false;
        private boolean shouldUseRegex = false;

        private FilterTextDocumentListener() {
        }

        private synchronized void delayedChange() {
            this.stopTimer();
            this.mTypeDelayTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterTextDocumentListener.this.change();
                }
            });
            this.mTypeDelayTimer.start();
        }

        public void stopTimer() {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.stop();
                this.mTypeDelayTimer = null;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        private synchronized void change() {
            this.stopTimer();
            String selectedItem = (String)NodeList.this.mFilterTextSearchField.getEditor().getItem();
            boolean shouldMatchCase = NodeList.this.matchCase.isSelected();
            boolean shouldUseRegex = NodeList.this.useRegexInFind.isSelected();
            if (!this.selectedItem.equals(selectedItem) || this.shouldMatchCase != shouldMatchCase || this.shouldUseRegex != shouldUseRegex) {
                this.selectedItem = selectedItem;
                this.shouldMatchCase = shouldMatchCase;
                this.shouldUseRegex = shouldUseRegex;
                NodeList.this.mFlatNodeTableFilterModel.setFilter(selectedItem, shouldMatchCase, shouldUseRegex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.change();
        }
    }

    private final class MapChangeListener
    implements IMapChangeListener,
    INodeChangeListener,
    IMapLifeCycleListener {
        private final DelayedRunner runner;

        public MapChangeListener() {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    NodeList.this.tableModel.fireTableDataChanged();
                }
            });
        }

        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
            NodeList.this.disposeDialog();
        }

        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            NodeList.this.disposeDialog();
        }

        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            NodeList.this.disposeDialog();
        }

        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            NodeList.this.disposeDialog();
        }

        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            NodeList.this.disposeDialog();
        }

        public void mapChanged(MapChangeEvent event) {
            NodeList.this.disposeDialog();
        }

        public void nodeChanged(NodeChangeEvent event) {
            if (NodeList.this.hasTableFieldValueChanged(event.getProperty())) {
                this.runner.runLater();
            }
        }

        public void onRemove(MapModel map) {
            if (NodeList.this.listedMaps.contains(map)) {
                NodeList.this.disposeDialog();
            }
        }

        public void onCreate(MapModel map) {
            if (NodeList.this.searchInAllMaps) {
                NodeList.this.disposeDialog();
            }
        }
    }

    private final class FlatNodeTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        private FlatNodeTable() {
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object object = this.getModel().getValueAt(row, column);
            if (object instanceof Date) {
                return NodeList.this.dateRenderer;
            }
            if (object instanceof TextHolder) {
                return NodeList.this.textRenderer;
            }
            if (object instanceof IconsHolder) {
                return NodeList.this.iconsRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int vColIndex) {
            return false;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                EventListener[] el = super.getListeners(KeyListener.class);
                if (e.getID() != 402) {
                    return;
                }
                for (int i = 0; i < el.length; ++i) {
                    KeyListener kl = (KeyListener)el[i];
                    kl.keyReleased(e);
                }
                return;
            }
            super.processKeyEvent(e);
        }
    }

    static interface NodeFilter {
        public boolean showsNode(NodeModel var1, ReminderExtension var2);
    }

    private final class FlatNodeTableKeyListener
    implements KeyListener {
        private FlatNodeTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                NodeList.this.disposeDialog();
            }
            if (arg0.getKeyCode() == 10) {
                NodeList.this.selectSelectedRows();
                NodeList.this.disposeDialog();
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    private final class FlatNodeTableMouseAdapter
    extends MouseAdapter {
        private FlatNodeTableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int row = NodeList.this.tableView.rowAtPoint(p);
                NodeList.this.selectNodes(row, new int[]{row});
                if (NodeList.this.closeAfterSelection.isSelected()) {
                    NodeList.this.disposeDialog();
                }
            }
        }
    }
}

