/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeWYSIWYG;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.mindmapmode.EditNodeExternalApplication;
import org.freeplane.view.swing.map.mindmapmode.EditNodeTextField;

public class MMapViewController
extends MapViewController
implements IEditBaseCreator {
    @Override
    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        boolean editExternal;
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("Unknown content type " + content);
        }
        String text = (String)content;
        String htmlEditingOption = ResourceController.getResourceController().getProperty("html_editing_option");
        boolean editInternalWysiwyg = editLong && StringUtils.equals((String)htmlEditingOption, (String)"internal-wysiwyg");
        boolean bl = editExternal = editLong && StringUtils.equals((String)htmlEditingOption, (String)"external");
        if (!HtmlUtils.isHtml((String)text)) {
            text = HtmlUtils.plainToHTML((String)text);
        }
        if (editInternalWysiwyg) {
            EditNodeWYSIWYG editNodeWYSIWYG = new EditNodeWYSIWYG(node, text, editControl, true);
            int preferredHeight = (int)((double)this.getComponent(node).getHeight() * 1.2);
            preferredHeight = Math.max(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_height")));
            preferredHeight = Math.min(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_height")));
            int preferredWidth = (int)((double)this.getComponent(node).getWidth() * 1.2);
            preferredWidth = Math.max(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_width")));
            preferredWidth = Math.min(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_width")));
            Dimension preferredSize = new Dimension(preferredWidth, preferredHeight);
            editNodeWYSIWYG.setPreferredContentSize(preferredSize);
            MainView mainView = (MainView)this.getComponent(node);
            NodeView nodeView = mainView.getNodeView();
            if (EditNodeBase.EditedComponent.TEXT.equals((Object)editControl.getEditType())) {
                Font font = this.getFont(node);
                editNodeWYSIWYG.setTitle("edit_long_node");
                editNodeWYSIWYG.setFont(font);
                Color nodeTextColor = nodeView.getTextColor(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                editNodeWYSIWYG.setTextColor(nodeTextColor);
                editNodeWYSIWYG.setBackground(nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
                editNodeWYSIWYG.setTextAlignment(mainView.getHorizontalAlignment());
                editNodeWYSIWYG.setCustomStyleSheet(mainView.getStyleSheet());
            } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)editControl.getEditType())) {
                MapView map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_details");
                editNodeWYSIWYG.setFont(map.getDetailFont());
                editNodeWYSIWYG.setTextColor(map.getDetailForeground());
                Color detailBackground = map.getDetailBackground();
                editNodeWYSIWYG.setBackground(detailBackground != null ? detailBackground : nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
                editNodeWYSIWYG.setTextAlignment(map.getDetailHorizontalAlignment());
                editNodeWYSIWYG.setCustomStyleSheet(map.getDetailCss().getStyleSheet());
            } else if (EditNodeBase.EditedComponent.NOTE.equals((Object)editControl.getEditType())) {
                MapView map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_note");
                editNodeWYSIWYG.setFont(map.getNoteFont());
                editNodeWYSIWYG.setTextColor(map.getNoteForeground());
                Color noteBackground = map.getNoteBackground();
                editNodeWYSIWYG.setBackground(noteBackground != null ? noteBackground : map.getBackground());
                editNodeWYSIWYG.setTextAlignment(map.getNoteHorizontalAlignment());
                editNodeWYSIWYG.setCustomStyleSheet(map.getNoteCss().getStyleSheet());
            }
            return editNodeWYSIWYG;
        }
        if (editExternal) {
            return new EditNodeExternalApplication(node, text, editControl);
        }
        EditNodeBase textfield = this.createEditor(node, editControl.getEditType(), text, editControl);
        if (textfield != null) {
            return textfield;
        }
        return this.createEditor(node, nodeProperty, text, editControl, true);
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.EditedComponent parent, String text, EditNodeBase.IEditControl editControl) {
        JComponent component;
        MainView mainView = (MainView)this.getComponent(node);
        NodeView nodeView = mainView.getNodeView();
        Object parentComponent = EditNodeBase.EditedComponent.TEXT.equals((Object)parent) ? mainView : (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent) ? ((component = nodeView.getContent(2)) instanceof ZoomableLabel ? (ZoomableLabel)component : null) : null);
        if (parentComponent == null || !parentComponent.isVisible()) {
            return null;
        }
        EditNodeTextField textField = new EditNodeTextField(node, (ZoomableLabel)parentComponent, text, editControl);
        if (EditNodeBase.EditedComponent.TEXT.equals((Object)parent)) {
            textField.setBackground(nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent)) {
            Color detailBackground = nodeView.getMap().getDetailBackground();
            textField.setBackground(detailBackground != null ? detailBackground : nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        }
        return textField;
    }

    public MMapViewController(Controller controller) {
        super(controller);
        new EditNodeTextField(null, null, null, null);
    }

    @Override
    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        return null;
    }
}

