/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class MNodeDropListener
implements DropTargetListener {
    private static final int UNFOLD_DELAY_MILLISECONDS = 500;
    private Timer timer;

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            this.supportFolding(dtde);
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    private void supportFolding(DropTargetDragEvent dtde) {
        MainView node = this.getNode(dtde);
        if (this.isInFoldingRegion(dtde)) {
            this.startUnfoldTimer(node);
        } else {
            this.stopUnfoldTimer();
        }
    }

    private boolean isInFoldingRegion(DropTargetDragEvent dtde) {
        MainView node = this.getNode(dtde);
        return node.dragOverRelation(dtde.getLocation()).isChild();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView node = this.getNode(e);
        this.stopUnfoldTimer();
        MainView mainView = node;
        mainView.stopDragOver();
        mainView.repaint();
    }

    private MainView getNode(DropTargetEvent e) {
        Component draggedNode = e.getDropTargetContext().getComponent();
        MainView mainView = (MainView)draggedNode;
        return mainView;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            this.supportFolding(dtde);
            MainView dropTarget = (MainView)dtde.getDropTargetContext().getComponent();
            dropTarget.setDragOverDirection(dtde.getLocation());
        }
    }

    private void startUnfoldTimer(final MainView mainView) {
        if (this.timer == null) {
            this.timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (mainView.isDisplayable()) {
                        NodeView nodeView = mainView.getNodeView();
                        NodeModel node = nodeView.getModel();
                        Controller.getCurrentModeController().getMapController().unfold(node, nodeView.getMap().getFilter());
                    }
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }

    private void stopUnfoldTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    private boolean isDropAcceptable(DropTargetDropEvent event, int dropAction) {
        List<NodeModel> droppedNodes;
        if (!event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return dropAction != 0x40000000;
        }
        try {
            Transferable t = event.getTransferable();
            droppedNodes = this.getNodeObjects(t);
        }
        catch (Exception e) {
            return dropAction != 0x40000000;
        }
        NodeModel node = ((MainView)event.getDropTargetContext().getComponent()).getNodeView().getModel();
        if (dropAction == 0x40000000) {
            return this.isFromSameMap(node, droppedNodes);
        }
        if (dropAction == 2) {
            return !this.isFromDescencantNode(node, droppedNodes);
        }
        return !this.droppedNodesContainTargetNode(node, droppedNodes);
    }

    private boolean droppedNodesContainTargetNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected) continue;
            return true;
        }
        return false;
    }

    private boolean isFromSameMap(NodeModel targetNode, Collection<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (selected.getMap() == targetNode.getMap()) continue;
            return false;
        }
        return true;
    }

    private boolean isFromDescencantNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected && !targetNode.isDescendantOf(selected)) continue;
            return true;
        }
        return false;
    }

    private List<NodeModel> getNodeObjects(Transferable t) throws UnsupportedFlavorException, IOException {
        return (List)t.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            boolean isTopOrLeft;
            this.stopUnfoldTimer();
            MainView mainView = (MainView)dtde.getDropTargetContext().getComponent();
            NodeView targetNodeView = mainView.getNodeView();
            MapView mapView = targetNodeView.getMap();
            mapView.select();
            NodeModel targetNode = targetNodeView.getModel();
            Controller controller = Controller.getCurrentController();
            int dropAction = this.getDropAction(dtde);
            Transferable t = dtde.getTransferable();
            mainView.stopDragOver();
            mainView.repaint();
            if (dtde.isLocalTransfer() && !this.isDropAcceptable(dtde, dropAction)) {
                dtde.rejectDrop();
                return;
            }
            MainView.DragOverRelation dragOverRelation = mainView.dragOverRelation(dtde.getLocation());
            if (dragOverRelation == MainView.DragOverRelation.NOT_AVAILABLE || dragOverRelation == MainView.DragOverRelation.SIBLING_AFTER) {
                dtde.rejectDrop();
                return;
            }
            boolean dropAsSibling = dragOverRelation == MainView.DragOverRelation.SIBLING_BEFORE;
            ModeController modeController = controller.getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (dropAction == 2 || dropAction == 1) {
                NodeModel parent;
                NodeModel nodeModel = parent = dropAsSibling ? targetNode.getParentNode() : targetNode;
                if (!mapController.isWriteable(parent)) {
                    dtde.rejectDrop();
                    String message = TextUtils.getText((String)"node_is_write_protected");
                    UITools.errorMessage((Object)message);
                    return;
                }
            }
            boolean bl = isTopOrLeft = dragOverRelation == MainView.DragOverRelation.CHILD_BEFORE;
            if (!dtde.isLocalTransfer()) {
                dtde.acceptDrop(1);
                NodeModel.Side side = dropAsSibling ? NodeModel.Side.AS_SIBLING : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? NodeModel.Side.AS_SIBLING : side, dropAction);
                dtde.dropComplete(true);
                return;
            }
            dtde.acceptDrop(dropAction);
            if (dropAction == 0x40000000) {
                int yesorno = 0;
                if (controller.getSelection().size() >= 5) {
                    yesorno = JOptionPane.showConfirmDialog(controller.getViewController().getCurrentRootComponent(), TextUtils.getText((String)"lots_of_links_warning"), Integer.toString(controller.getSelection().size()) + " links to the same node", 0);
                }
                if (yesorno == 0) {
                    for (NodeModel sourceNodeModel : this.getNodeObjects(t)) {
                        ((MLinkController)LinkController.getController((ModeController)modeController)).addConnector(sourceNodeModel, targetNode);
                    }
                }
            } else {
                List selecteds = mapController.getSelectedNodes();
                if (2 == dropAction && this.isFromSameMap(targetNode, selecteds)) {
                    NodeModel[] array = selecteds.toArray(new NodeModel[selecteds.size()]);
                    this.moveNodes(mapController, targetNode, t, dropAsSibling, isTopOrLeft);
                    if (dropAsSibling || !targetNodeView.isFolded()) {
                        controller.getSelection().replaceSelection(array);
                    } else {
                        controller.getSelection().selectAsTheOnlyOneSelected(targetNode);
                    }
                } else if (1 == dropAction || 2 == dropAction) {
                    NodeModel.Side side = dropAsSibling ? NodeModel.Side.AS_SIBLING : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                    ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? NodeModel.Side.AS_SIBLING : side);
                    controller.getSelection().selectAsTheOnlyOneSelected(targetNode);
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe((String)"Drop exception:", (Throwable)e);
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    private int getDropAction(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        int dropAction = dtde.getDropAction();
        Transferable t = dtde.getTransferable();
        if (dtde.isLocalTransfer() && t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
            String sourceAction = (String)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
            if (sourceAction.equals("LINK")) {
                dropAction = 0x40000000;
            }
            if (sourceAction.equals("COPY")) {
                dropAction = 1;
            }
        }
        return dropAction;
    }

    private void moveNodes(MMapController mapController, NodeModel targetNode, Transferable t, boolean dropAsSibling, boolean isTopOrLeft) throws UnsupportedFlavorException, IOException {
        List<NodeModel> movedNodes = this.getNodeObjects(t);
        if (dropAsSibling) {
            mapController.moveNodesBefore(movedNodes, targetNode);
            mapController.setSide(movedNodes, targetNode.getSide());
        } else {
            List nodesChangingParent = movedNodes.stream().filter(node -> targetNode != node.getParentNode()).collect(Collectors.toList());
            mapController.moveNodesAsChildren(movedNodes, targetNode);
            NodeModel.Side side = isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT;
            mapController.setSide(side == NodeModel.Side.DEFAULT ? nodesChangingParent : movedNodes, side);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        return ev.isDataFlavorSupported(DataFlavor.stringFlavor) || ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor) || ev.isDataFlavorSupported(DataFlavor.imageFlavor);
    }
}

