
#ifndef KIDLETIME_EXPORT_H
#define KIDLETIME_EXPORT_H

#ifdef KIDLETIME_STATIC_DEFINE
#  define KIDLETIME_EXPORT
#  define KIDLETIME_NO_EXPORT
#else
#  ifndef KIDLETIME_EXPORT
#    ifdef KF5IdleTime_EXPORTS
        /* We are building this library */
#      define KIDLETIME_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KIDLETIME_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KIDLETIME_NO_EXPORT
#    define KIDLETIME_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KIDLETIME_DECL_DEPRECATED
#  define KIDLETIME_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KIDLETIME_DECL_DEPRECATED_EXPORT
#  define KIDLETIME_DECL_DEPRECATED_EXPORT KIDLETIME_EXPORT KIDLETIME_DECL_DEPRECATED
#endif

#ifndef KIDLETIME_DECL_DEPRECATED_NO_EXPORT
#  define KIDLETIME_DECL_DEPRECATED_NO_EXPORT KIDLETIME_NO_EXPORT KIDLETIME_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIDLETIME_NO_DEPRECATED
#    define KIDLETIME_NO_DEPRECATED
#  endif
#endif

#define KIDLETIME_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KIDLETIME_NO_DEPRECATED) && !defined(KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIDLETIME_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIDLETIME_NO_DEPRECATED_WARNINGS) && !defined(KIDLETIME_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIDLETIME_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIDLETIME_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIDLETIME_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIDLETIME_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIDLETIME_NO_DEPRECATED)
#  undef KIDLETIME_DEPRECATED
#  define KIDLETIME_DEPRECATED_EXPORT KIDLETIME_EXPORT
#  define KIDLETIME_DEPRECATED_NO_EXPORT KIDLETIME_NO_EXPORT
#elif defined(KIDLETIME_NO_DEPRECATED_WARNINGS)
#  define KIDLETIME_DEPRECATED
#  define KIDLETIME_DEPRECATED_EXPORT KIDLETIME_EXPORT
#  define KIDLETIME_DEPRECATED_NO_EXPORT KIDLETIME_NO_EXPORT
#else
#  define KIDLETIME_DEPRECATED KIDLETIME_DECL_DEPRECATED
#  define KIDLETIME_DEPRECATED_EXPORT KIDLETIME_DECL_DEPRECATED_EXPORT
#  define KIDLETIME_DEPRECATED_NO_EXPORT KIDLETIME_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIDLETIME_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIDLETIME_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIDLETIME_NO_DEPRECATED
#  define KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56f00
#endif
#ifdef KIDLETIME_NO_DEPRECATED_WARNINGS
#  define KIDLETIME_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIDLETIME_DEPRECATED_WARNINGS_SINCE
#  ifdef KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIDLETIME_DEPRECATED_WARNINGS_SINCE KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIDLETIME_DEPRECATED_WARNINGS_SINCE 0x56f00
#  endif
#endif

#ifndef KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIDLETIME_DEPRECATED
#  define KIDLETIME_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KIDLETIME_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIDLETIME_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIDLETIME_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KIDLETIME_DEPRECATED_VERSION_5_76(text) KIDLETIME_DECL_DEPRECATED_TEXT(text)
#else
#  define KIDLETIME_DEPRECATED_VERSION_5_76(text)
#endif
#define KIDLETIME_DEPRECATED_VERSION_5(minor, text)      KIDLETIME_DEPRECATED_VERSION_5_##minor(text)
#define KIDLETIME_DEPRECATED_VERSION(major, minor, text) KIDLETIME_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIDLETIME_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIDLETIME_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIDLETIME_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIDLETIME_DEPRECATED_VERSION(major, minor, text)
#  define KIDLETIME_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIDLETIME_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIDLETIME_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIDLETIME_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KIDLETIME_EXPORT_H */
