/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolverForDecompiler;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderOptimized;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.EnumEntriesDeserializationSupportImpl;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.EnumEntriesDeserializationSupport;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0004J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForDecompilerBase;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/ResolverForDecompiler;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "enumEntriesDeserializationSupport", "Lorg/jetbrains/kotlin/serialization/deserialization/EnumEntriesDeserializationSupport;", "getEnumEntriesDeserializationSupport", "()Lorg/jetbrains/kotlin/serialization/deserialization/EnumEntriesDeserializationSupport;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "getPackageFragmentProvider", "()Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "createDummyModule", "name", "", "createDummyPackageFragment", "Lorg/jetbrains/kotlin/descriptors/impl/MutablePackageFragmentDescriptor;", "fqName", "resolveTopLevelClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "decompiler-to-psi"})
public abstract class DeserializerForDecompilerBase
implements ResolverForDecompiler {
    @NotNull
    private final FqName directoryPackageFqName;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ModuleDescriptorImpl moduleDescriptor;
    @NotNull
    private final PackageFragmentProvider packageFragmentProvider;
    @NotNull
    private final EnumEntriesDeserializationSupport enumEntriesDeserializationSupport;

    public DeserializerForDecompilerBase(@NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter(directoryPackageFqName, "directoryPackageFqName");
        this.directoryPackageFqName = directoryPackageFqName;
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue(storageManager, "NO_LOCKS");
        this.storageManager = storageManager;
        this.moduleDescriptor = this.createDummyModule("module for building decompiled sources");
        this.packageFragmentProvider = new PackageFragmentProviderOptimized(this){
            final /* synthetic */ DeserializerForDecompilerBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void collectPackageFragments(@NotNull FqName fqName2, @NotNull Collection<PackageFragmentDescriptor> packageFragments2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Intrinsics.checkNotNullParameter(packageFragments2, "packageFragments");
                packageFragments2.add(this.this$0.createDummyPackageFragment(fqName2));
            }

            public boolean isEmpty(@NotNull FqName fqName2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                return false;
            }

            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                return CollectionsKt.listOf(this.this$0.createDummyPackageFragment(fqName2));
            }

            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Intrinsics.checkNotNullParameter(nameFilter2, "nameFilter");
                throw new UnsupportedOperationException("This method is not supposed to be called.");
            }
        };
        this.enumEntriesDeserializationSupport = new EnumEntriesDeserializationSupportImpl(this.moduleDescriptor.getPlatform());
        this.moduleDescriptor.initialize(this.packageFragmentProvider);
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[2];
        moduleDescriptorImplArray[0] = this.moduleDescriptor;
        Intrinsics.checkNotNullExpressionValue(this.moduleDescriptor.getBuiltIns().getBuiltInsModule(), "moduleDescriptor.builtIns.builtInsModule");
        this.moduleDescriptor.setDependencies(moduleDescriptorImplArray);
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @NotNull
    protected abstract DeserializationComponents getDeserializationComponents();

    @NotNull
    protected abstract KotlinBuiltIns getBuiltIns();

    @NotNull
    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    protected final ModuleDescriptorImpl getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    protected final PackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @NotNull
    protected final EnumEntriesDeserializationSupport getEnumEntriesDeserializationSupport() {
        return this.enumEntriesDeserializationSupport;
    }

    @Override
    @Nullable
    public ClassDescriptor resolveTopLevelClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getDeserializationComponents().deserializeClass(classId);
    }

    @NotNull
    protected final MutablePackageFragmentDescriptor createDummyPackageFragment(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return new MutablePackageFragmentDescriptor(this.moduleDescriptor, fqName2);
    }

    private final ModuleDescriptorImpl createDummyModule(String name2) {
        Name name3 = Name.special('<' + name2 + '>');
        Intrinsics.checkNotNullExpressionValue(name3, "special(\"<$name>\")");
        return new ModuleDescriptorImpl(name3, this.storageManager, this.getBuiltIns(), null, null, null, 56, null);
    }
}

