/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J6\u0010\u0017\u001a\u00020\u00062\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u001a\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u001c2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J8\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u001e\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u001f\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\"\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010#\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010$\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010%\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010&\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010'\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010(\u001a\u00020\u0006*\u00020\u000b2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016*\u00020\u00132\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J,\u0010*\u001a\u00020+*\u00020+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "overriddenSymbols", "", "checkOverriddenExperimentalities", "memberSymbol", "overriddenMemberSymbols", "checkDeprecation", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkReturnType", "checkVisibility", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "retrieveDirectOverriddenOf", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,440:1\n13#2:441\n24#2:446\n24#2:466\n34#2:474\n20#2,2:475\n24#2:503\n24#2:504\n1#3:442\n1#3:463\n1549#4:443\n1620#4,2:444\n1622#4:447\n1045#4:448\n1549#4:449\n1620#4,3:450\n1603#4,9:453\n1855#4:462\n1856#4:464\n1612#4:465\n1747#4,3:467\n1549#4:470\n1620#4,3:471\n288#4:477\n289#4:487\n1360#4:497\n1446#4,5:498\n106#5:478\n99#5,3:479\n90#5:482\n78#5:483\n84#5:485\n103#5:486\n106#5:488\n99#5,3:489\n90#5:492\n78#5:493\n84#5:495\n103#5:496\n36#6:484\n36#6:494\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n*L\n104#1:441\n128#1:446\n149#1:466\n247#1:474\n257#1:475,2\n393#1:503\n409#1:504\n144#1:463\n127#1:443\n127#1:444,2\n127#1:447\n129#1:448\n138#1:449\n138#1:450,3\n144#1:453,9\n144#1:462\n144#1:464\n144#1:465\n164#1:467,3\n216#1:470\n216#1:471,3\n276#1:477\n276#1:487\n346#1:497\n346#1:498,5\n279#1:478\n279#1:479,3\n279#1:482\n279#1:483\n279#1:485\n279#1:486\n286#1:488\n286#1:489,3\n286#1:492\n286#1:493\n286#1:495\n286#1:496\n279#1:484\n286#1:494\n*E\n"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context);
        for (FirDeclaration it : declaration.getDeclarations()) {
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            FirCallableDeclaration callable = (FirCallableDeclaration)it;
            this.checkMember(callable.getSymbol(), declaration, reporter, typeCheckerState2, firTypeScope, context);
        }
    }

    private final List<FirCallableSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirCallableSymbol<?> memberSymbol) {
        List list2;
        FirCallableSymbol<?> firCallableSymbol = memberSymbol;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            $this$retrieveDirectOverriddenOf.processFunctionsByName(memberSymbol.getName(), retrieveDirectOverriddenOf.1.INSTANCE);
            list2 = FirTypeScopeKt.getDirectOverriddenFunctions$default($this$retrieveDirectOverriddenOf, (FirNamedFunctionSymbol)memberSymbol, false, 2, null);
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            $this$retrieveDirectOverriddenOf.processPropertiesByName(memberSymbol.getName(), retrieveDirectOverriddenOf.2.INSTANCE);
            list2 = FirTypeScopeKt.getDirectOverriddenProperties$default($this$retrieveDirectOverriddenOf, (FirPropertySymbol)memberSymbol, false, 2, null);
        } else {
            throw new IllegalArgumentException("unexpected member kind " + memberSymbol);
        }
        return list2;
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableSymbol<?> overrideDeclaration, FirCallableSymbol<?> baseDeclaration, CheckerContext context) {
        List<FirTypeParameterSymbol> overrideTypeParameters = overrideDeclaration.getTypeParameterSymbols();
        if (overrideTypeParameters.isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        List<FirTypeParameterSymbol> baseTypeParameters = baseDeclaration.getTypeParameterSymbols();
        Map map = new LinkedHashMap();
        int size = Math.min(overrideTypeParameters.size(), baseTypeParameters.size());
        for (int it = 0; it < size; ++it) {
            FirTypeParameterSymbol to = overrideTypeParameters.get(it);
            FirTypeParameterSymbol from2 = baseTypeParameters.get(it);
            map.put(from2, FirNestedClassifierScopeKt.toConeType(to));
        }
        return SubstitutorsKt.substitutorByMap(map, context.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols2.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            Modality modality = $this$modality$iv.getResolvedStatus().getModality();
            boolean isEffectivelyFinal = modality == null || modality == Modality.FINAL;
            if (!isEffectivelyFinal) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols2;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context) {
        boolean hasVisibleBase;
        block13: {
            boolean bl;
            block15: {
                List<Pair> visibilities;
                block14: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    DiagnosticReporter diagnosticReporter;
                    Iterator<Pair> $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (overriddenSymbols2.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to(it, $this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy22 = false;
                    visibilities = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a, T b) {
                            Pair pair = (Pair)a;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b;
                            Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues(comparable, n2 != null ? n2 : Integer.MIN_VALUE);
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol)) break block14;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy22 = overriddenSymbols2;
                        diagnosticReporter = reporter;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                    }
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                    if (firPropertyAccessorSymbol3 == null) break block15;
                    Iterable $this$map$iv2 = overriddenSymbols2;
                    diagnosticReporter = reporter;
                    firClass = containingClass;
                    firCallableSymbol = firPropertyAccessorSymbol3;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                    break block15;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare == null) {
                        this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, overridden, context);
                        break;
                    }
                    if (compare >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, overridden, context);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFile firFile = context.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List<FirClass> containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context.getSession(), file2, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                    bl = true;
                    break block13;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols2), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).getApiVersion());
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols2) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            DeprecationInfo deprecationInfo;
            if (overriddenSymbol.getDeprecation(FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).getApiVersion()) == null || (deprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (DeprecationInfo)CollectionsKt.firstOrNull((Iterable)object) : (deprecationInfo = null)) == null) continue;
            DeprecationInfo deprecationFromOverriddenSymbol = deprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirCallableSymbol<?> checkReturnType(FirCallableSymbol<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, TypeCheckerState typeCheckerState2, CheckerContext context) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getResolvedReturnTypeRef());
        if (overridingReturnType instanceof ConeErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType(context.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it)));
        }
        List bounds = (List)destination$iv$iv;
        int n = bounds.size();
        for (int it = 0; it < n; ++it) {
            boolean isReturnTypeOkForOverride;
            FirCallableSymbol<?> overriddenDeclaration = overriddenSymbols2.get(it);
            ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context);
            boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirPropertySymbol && ((FirPropertySymbol)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
            if (isReturnTypeOkForOverride) continue;
            return overriddenDeclaration;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMember(FirCallableSymbol<?> member, FirClass containingClass, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        block35: {
            block37: {
                block36: {
                    block34: {
                        overriddenMemberSymbols = this.retrieveDirectOverriddenOf(firTypeScope, member);
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        if ($this$isOverride$iv.getRawStatus().isOverride()) break block35;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                            return;
                        }
                        v0 = member.getSource();
                        v1 = kind = v0 != null ? v0.getKind() : null;
                        if (kind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
                            block33: {
                                var11_12 = overriddenMemberSymbols;
                                for (T var13_18 : var11_12) {
                                    it = (FirCallableSymbol)var13_18;
                                    $i$a$-find-FirOverrideChecker$checkMember$1 = false;
                                    $this$isFinal$iv = it;
                                    $i$f$isFinal = false;
                                    v2 = $this$isFinal$iv.getResolvedStatus().getModality() == null ? true : modality$iv == Modality.FINAL;
                                    if (!v2) continue;
                                    v3 = var13_18;
                                    break block33;
                                }
                                v3 = null;
                            }
                            v4 = v3;
                            if (v4 != null) {
                                base = v4;
                                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member, (Object)base, (DiagnosticContext)context, null, 32, null);
                            }
                            return;
                        }
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v5 = context.getContainingFile();
                        if (v5 == null) {
                            return;
                        }
                        file = v5;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                            var20_37 = it;
                            var21_38 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if (Intrinsics.areEqual($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE)) lbl-1000:
                                // 2 sources

                                {
                                    v6 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v6 = v7 = null;
                                }
                                if (v6 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v7 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v7 == null) break;
                                result$iv$iv = v7;
                            }
                            v8 = result$iv$iv.getSymbol();
                            if (v8 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityChecker.isVisible$default(var21_38, (FirMemberDeclaration)v8.getFir(), context.getSession(), file, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                            v9 = element$iv;
                            break block34;
                        }
                        v9 = null;
                    }
                    var13_19 = v9;
                    if (var13_19 == null) break block36;
                    $i$f$firstOrNull = var13_19;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if (Intrinsics.areEqual($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE)) lbl-1000:
                        // 2 sources

                        {
                            v10 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v10 = v11 = null;
                        }
                        if (v10 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v11 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v11 == null) break;
                        result$iv$iv = v11;
                    }
                    v12 = result$iv$iv.getSymbol();
                    if (v12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    var14_21 = v12;
                    if (var14_21 != null) break block37;
                }
                return;
            }
            overridden = var14_21;
            v13 = ClassMembersKt.containingClassLookupTag(overridden);
            var15_24 = v13 != null ? LookupTagUtilsKt.toSymbol(v13, context.getSession()) : null;
            v14 = var15_24 instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)var15_24 : null;
            if (v14 == null) {
                return;
            }
            originalContainingClassSymbol = v14;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, (Object)originalContainingClassSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, member, context);
            return;
        }
        this.checkOverriddenExperimentalities(member, overriddenMemberSymbols, context, reporter);
        v15 = this.checkModality(overriddenMemberSymbols);
        if (v15 != null) {
            it = v15;
            $i$a$-let-FirOverrideChecker$checkMember$3 = false;
            FirOverrideChecker.INSTANCE.reportOverridingFinalMember(reporter, member, it, context);
        }
        if (member instanceof FirPropertySymbol) {
            v16 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v16 != null) {
                it = v16;
                $i$a$-let-FirOverrideChecker$checkMember$4 = false;
                FirOverrideChecker.INSTANCE.reportVarOverriddenByVal(reporter, member, it, context);
            }
        }
        this.checkVisibility(member, containingClass, reporter, overriddenMemberSymbols, context);
        this.checkDeprecation(member, reporter, overriddenMemberSymbols, context);
        v17 = this.checkReturnType(member, overriddenMemberSymbols, typeCheckerState, context);
        if (v17 == null) {
            return;
        }
        restriction = v17;
        var9_11 = member;
        if (var9_11 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter, member, restriction, context);
        } else if (var9_11 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(reporter, member, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter, member, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context, DiagnosticReporter reporter) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2413 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session = context.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf(it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2413.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2413.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context, reporter);
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportNothingToOverride, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, (DiagnosticContext)context, null, 16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }
}

