/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002Ja\u0010\u000b\u001a\u00020\u0006\"\u0004\b\u0000\u0010\f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000e2$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u0014\"\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "createLong", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "v", "", "lowerConst", "C", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "carrierFactory", "Lkotlin/Function4;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "args", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrConst;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lkotlin/jvm/functions/Function4;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitConst", "backend.js"})
@SourceDebugExtension(value={"SMAP\nConstLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,111:1\n346#2,12:112\n*S KotlinDebug\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n*L\n40#1:112,12\n*E\n"})
public final class ConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    public ConstTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    private final <C> IrExpression lowerConst(IrConst<?> expression2, IrClassSymbol irClass2, Function4<? super Integer, ? super Integer, ? super IrType, ? super C, ? extends IrExpression> carrierFactory, C ... args) {
        IrConstructorCallImpl irConstructorCallImpl;
        Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(irClass2);
        boolean $i$f$single = false;
        IrConstructorSymbol single$iv = null;
        boolean found$iv = false;
        Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrConstructorSymbol element$iv;
            IrConstructorSymbol it = element$iv = iterator2.next();
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol constructor2 = single$iv;
        IrType argType = CollectionsKt.first(((IrConstructor)constructor2.getOwner()).getValueParameters()).getType();
        IrConstructorCallImpl $this$lowerConst_u24lambda_u241 = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), IrTypesKt.getDefaultType(irClass2), constructor2, null, 16, null);
        boolean bl = false;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            $this$lowerConst_u24lambda_u241.putValueArgument(i, carrierFactory.invoke($this$lowerConst_u24lambda_u241.getStartOffset(), $this$lowerConst_u24lambda_u241.getEndOffset(), argType, args[i]));
        }
        return irConstructorCallImpl;
    }

    private final IrExpression createLong(IrConst<?> expression2, long v) {
        Integer[] integerArray = new Integer[]{(int)v, (int)(v >> 32)};
        return this.lowerConst(expression2, this.context.getIntrinsics().getLongClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

            @NotNull
            public final IrConstImpl<Integer> invoke(int p0, int p1, @NotNull IrType p2, int p3) {
                Intrinsics.checkNotNullParameter(p2, "p2");
                return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
            }

            @NotNull
            public final String getSignature() {
                return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }

            @NotNull
            public final String getName() {
                return "int";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
            }
        }, integerArray);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsIntrinsics $this$visitConst_u24lambda_u242 = this.context.getIntrinsics();
        boolean bl = false;
        if (IrTypeUtilsKt.isUnsigned(expression2.getType()) && !Intrinsics.areEqual(expression2.getKind(), IrConstKind.Null.INSTANCE)) {
            IrExpression irExpression2;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(expression2.getType());
            if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u242.getUByteClassSymbol())) {
                Byte[] byteArray = new Byte[]{IrConstKind.Byte.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u242.getUByteClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Byte, IrConstImpl<Byte>>((Object)IrConstImpl.Companion){

                    @NotNull
                    public final IrConstImpl<Byte> invoke(int p0, int p1, @NotNull IrType p2, byte p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).byte(p0, p1, p2, p3);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "byte(IILorg/jetbrains/kotlin/ir/types/IrType;B)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    @NotNull
                    public final String getName() {
                        return "byte";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, byteArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u242.getUShortClassSymbol())) {
                Short[] shortArray = new Short[]{IrConstKind.Short.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u242.getUShortClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Short, IrConstImpl<Short>>((Object)IrConstImpl.Companion){

                    @NotNull
                    public final IrConstImpl<Short> invoke(int p0, int p1, @NotNull IrType p2, short p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).short(p0, p1, p2, p3);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "short(IILorg/jetbrains/kotlin/ir/types/IrType;S)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    @NotNull
                    public final String getName() {
                        return "short";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, shortArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u242.getUIntClassSymbol())) {
                Integer[] integerArray = new Integer[]{IrConstKind.Int.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u242.getUIntClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

                    @NotNull
                    public final IrConstImpl<Integer> invoke(int p0, int p1, @NotNull IrType p2, int p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    @NotNull
                    public final String getName() {
                        return "int";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, integerArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u242.getULongClassSymbol())) {
                Long[] longArray = new Long[]{IrConstKind.Long.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u242.getULongClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Long, IrExpression>(this, expression2){
                    final /* synthetic */ ConstTransformer this$0;
                    final /* synthetic */ IrConst<?> $expression;
                    {
                        this.this$0 = $receiver;
                        this.$expression = $expression;
                        super(4);
                    }

                    @NotNull
                    public final IrExpression invoke(int n, int n2, @NotNull IrType irType, long v) {
                        Intrinsics.checkNotNullParameter(irType, "<anonymous parameter 2>");
                        return ConstTransformer.access$createLong(this.this$0, this.$expression, v);
                    }
                }, longArray);
            } else {
                CompilationExceptionKt.compilationException("Unknown unsigned type", expression2);
                throw null;
            }
            return irExpression2;
        }
        if (expression2.getKind() instanceof IrConstKind.Char) {
            Integer[] integerArray = new Integer[]{((Character)IrConstKind.Char.INSTANCE.valueOf(expression2)).charValue()};
            irExpression = this.lowerConst(expression2, $this$visitConst_u24lambda_u242.getCharClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

                @NotNull
                public final IrConstImpl<Integer> invoke(int p0, int p1, @NotNull IrType p2, int p3) {
                    Intrinsics.checkNotNullParameter(p2, "p2");
                    return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                }

                @NotNull
                public final String getSignature() {
                    return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                }

                @NotNull
                public final String getName() {
                    return "int";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                }
            }, integerArray);
        } else {
            irExpression = expression2.getKind() instanceof IrConstKind.Long ? this.createLong(expression2, ((Number)IrConstKind.Long.INSTANCE.valueOf(expression2)).longValue()) : super.visitConst(expression2);
        }
        return irExpression;
    }

    public static final /* synthetic */ IrExpression access$createLong(ConstTransformer $this, IrConst expression2, long v) {
        return $this.createLong(expression2, v);
    }
}

