
#ifndef KWAYLANDSERVER_EXPORT_H
#define KWAYLANDSERVER_EXPORT_H

#ifdef KWAYLANDSERVER_STATIC_DEFINE
#  define KWAYLANDSERVER_EXPORT
#  define KWAYLANDSERVER_NO_EXPORT
#else
#  ifndef KWAYLANDSERVER_EXPORT
#    ifdef KF5WaylandServer_EXPORTS
        /* We are building this library */
#      define KWAYLANDSERVER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KWAYLANDSERVER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KWAYLANDSERVER_NO_EXPORT
#    define KWAYLANDSERVER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KWAYLANDSERVER_DECL_DEPRECATED
#  define KWAYLANDSERVER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KWAYLANDSERVER_DECL_DEPRECATED_EXPORT
#  define KWAYLANDSERVER_DECL_DEPRECATED_EXPORT KWAYLANDSERVER_EXPORT KWAYLANDSERVER_DECL_DEPRECATED
#endif

#ifndef KWAYLANDSERVER_DECL_DEPRECATED_NO_EXPORT
#  define KWAYLANDSERVER_DECL_DEPRECATED_NO_EXPORT KWAYLANDSERVER_NO_EXPORT KWAYLANDSERVER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KWAYLANDSERVER_NO_DEPRECATED
#    define KWAYLANDSERVER_NO_DEPRECATED
#  endif
#endif

#define KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KWAYLANDSERVER_NO_DEPRECATED) && !defined(KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KWAYLANDSERVER_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KWAYLANDSERVER_NO_DEPRECATED_WARNINGS) && !defined(KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KWAYLANDSERVER_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KWAYLANDSERVER_NO_DEPRECATED)
#  undef KWAYLANDSERVER_DEPRECATED
#  define KWAYLANDSERVER_DEPRECATED_EXPORT KWAYLANDSERVER_EXPORT
#  define KWAYLANDSERVER_DEPRECATED_NO_EXPORT KWAYLANDSERVER_NO_EXPORT
#elif defined(KWAYLANDSERVER_NO_DEPRECATED_WARNINGS)
#  define KWAYLANDSERVER_DEPRECATED
#  define KWAYLANDSERVER_DEPRECATED_EXPORT KWAYLANDSERVER_EXPORT
#  define KWAYLANDSERVER_DEPRECATED_NO_EXPORT KWAYLANDSERVER_NO_EXPORT
#else
#  define KWAYLANDSERVER_DEPRECATED KWAYLANDSERVER_DECL_DEPRECATED
#  define KWAYLANDSERVER_DEPRECATED_EXPORT KWAYLANDSERVER_DECL_DEPRECATED_EXPORT
#  define KWAYLANDSERVER_DEPRECATED_NO_EXPORT KWAYLANDSERVER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KWAYLANDSERVER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KWAYLANDSERVER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KWAYLANDSERVER_NO_DEPRECATED
#  define KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56f00
#endif
#ifdef KWAYLANDSERVER_NO_DEPRECATED_WARNINGS
#  define KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE
#  ifdef KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE 0x56f00
#  endif
#endif

#ifndef KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KWAYLANDSERVER_DEPRECATED
#  define KWAYLANDSERVER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KWAYLANDSERVER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KWAYLANDSERVER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x50500
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_5(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_5(text)
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_28(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_28(text)
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x53200
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_50(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_50(text)
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x53400
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_52(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_52(text)
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x54500
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_69(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_69(text)
#endif

#if KWAYLANDSERVER_DEPRECATED_WARNINGS_SINCE >= 0x54900
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_73(text) KWAYLANDSERVER_DECL_DEPRECATED_TEXT(text)
#else
#  define KWAYLANDSERVER_DEPRECATED_VERSION_5_73(text)
#endif
#define KWAYLANDSERVER_DEPRECATED_VERSION_5(minor, text)      KWAYLANDSERVER_DEPRECATED_VERSION_5_##minor(text)
#define KWAYLANDSERVER_DEPRECATED_VERSION(major, minor, text) KWAYLANDSERVER_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KWAYLANDSERVER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KWAYLANDSERVER_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KWAYLANDSERVER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KWAYLANDSERVER_DEPRECATED_VERSION(major, minor, text)
#  define KWAYLANDSERVER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KWAYLANDSERVER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KWAYLANDSERVER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KWAYLANDSERVER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KWAYLANDSERVER_EXPORT_H */
