"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.patch = exports.minor = exports.semver = exports.newest = exports.latest = exports.greatest = exports.list = void 0;
const spawn_please_1 = __importDefault(require("spawn-please"));
const keyValueBy_1 = __importDefault(require("../lib/keyValueBy"));
const programError_1 = __importDefault(require("../lib/programError"));
const npm = __importStar(require("./npm"));
/** Spawn bun. */
async function spawnBun(args, npmOptions = {}, spawnOptions = {}) {
    // Bun not yet supported on Windows.
    // @see https://github.com/oven-sh/bun/issues/43
    if (process.platform === 'win32') {
        (0, programError_1.default)(npmOptions, 'Bun not yet supported on Windows');
    }
    args = Array.isArray(args) ? args : [args];
    const fullArgs = [
        ...args,
        ...(npmOptions.prefix ? `--prefix=${npmOptions.prefix}` : []),
        ...(npmOptions.location === 'global' ? ['--global'] : []),
    ];
    return (0, spawn_please_1.default)('bun', fullArgs, spawnOptions);
}
/**
 * (Bun) Fetches the list of all installed packages.
 */
const list = async (options = {}) => {
    const stdout = await spawnBun(['pm', 'ls'], {
        ...(options.global ? { location: 'global' } : null),
        ...(options.prefix ? { prefix: options.prefix } : null),
    }, {
        env: {
            ...process.env,
            // When bun is spawned in the GitHub Actions environment, it outputs ANSI color for some reason.
            // Disable color to ensure the output is parsed correctly.
            // https://bun.sh/docs/runtime/configuration#environment-variables
            NO_COLOR: '1',
        },
        ...(options.cwd ? { cwd: options.cwd } : null),
        rejectOnError: false,
    });
    // parse the output of `bun pm ls` into an object { [name]: version }
    const lines = stdout.split('\n');
    const dependencies = (0, keyValueBy_1.default)(lines, line => {
        const match = line.match(/.* (.*?)@(.+)/);
        if (match) {
            const [, name, version] = match;
            return { [name]: version };
        }
        return null;
    });
    return dependencies;
};
exports.list = list;
exports.greatest = npm.greatest;
exports.latest = npm.latest;
exports.newest = npm.newest;
exports.semver = npm.semver;
exports.minor = npm.minor;
exports.patch = npm.patch;
exports.default = spawnBun;
//# sourceMappingURL=bun.js.map