/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TransitGatewayNetworkInterfaceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTransitGatewayMulticastGroupMembersRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RegisterTransitGatewayMulticastGroupMembersRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayMulticastDomainId").getter(RegisterTransitGatewayMulticastGroupMembersRequest.getter(RegisterTransitGatewayMulticastGroupMembersRequest::transitGatewayMulticastDomainId)).setter(RegisterTransitGatewayMulticastGroupMembersRequest.setter(Builder::transitGatewayMulticastDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId").unmarshallLocationName("TransitGatewayMulticastDomainId").build()}).build();
    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupIpAddress").getter(RegisterTransitGatewayMulticastGroupMembersRequest.getter(RegisterTransitGatewayMulticastGroupMembersRequest::groupIpAddress)).setter(RegisterTransitGatewayMulticastGroupMembersRequest.setter(Builder::groupIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress").unmarshallLocationName("GroupIpAddress").build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(RegisterTransitGatewayMulticastGroupMembersRequest.getter(RegisterTransitGatewayMulticastGroupMembersRequest::networkInterfaceIds)).setter(RegisterTransitGatewayMulticastGroupMembersRequest.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIds").unmarshallLocationName("NetworkInterfaceIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, GROUP_IP_ADDRESS_FIELD, NETWORK_INTERFACE_IDS_FIELD));
    private final String transitGatewayMulticastDomainId;
    private final String groupIpAddress;
    private final List<String> networkInterfaceIds;

    private RegisterTransitGatewayMulticastGroupMembersRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.groupIpAddress = builder.groupIpAddress;
        this.networkInterfaceIds = builder.networkInterfaceIds;
    }

    public final String transitGatewayMulticastDomainId() {
        return this.transitGatewayMulticastDomainId;
    }

    public final String groupIpAddress() {
        return this.groupIpAddress;
    }

    public final boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTransitGatewayMulticastGroupMembersRequest)) {
            return false;
        }
        RegisterTransitGatewayMulticastGroupMembersRequest other = (RegisterTransitGatewayMulticastGroupMembersRequest)((Object)obj);
        return Objects.equals(this.transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId()) && Objects.equals(this.groupIpAddress(), other.groupIpAddress()) && this.hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds() && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTransitGatewayMulticastGroupMembersRequest").add("TransitGatewayMulticastDomainId", (Object)this.transitGatewayMulticastDomainId()).add("GroupIpAddress", (Object)this.groupIpAddress()).add("NetworkInterfaceIds", this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMulticastDomainId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMulticastDomainId()));
            }
            case "GroupIpAddress": {
                return Optional.ofNullable(clazz.cast(this.groupIpAddress()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTransitGatewayMulticastGroupMembersRequest, T> g) {
        return obj -> g.apply((RegisterTransitGatewayMulticastGroupMembersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayMulticastDomainId;
        private String groupIpAddress;
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTransitGatewayMulticastGroupMembersRequest model) {
            super(model);
            this.transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            this.groupIpAddress(model.groupIpAddress);
            this.networkInterfaceIds(model.networkInterfaceIds);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (this.networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTransitGatewayMulticastGroupMembersRequest build() {
            return new RegisterTransitGatewayMulticastGroupMembersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTransitGatewayMulticastGroupMembersRequest> {
        public Builder transitGatewayMulticastDomainId(String var1);

        public Builder groupIpAddress(String var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

