/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gauntlet;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gloves;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;

public class Sai
extends MeleeWeapon {
    public Sai() {
        this.image = ItemSpriteSheet.SAI;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.3f;
        this.tier = 3;
        this.DLY = 0.5f;
    }

    @Override
    public int max(int lvl) {
        return Math.round(2.5f * (float)(this.tier + 1)) + lvl * Math.round(0.5f * (float)(this.tier + 1));
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Sai.comboStrikeAbility(hero, target, 0.4f, this);
    }

    public static void comboStrikeAbility(final Hero hero, Integer target, final float boostPerHit, final MeleeWeapon wep) {
        if (target == null) {
            return;
        }
        final Char enemy = Actor.findChar(target);
        if (enemy == null || enemy == hero || hero.isCharmedBy(enemy) || !Dungeon.level.heroFOV[target]) {
            GLog.w(Messages.get(wep, "ability_no_target", new Object[0]), new Object[0]);
            return;
        }
        hero.belongings.abilityWeapon = wep;
        if (!hero.canAttack(enemy)) {
            GLog.w(Messages.get(wep, "ability_bad_position", new Object[0]), new Object[0]);
            hero.belongings.abilityWeapon = null;
            return;
        }
        hero.belongings.abilityWeapon = null;
        hero.sprite.attack(enemy.pos, new Callback(){

            @Override
            public void call() {
                boolean hit;
                wep.beforeAbilityUsed(hero, enemy);
                AttackIndicator.target(enemy);
                int recentHits = 0;
                ComboStrikeTracker buff = hero.buff(ComboStrikeTracker.class);
                if (buff != null) {
                    recentHits = buff.totalHits();
                    buff.detach();
                }
                if ((hit = hero.attack(enemy, 1.0f + boostPerHit * (float)recentHits, 0.0f, Char.INFINITE_ACCURACY)) && !enemy.isAlive()) {
                    MeleeWeapon.onAbilityKill(hero, enemy);
                }
                Invisibility.dispel();
                hero.spendAndNext(hero.attackDelay());
                if (recentHits >= 2 && hit) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                }
                wep.afterAbilityUsed(hero);
            }
        });
    }

    public static class ComboStrikeTracker
    extends Buff {
        public static int DURATION = 6;
        public int[] hits;
        public static String RECENT_HITS = "recent_hits";

        public ComboStrikeTracker() {
            this.type = Buff.buffType.POSITIVE;
            this.hits = new int[DURATION];
        }

        @Override
        public int icon() {
            if (this.totalHits() == 0) {
                return 127;
            }
            if (Dungeon.hero.belongings.weapon() instanceof Gloves || Dungeon.hero.belongings.weapon() instanceof Sai || Dungeon.hero.belongings.weapon() instanceof Gauntlet || Dungeon.hero.belongings.secondWep() instanceof Gloves || Dungeon.hero.belongings.secondWep() instanceof Sai || Dungeon.hero.belongings.secondWep() instanceof Gauntlet) {
                return 69;
            }
            return 127;
        }

        @Override
        public boolean act() {
            for (int i = 0; i < DURATION; ++i) {
                this.hits[i] = i == DURATION - 1 ? 0 : this.hits[i + 1];
            }
            if (this.totalHits() == 0) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        public void addHit() {
            int n = DURATION - 1;
            this.hits[n] = this.hits[n] + 1;
        }

        public int totalHits() {
            int sum = 0;
            for (int i = 0; i < DURATION; ++i) {
                sum += this.hits[i];
            }
            return sum;
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString(this.totalHits());
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.totalHits());
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(RECENT_HITS, this.hits);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            if (bundle.contains(RECENT_HITS)) {
                this.hits = bundle.getIntArray(RECENT_HITS);
            }
        }
    }
}

