/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystemWithOlderRelease;
import org.eclipse.jdt.internal.compiler.util.RuntimeIOException;

class JrtFileSystem {
    private final Map<String, String> packageToModule = new HashMap<String, String>();
    private final Map<String, List<String>> packageToModules = new HashMap<String, List<String>>();
    private final Map<Path, Optional<byte[]>> classCache = new ConcurrentHashMap<Path, Optional<byte[]>>(10007);
    FileSystem fs;
    Path modRoot;
    String jdkHome;

    public static JrtFileSystem getNewJrtFileSystem(File file, String string) throws IOException {
        return string == null ? new JrtFileSystem(file) : new JrtFileSystemWithOlderRelease(file, string);
    }

    JrtFileSystem(File file) throws IOException {
        this.initialize(file);
    }

    void initialize(File file) throws IOException {
        URL uRL = null;
        this.jdkHome = null;
        if (file.toString().endsWith("jrt-fs.jar")) {
            uRL = file.toPath().toUri().toURL();
            this.jdkHome = file.getParentFile().getParent();
        } else {
            this.jdkHome = file.toPath().toString();
            uRL = Paths.get(this.jdkHome, "lib", "jrt-fs.jar").toUri().toURL();
        }
        JRTUtil.MODULE_TO_LOAD = System.getProperty("modules.to.load");
        String string = System.getProperty("java.version");
        if (string != null && string.startsWith("1.8")) {
            try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});){
                HashMap hashMap = new HashMap();
                this.fs = FileSystems.newFileSystem(JRTUtil.JRT_URI, hashMap, (ClassLoader)uRLClassLoader);
            }
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("java.home", this.jdkHome);
            this.fs = FileSystems.newFileSystem(JRTUtil.JRT_URI, hashMap);
        }
        this.modRoot = this.fs.getPath("/modules", new String[0]);
        this.walkJrtForModules();
    }

    public List<String> getModulesDeclaringPackage(String string, String string2) {
        List<String> list;
        string = string.replace('.', '/');
        String string3 = this.packageToModule.get(string);
        if (string2 == null) {
            if (string3 == null) {
                return null;
            }
            if (string3 == "MU") {
                return this.packageToModules.get(string);
            }
            return Collections.singletonList(string3);
        }
        if (string3 != null && (string3 == "MU" ? (list = this.packageToModules.get(string)).contains(string2) : string3.equals(string2))) {
            return Collections.singletonList(string2);
        }
        return null;
    }

    public String[] getModules(String string) {
        int n = string.lastIndexOf(47);
        String string2 = null;
        string2 = n != -1 ? string.substring(0, n) : "";
        String string3 = this.packageToModule.get(string2);
        if (string3 != null) {
            if (string3 == "MU") {
                List<String> list = this.packageToModules.get(string2);
                return list.toArray(new String[0]);
            }
            return new String[]{string3};
        }
        return JRTUtil.DEFAULT_MODULE;
    }

    public boolean hasClassFile(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = this.packageToModule.get(string);
        if (string3 == null || string3 != "MU" && !string3.equals(string2)) {
            return false;
        }
        Path path2 = this.fs.getPath("/modules", string2, string);
        if (!Files.exists(path2, new LinkOption[0])) {
            return false;
        }
        try {
            return Files.list(path2).anyMatch(path -> path.toString().endsWith(".class") || path.toString().endsWith(".CLASS"));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public InputStream getContentFromJrt(String string, String string2) throws IOException {
        String[] stringArray;
        if (string2 != null) {
            byte[] byArray = this.getFileBytes(string, string2);
            if (byArray == null) {
                return null;
            }
            return new ByteArrayInputStream(byArray);
        }
        for (String string3 : stringArray = this.getModules(string)) {
            byte[] byArray = this.getFileBytes(string, string3);
            if (byArray == null) continue;
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    private ClassFileReader getClassfile(String string, Predicate<String> predicate) throws IOException, ClassFormatException {
        String[] stringArray = this.getModules(string);
        byte[] byArray = null;
        String string2 = null;
        for (String string3 : stringArray) {
            if (predicate != null && !predicate.test(string3) || (byArray = this.getFileBytes(string, string3)) == null) continue;
            string2 = string3;
            break;
        }
        if (byArray != null) {
            ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
            classFileReader.moduleName = string2.toCharArray();
            return classFileReader;
        }
        return null;
    }

    byte[] getClassfileContent(String string, String string2) throws IOException {
        byte[] byArray = null;
        if (string2 != null) {
            byArray = this.getFileBytes(string, string2);
        } else {
            String string3;
            String[] stringArray;
            String[] stringArray2 = stringArray = this.getModules(string);
            int n = stringArray2.length;
            for (int i = 0; i < n && (byArray = this.getFileBytes(string, string3 = stringArray2[i])) == null; ++i) {
            }
        }
        return byArray;
    }

    private byte[] getFileBytes(String string, String string2) throws IOException {
        Path path2 = this.fs.getPath("/modules", string2, string);
        if (JRTUtil.DISABLE_CACHE) {
            return JRTUtil.safeReadBytes(path2);
        }
        try {
            Optional optional = this.classCache.computeIfAbsent(path2, path -> {
                try {
                    return Optional.ofNullable(JRTUtil.safeReadBytes(path));
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException);
                }
            });
            return optional.orElse(null);
        }
        catch (RuntimeIOException runtimeIOException) {
            throw runtimeIOException.getCause();
        }
    }

    public ClassFileReader getClassfile(String string, String string2, Predicate<String> predicate) throws IOException, ClassFormatException {
        ClassFileReader classFileReader = null;
        if (string2 == null) {
            classFileReader = this.getClassfile(string, predicate);
        } else {
            byte[] byArray = this.getFileBytes(string, string2);
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string.toCharArray());
                classFileReader.moduleName = string2.toCharArray();
            }
        }
        return classFileReader;
    }

    public ClassFileReader getClassfile(String string, IModule iModule) throws IOException, ClassFormatException {
        ClassFileReader classFileReader = null;
        if (iModule == null) {
            classFileReader = this.getClassfile(string, (Predicate<String>)null);
        } else {
            byte[] byArray = this.getFileBytes(string, new String(iModule.name()));
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string.toCharArray());
            }
        }
        return classFileReader;
    }

    void walkJrtForModules() throws IOException {
        Iterable<Path> iterable = this.fs.getRootDirectories();
        for (Path path : iterable) {
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    for (final Path path2 : directoryStream) {
                        if (path2.toString().equals("/modules")) continue;
                        Files.walkFileTree(path2, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                Path path22 = path2.relativize(path);
                                JrtFileSystem.this.cachePackage(path22.getParent().toString(), path22.getFileName().toString());
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                finally {
                    if (directoryStream == null) continue;
                    directoryStream.close();
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage(), exception);
            }
        }
    }

    void walkModuleImage(final JRTUtil.JrtFileVisitor<Path> jrtFileVisitor, final int n) throws IOException {
        Files.walkFileTree(this.modRoot, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                int n2 = path.getNameCount();
                if (n2 == 1) {
                    return FileVisitResult.CONTINUE;
                }
                if (n2 == 2) {
                    Path path2 = path.getName(1);
                    if (JRTUtil.MODULE_TO_LOAD != null && JRTUtil.MODULE_TO_LOAD.length() > 0 && JRTUtil.MODULE_TO_LOAD.indexOf(path2.toString()) == -1) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return (n & 4) == 0 ? FileVisitResult.CONTINUE : jrtFileVisitor.visitModule(path, JRTUtil.sanitizedFileName(path2));
                }
                if ((n & 2) == 0) {
                    return FileVisitResult.CONTINUE;
                }
                return jrtFileVisitor.visitPackage(path.subpath(2, n2), path.getName(1), basicFileAttributes);
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if ((n & 1) == 0) {
                    return FileVisitResult.CONTINUE;
                }
                int n2 = path.getNameCount();
                if (n2 == 3) {
                    JrtFileSystem.this.cachePackage("", path.getName(1).toString());
                }
                return jrtFileVisitor.visitFile(path.subpath(2, n2), path.getName(1), basicFileAttributes);
            }
        });
    }

    synchronized void cachePackage(String string, String string2) {
        String string3 = this.packageToModule.get(string = string.replace('.', '/'));
        if (string3 == null) {
            this.packageToModule.put(string.intern(), string2.intern());
            return;
        }
        if (string3.equals(string2)) {
            return;
        }
        if (string3 == "MU") {
            List<String> list = this.packageToModules.get(string);
            if (!list.contains(string2)) {
                if (JRTUtil.JAVA_BASE.equals(string2)) {
                    list.add(0, JRTUtil.JAVA_BASE);
                } else {
                    list.add(string2.intern());
                }
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (JRTUtil.JAVA_BASE == string3 || JRTUtil.JAVA_BASE.equals(string3)) {
                arrayList.add(string3.intern());
                arrayList.add(string2.intern());
            } else {
                arrayList.add(string2.intern());
                arrayList.add(string3.intern());
            }
            string = string.intern();
            this.packageToModules.put(string, arrayList);
            this.packageToModule.put(string, "MU");
        }
    }
}

