// Copyright 2014 Altera Corporation. All rights reserved.
// Altera products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Altera Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Altera Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are specifically disclaimed.  By making this reference
// design file available, Altera expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Altera.
/////////////////////////////////////////////////////////////////////////////


`timescale 1ps/1ps

// DESCRIPTION
// Gray pointer clock domain crossing. 5 bits wide.
// Generated by one of Gregg's toys.   Share And Enjoy.

module alt_hiconnect_gpx5 #(
    parameter SIM_CLK_JITTER = 1'b0,
    parameter SIM_EMULATE = 1'b0
) (
    input din_clk,
    input [4:0] din,
    input dout_clk,
    output [4:0] dout
);

// convert to gray
wire [4:0] gry;
alt_hiconnect_gray5t1 g0 (
    .clk(din_clk),
    .din(din),
    .dout(gry)
);
defparam g0 .SIM_EMULATE = SIM_EMULATE;

// cross domains
wire [4:0] gry_s;
generate
if (SIM_CLK_JITTER) begin
    // simulation only option, pretend to have clock jitter
    alt_sync5j sn0 (
        .din_clk(din_clk),
        .din(gry),
        .dout_clk(dout_clk),
        .dout(gry_s)
    );
    defparam sn0 .SIM_EMULATE = SIM_EMULATE;

end else begin
    // regular MLAB synchronizer
    alt_hiconnect_sync5m sn0 (
        .din_clk(din_clk),
        .din(gry),
        .dout_clk(dout_clk),
        .dout(gry_s)
    );
    defparam sn0 .SIM_EMULATE = SIM_EMULATE;

end
endgenerate

// convert back from gray
alt_hiconnect_ungray5t1 g1 (
    .clk(dout_clk),
    .din(gry_s),
    .dout(dout)
);
defparam g1 .SIM_EMULATE = SIM_EMULATE;

endmodule

