
module Repr = struct
  open Caml.Bigarray

  type t = (int64, int64_elt, c_layout) Array1.t

  let of_state : Caml.Random.State.t -> t = Caml.Obj.magic
end

let assign dst src =
  let dst = Repr.of_state (Lazy.force dst) in
  let src = Repr.of_state (Lazy.force src) in
  Caml.Bigarray.Array1.blit src dst

let make_default default =
  let split_from_parent v =
    Caml.Lazy.map_val Caml.Random.State.split v
  in
  Caml.Domain.DLS.new_key ~split_from_parent (fun () -> default)

let get_state random_key = Caml.Domain.DLS.get random_key
