/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;

public class VersionRangeMatcher
extends AbstractVersionMatcher {
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private final Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            object = new MRIDArtifactInfo((ModuleRevisionId)object);
            object2 = new MRIDArtifactInfo((ModuleRevisionId)object2);
            object2 = VersionRangeMatcher.this.getLatestStrategy().findLatest(new ArtifactInfo[]{object, object2}, null);
            if (object2 == object) {
                return -1;
            }
            return 1;
        }
    };
    private LatestStrategy latestStrategy;
    private String latestStrategyName = "default";

    public VersionRangeMatcher() {
        super("version-range");
    }

    @Override
    public boolean isDynamic(ModuleRevisionId object) {
        object = ((ModuleRevisionId)object).getRevision();
        return ALL_RANGE.matcher((CharSequence)object).matches();
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        String string = moduleRevisionId.getRevision();
        Object object = FINITE_RANGE.matcher(string);
        if (((Matcher)object).matches()) {
            String string2 = ((Matcher)object).group(1);
            object = ((Matcher)object).group(2);
            return this.isUpper(moduleRevisionId, string2, moduleRevisionId2, string.startsWith("[")) && this.isLower(moduleRevisionId, (String)object, moduleRevisionId2, string.endsWith("]"));
        }
        object = LOWER_INFINITE_RANGE.matcher(string);
        if (((Matcher)object).matches()) {
            String string3 = ((Matcher)object).group(1);
            return this.isLower(moduleRevisionId, string3, moduleRevisionId2, string.endsWith("]"));
        }
        object = UPPER_INFINITE_RANGE.matcher(string);
        if (((Matcher)object).matches()) {
            String string4 = ((Matcher)object).group(1);
            return this.isUpper(moduleRevisionId, string4, moduleRevisionId2, string.startsWith("["));
        }
        return false;
    }

    private boolean isLower(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        int n = this.comparator.compare(moduleRevisionId = ModuleRevisionId.newInstance(moduleRevisionId, string), moduleRevisionId2);
        return n <= (bl ? 0 : -1);
    }

    private boolean isUpper(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        int n = this.comparator.compare(moduleRevisionId = ModuleRevisionId.newInstance(moduleRevisionId, string), moduleRevisionId2);
        return n >= (bl ? 0 : 1);
    }

    @Override
    public int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        String string = moduleRevisionId.getRevision();
        Matcher matcher = UPPER_INFINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            return 1;
        }
        matcher = FINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            string = matcher.group(2);
        } else {
            matcher = LOWER_INFINITE_RANGE.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1);
            } else {
                throw new IllegalArgumentException("impossible to compare: askedMrid is not a dynamic revision: " + moduleRevisionId);
            }
        }
        int n = comparator.compare(ModuleRevisionId.newInstance(moduleRevisionId, string), moduleRevisionId2);
        if (n == 0) {
            return -1;
        }
        return n;
    }

    public LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            if (this.getSettings() == null) {
                throw new IllegalStateException("no ivy instance nor latest strategy configured in version range matcher " + this);
            }
            if (this.latestStrategyName == null) {
                throw new IllegalStateException("null latest strategy defined in version range matcher " + this);
            }
            this.latestStrategy = this.getSettings().getLatestStrategy(this.latestStrategyName);
            if (this.latestStrategy == null) {
                throw new IllegalStateException("unknown latest strategy '" + this.latestStrategyName + "' configured in version range matcher " + this);
            }
        }
        return this.latestStrategy;
    }

    private final class MRIDArtifactInfo
    implements ArtifactInfo {
        private ModuleRevisionId mrid;

        public MRIDArtifactInfo(ModuleRevisionId moduleRevisionId) {
            this.mrid = moduleRevisionId;
        }

        @Override
        public final long getLastModified() {
            return 0L;
        }

        @Override
        public final String getRevision() {
            return this.mrid.getRevision();
        }
    }
}

