/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.me.qmx.jitescript;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jruby.me.qmx.jitescript.VisibleAnnotation;
import org.jruby.me.qmx.jitescript.util.CodegenUtils;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.tree.FieldInsnNode;
import org.jruby.org.objectweb.asm.tree.FrameNode;
import org.jruby.org.objectweb.asm.tree.IincInsnNode;
import org.jruby.org.objectweb.asm.tree.InsnList;
import org.jruby.org.objectweb.asm.tree.InsnNode;
import org.jruby.org.objectweb.asm.tree.IntInsnNode;
import org.jruby.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jruby.org.objectweb.asm.tree.JumpInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.LdcInsnNode;
import org.jruby.org.objectweb.asm.tree.LineNumberNode;
import org.jruby.org.objectweb.asm.tree.LocalVariableNode;
import org.jruby.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodInsnNode;
import org.jruby.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jruby.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.TypeInsnNode;
import org.jruby.org.objectweb.asm.tree.VarInsnNode;

public class CodeBlock
implements Opcodes {
    private final InsnList instructionList = new InsnList();
    private final List<TryCatchBlockNode> tryCatchBlockList = new ArrayList<TryCatchBlockNode>();
    private final List<LocalVariableNode> localVariableList = new ArrayList<LocalVariableNode>();
    private final List<VisibleAnnotation> annotations = new ArrayList<VisibleAnnotation>();
    private int arity = 0;
    private boolean returns = false;

    public CodeBlock() {
    }

    public CodeBlock(CodeBlock block) {
        this.arity = block.arity();
        this.prepend(block);
    }

    public CodeBlock(int arity2) {
        this.arity = arity2;
    }

    public static CodeBlock newCodeBlock() {
        return new CodeBlock();
    }

    public static CodeBlock newCodeBlock(int arity2) {
        return new CodeBlock(arity2);
    }

    public static CodeBlock newCodeBlock(CodeBlock block) {
        return new CodeBlock(block);
    }

    public CodeBlock aloadMany(int ... indices) {
        for (int index2 : indices) {
            this.aload(index2);
        }
        return this;
    }

    public CodeBlock aload(int index2) {
        this.instructionList.add(new VarInsnNode(25, index2));
        return this;
    }

    public CodeBlock iload(int index2) {
        this.instructionList.add(new VarInsnNode(21, index2));
        return this;
    }

    public CodeBlock lload(int index2) {
        this.instructionList.add(new VarInsnNode(22, index2));
        return this;
    }

    public CodeBlock fload(int index2) {
        this.instructionList.add(new VarInsnNode(23, index2));
        return this;
    }

    public CodeBlock dload(int index2) {
        this.instructionList.add(new VarInsnNode(24, index2));
        return this;
    }

    public CodeBlock astore(int index2) {
        this.instructionList.add(new VarInsnNode(58, index2));
        return this;
    }

    public CodeBlock istore(int index2) {
        this.instructionList.add(new VarInsnNode(54, index2));
        return this;
    }

    public CodeBlock lstore(int index2) {
        this.instructionList.add(new VarInsnNode(55, index2));
        return this;
    }

    public CodeBlock fstore(int index2) {
        this.instructionList.add(new VarInsnNode(56, index2));
        return this;
    }

    public CodeBlock dstore(int index2) {
        this.instructionList.add(new VarInsnNode(57, index2));
        return this;
    }

    public CodeBlock ldc(Object value2) {
        this.instructionList.add(new LdcInsnNode(value2));
        return this;
    }

    public CodeBlock bipush(int byteValue) {
        this.instructionList.add(new IntInsnNode(16, byteValue));
        return this;
    }

    public CodeBlock sipush(int shortValue) {
        this.instructionList.add(new IntInsnNode(17, shortValue));
        return this;
    }

    public CodeBlock pushInt(int value2) {
        if (value2 <= 127 && value2 >= -128) {
            switch (value2) {
                case -1: {
                    this.iconst_m1();
                    break;
                }
                case 0: {
                    this.iconst_0();
                    break;
                }
                case 1: {
                    this.iconst_1();
                    break;
                }
                case 2: {
                    this.iconst_2();
                    break;
                }
                case 3: {
                    this.iconst_3();
                    break;
                }
                case 4: {
                    this.iconst_4();
                    break;
                }
                case 5: {
                    this.iconst_5();
                    break;
                }
                default: {
                    this.bipush(value2);
                    break;
                }
            }
        } else if (value2 <= Short.MAX_VALUE && value2 >= Short.MIN_VALUE) {
            this.sipush(value2);
        } else {
            this.ldc(value2);
        }
        return this;
    }

    public CodeBlock pushBoolean(boolean bool2) {
        if (bool2) {
            this.iconst_1();
        } else {
            this.iconst_0();
        }
        return this;
    }

    public CodeBlock invokestatic(String className, String methodName, String methodDesc) {
        this.instructionList.add(new MethodInsnNode(184, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokespecial(String className, String methodName, String methodDesc) {
        this.instructionList.add(new MethodInsnNode(183, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokevirtual(String className, String methodName, String methodDesc) {
        this.instructionList.add(new MethodInsnNode(182, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokeinterface(String className, String methodName, String methodDesc) {
        this.instructionList.add(new MethodInsnNode(185, className, methodName, methodDesc, true));
        return this;
    }

    public CodeBlock invokedynamic(String name2, String descriptor, Handle bootstrapMethod, Object ... bootstrapArguments) {
        this.instructionList.add(new InvokeDynamicInsnNode(name2, descriptor, bootstrapMethod, bootstrapArguments));
        return this;
    }

    public CodeBlock aprintln() {
        this.dup();
        this.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.swap();
        this.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        return this;
    }

    public CodeBlock iprintln() {
        this.dup();
        this.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.swap();
        this.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
        return this;
    }

    public CodeBlock areturn() {
        this.returns = true;
        this.instructionList.add(new InsnNode(176));
        return this;
    }

    public CodeBlock ireturn() {
        this.instructionList.add(new InsnNode(172));
        return this;
    }

    public CodeBlock freturn() {
        this.instructionList.add(new InsnNode(174));
        return this;
    }

    public CodeBlock lreturn() {
        this.instructionList.add(new InsnNode(173));
        return this;
    }

    public CodeBlock dreturn() {
        this.instructionList.add(new InsnNode(175));
        return this;
    }

    public CodeBlock newobj(String desc) {
        this.instructionList.add(new TypeInsnNode(187, desc));
        return this;
    }

    public CodeBlock dup() {
        this.instructionList.add(new InsnNode(89));
        return this;
    }

    public CodeBlock swap() {
        this.instructionList.add(new InsnNode(95));
        return this;
    }

    public CodeBlock swap2() {
        this.dup2_x2();
        this.pop2();
        return this;
    }

    public CodeBlock getstatic(String className, String fieldName, String fieldDesc) {
        this.instructionList.add(new FieldInsnNode(178, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock putstatic(String className, String fieldName, String fieldDesc) {
        this.instructionList.add(new FieldInsnNode(179, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock getfield(String className, String fieldName, String fieldDesc) {
        this.instructionList.add(new FieldInsnNode(180, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock putfield(String className, String fieldName, String fieldDesc) {
        this.instructionList.add(new FieldInsnNode(181, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock voidreturn() {
        this.instructionList.add(new InsnNode(177));
        return this;
    }

    public CodeBlock anewarray(String arrayDesc) {
        this.instructionList.add(new TypeInsnNode(189, arrayDesc));
        return this;
    }

    public CodeBlock multianewarray(String arrayDesc, int dims) {
        this.instructionList.add(new MultiANewArrayInsnNode(arrayDesc, dims));
        return this;
    }

    public CodeBlock newarray(int size2) {
        this.instructionList.add(new IntInsnNode(188, size2));
        return this;
    }

    public CodeBlock iconst_m1() {
        this.instructionList.add(new InsnNode(2));
        return this;
    }

    public CodeBlock iconst_0() {
        this.instructionList.add(new InsnNode(3));
        return this;
    }

    public CodeBlock iconst_1() {
        this.instructionList.add(new InsnNode(4));
        return this;
    }

    public CodeBlock iconst_2() {
        this.instructionList.add(new InsnNode(5));
        return this;
    }

    public CodeBlock iconst_3() {
        this.instructionList.add(new InsnNode(6));
        return this;
    }

    public CodeBlock iconst_4() {
        this.instructionList.add(new InsnNode(7));
        return this;
    }

    public CodeBlock iconst_5() {
        this.instructionList.add(new InsnNode(8));
        return this;
    }

    public CodeBlock lconst_0() {
        this.instructionList.add(new InsnNode(9));
        return this;
    }

    public CodeBlock aconst_null() {
        this.instructionList.add(new InsnNode(1));
        return this;
    }

    public CodeBlock label(LabelNode labelNode) {
        this.instructionList.add(labelNode);
        return this;
    }

    public CodeBlock nop() {
        this.instructionList.add(new InsnNode(0));
        return this;
    }

    public CodeBlock pop() {
        this.instructionList.add(new InsnNode(87));
        return this;
    }

    public CodeBlock pop2() {
        this.instructionList.add(new InsnNode(88));
        return this;
    }

    public CodeBlock arrayload() {
        this.instructionList.add(new InsnNode(50));
        return this;
    }

    public CodeBlock arraystore() {
        this.instructionList.add(new InsnNode(83));
        return this;
    }

    public CodeBlock iarrayload() {
        this.instructionList.add(new InsnNode(46));
        return this;
    }

    public CodeBlock barrayload() {
        this.instructionList.add(new InsnNode(51));
        return this;
    }

    public CodeBlock barraystore() {
        this.instructionList.add(new InsnNode(84));
        return this;
    }

    public CodeBlock aaload() {
        this.instructionList.add(new InsnNode(50));
        return this;
    }

    public CodeBlock aastore() {
        this.instructionList.add(new InsnNode(83));
        return this;
    }

    public CodeBlock iaload() {
        this.instructionList.add(new InsnNode(46));
        return this;
    }

    public CodeBlock iastore() {
        this.instructionList.add(new InsnNode(79));
        return this;
    }

    public CodeBlock laload() {
        this.instructionList.add(new InsnNode(47));
        return this;
    }

    public CodeBlock lastore() {
        this.instructionList.add(new InsnNode(80));
        return this;
    }

    public CodeBlock baload() {
        this.instructionList.add(new InsnNode(51));
        return this;
    }

    public CodeBlock bastore() {
        this.instructionList.add(new InsnNode(84));
        return this;
    }

    public CodeBlock saload() {
        this.instructionList.add(new InsnNode(53));
        return this;
    }

    public CodeBlock sastore() {
        this.instructionList.add(new InsnNode(86));
        return this;
    }

    public CodeBlock caload() {
        this.instructionList.add(new InsnNode(52));
        return this;
    }

    public CodeBlock castore() {
        this.instructionList.add(new InsnNode(85));
        return this;
    }

    public CodeBlock faload() {
        this.instructionList.add(new InsnNode(48));
        return this;
    }

    public CodeBlock fastore() {
        this.instructionList.add(new InsnNode(81));
        return this;
    }

    public CodeBlock daload() {
        this.instructionList.add(new InsnNode(49));
        return this;
    }

    public CodeBlock dastore() {
        this.instructionList.add(new InsnNode(82));
        return this;
    }

    public CodeBlock fcmpl() {
        this.instructionList.add(new InsnNode(149));
        return this;
    }

    public CodeBlock fcmpg() {
        this.instructionList.add(new InsnNode(150));
        return this;
    }

    public CodeBlock dcmpl() {
        this.instructionList.add(new InsnNode(151));
        return this;
    }

    public CodeBlock dcmpg() {
        this.instructionList.add(new InsnNode(152));
        return this;
    }

    public CodeBlock dup_x2() {
        this.instructionList.add(new InsnNode(91));
        return this;
    }

    public CodeBlock dup_x1() {
        this.instructionList.add(new InsnNode(90));
        return this;
    }

    public CodeBlock dup2_x2() {
        this.instructionList.add(new InsnNode(94));
        return this;
    }

    public CodeBlock dup2_x1() {
        this.instructionList.add(new InsnNode(93));
        return this;
    }

    public CodeBlock dup2() {
        this.instructionList.add(new InsnNode(92));
        return this;
    }

    public CodeBlock trycatch(LabelNode scopeStart, LabelNode scopeEnd, LabelNode handler, String exceptionType) {
        this.tryCatchBlockList.add(new TryCatchBlockNode(scopeStart, scopeEnd, handler, exceptionType));
        return this;
    }

    public CodeBlock trycatch(String exceptionType, Runnable body, Runnable catchBody) {
        LabelNode before = new LabelNode();
        LabelNode after = new LabelNode();
        LabelNode catchStart = new LabelNode();
        LabelNode done = new LabelNode();
        this.trycatch(before, after, catchStart, exceptionType);
        this.label(before);
        body.run();
        this.label(after);
        this.go_to(done);
        if (catchBody != null) {
            this.label(catchStart);
            catchBody.run();
        }
        this.label(done);
        return this;
    }

    public CodeBlock go_to(LabelNode label2) {
        this.instructionList.add(new JumpInsnNode(167, label2));
        return this;
    }

    public CodeBlock lookupswitch(LabelNode defaultHandler, int[] keys2, LabelNode[] handlers) {
        this.instructionList.add(new LookupSwitchInsnNode(defaultHandler, keys2, handlers));
        return this;
    }

    public CodeBlock athrow() {
        this.instructionList.add(new InsnNode(191));
        return this;
    }

    public CodeBlock instance_of(String typeDesc) {
        this.instructionList.add(new TypeInsnNode(193, typeDesc));
        return this;
    }

    public CodeBlock ifeq(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(153, jumpLabel));
        return this;
    }

    public CodeBlock iffalse(LabelNode jumpLabel) {
        this.ifeq(jumpLabel);
        return this;
    }

    public CodeBlock ifne(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(154, jumpLabel));
        return this;
    }

    public CodeBlock iftrue(LabelNode jumpLabel) {
        this.ifne(jumpLabel);
        return this;
    }

    public CodeBlock if_acmpne(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(166, jumpLabel));
        return this;
    }

    public CodeBlock if_acmpeq(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(165, jumpLabel));
        return this;
    }

    public CodeBlock if_icmple(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(164, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpgt(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(163, jumpLabel));
        return this;
    }

    public CodeBlock if_icmplt(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(161, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpne(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(160, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpeq(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(159, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpge(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(162, jumpLabel));
        return this;
    }

    public CodeBlock checkcast(String typeDesc) {
        this.instructionList.add(new TypeInsnNode(192, typeDesc));
        return this;
    }

    public CodeBlock line(int line) {
        this.visitLineNumber(line, new LabelNode());
        return this;
    }

    public CodeBlock line(int line, LabelNode label2) {
        this.visitLineNumber(line, label2);
        return this;
    }

    public CodeBlock ifnonnull(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(199, jumpLabel));
        return this;
    }

    public CodeBlock ifnull(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(198, jumpLabel));
        return this;
    }

    public CodeBlock iflt(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(155, jumpLabel));
        return this;
    }

    public CodeBlock ifle(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(158, jumpLabel));
        return this;
    }

    public CodeBlock ifgt(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(157, jumpLabel));
        return this;
    }

    public CodeBlock ifge(LabelNode jumpLabel) {
        this.instructionList.add(new JumpInsnNode(156, jumpLabel));
        return this;
    }

    public CodeBlock arraylength() {
        this.instructionList.add(new InsnNode(190));
        return this;
    }

    public CodeBlock ishr() {
        this.instructionList.add(new InsnNode(122));
        return this;
    }

    public CodeBlock ishl() {
        this.instructionList.add(new InsnNode(120));
        return this;
    }

    public CodeBlock iushr() {
        this.instructionList.add(new InsnNode(124));
        return this;
    }

    public CodeBlock lshr() {
        this.instructionList.add(new InsnNode(123));
        return this;
    }

    public CodeBlock lshl() {
        this.instructionList.add(new InsnNode(121));
        return this;
    }

    public CodeBlock lushr() {
        this.instructionList.add(new InsnNode(125));
        return this;
    }

    public CodeBlock lcmp() {
        this.instructionList.add(new InsnNode(148));
        return this;
    }

    public CodeBlock iand() {
        this.instructionList.add(new InsnNode(126));
        return this;
    }

    public CodeBlock ior() {
        this.instructionList.add(new InsnNode(128));
        return this;
    }

    public CodeBlock ixor() {
        this.instructionList.add(new InsnNode(130));
        return this;
    }

    public CodeBlock land() {
        this.instructionList.add(new InsnNode(127));
        return this;
    }

    public CodeBlock lor() {
        this.instructionList.add(new InsnNode(129));
        return this;
    }

    public CodeBlock lxor() {
        this.instructionList.add(new InsnNode(131));
        return this;
    }

    public CodeBlock iadd() {
        this.instructionList.add(new InsnNode(96));
        return this;
    }

    public CodeBlock ladd() {
        this.instructionList.add(new InsnNode(97));
        return this;
    }

    public CodeBlock fadd() {
        this.instructionList.add(new InsnNode(98));
        return this;
    }

    public CodeBlock dadd() {
        this.instructionList.add(new InsnNode(99));
        return this;
    }

    public CodeBlock isub() {
        this.instructionList.add(new InsnNode(100));
        return this;
    }

    public CodeBlock lsub() {
        this.instructionList.add(new InsnNode(101));
        return this;
    }

    public CodeBlock fsub() {
        this.instructionList.add(new InsnNode(102));
        return this;
    }

    public CodeBlock dsub() {
        this.instructionList.add(new InsnNode(103));
        return this;
    }

    public CodeBlock idiv() {
        this.instructionList.add(new InsnNode(108));
        return this;
    }

    public CodeBlock irem() {
        this.instructionList.add(new InsnNode(112));
        return this;
    }

    public CodeBlock ineg() {
        this.instructionList.add(new InsnNode(116));
        return this;
    }

    public CodeBlock i2d() {
        this.instructionList.add(new InsnNode(135));
        return this;
    }

    public CodeBlock i2l() {
        this.instructionList.add(new InsnNode(133));
        return this;
    }

    public CodeBlock i2f() {
        this.instructionList.add(new InsnNode(134));
        return this;
    }

    public CodeBlock i2s() {
        this.instructionList.add(new InsnNode(147));
        return this;
    }

    public CodeBlock i2c() {
        this.instructionList.add(new InsnNode(146));
        return this;
    }

    public CodeBlock i2b() {
        this.instructionList.add(new InsnNode(145));
        return this;
    }

    public CodeBlock ldiv() {
        this.instructionList.add(new InsnNode(109));
        return this;
    }

    public CodeBlock lrem() {
        this.instructionList.add(new InsnNode(113));
        return this;
    }

    public CodeBlock lneg() {
        this.instructionList.add(new InsnNode(117));
        return this;
    }

    public CodeBlock l2d() {
        this.instructionList.add(new InsnNode(138));
        return this;
    }

    public CodeBlock l2i() {
        this.instructionList.add(new InsnNode(136));
        return this;
    }

    public CodeBlock l2f() {
        this.instructionList.add(new InsnNode(137));
        return this;
    }

    public CodeBlock fdiv() {
        this.instructionList.add(new InsnNode(110));
        return this;
    }

    public CodeBlock frem() {
        this.instructionList.add(new InsnNode(114));
        return this;
    }

    public CodeBlock fneg() {
        this.instructionList.add(new InsnNode(118));
        return this;
    }

    public CodeBlock f2d() {
        this.instructionList.add(new InsnNode(141));
        return this;
    }

    public CodeBlock f2i() {
        this.instructionList.add(new InsnNode(141));
        return this;
    }

    public CodeBlock f2l() {
        this.instructionList.add(new InsnNode(140));
        return this;
    }

    public CodeBlock ddiv() {
        this.instructionList.add(new InsnNode(111));
        return this;
    }

    public CodeBlock drem() {
        this.instructionList.add(new InsnNode(115));
        return this;
    }

    public CodeBlock dneg() {
        this.instructionList.add(new InsnNode(119));
        return this;
    }

    public CodeBlock d2f() {
        this.instructionList.add(new InsnNode(144));
        return this;
    }

    public CodeBlock d2i() {
        this.instructionList.add(new InsnNode(142));
        return this;
    }

    public CodeBlock d2l() {
        this.instructionList.add(new InsnNode(143));
        return this;
    }

    public CodeBlock imul() {
        this.instructionList.add(new InsnNode(104));
        return this;
    }

    public CodeBlock lmul() {
        this.instructionList.add(new InsnNode(105));
        return this;
    }

    public CodeBlock fmul() {
        this.instructionList.add(new InsnNode(106));
        return this;
    }

    public CodeBlock dmul() {
        this.instructionList.add(new InsnNode(107));
        return this;
    }

    public CodeBlock iinc(int varIndex, int increment) {
        this.instructionList.add(new IincInsnNode(varIndex, increment));
        return this;
    }

    public CodeBlock monitorenter() {
        this.instructionList.add(new InsnNode(194));
        return this;
    }

    public CodeBlock monitorexit() {
        this.instructionList.add(new InsnNode(195));
        return this;
    }

    public CodeBlock jsr(LabelNode branch) {
        this.instructionList.add(new JumpInsnNode(168, branch));
        return this;
    }

    public CodeBlock ret(int value2) {
        this.instructionList.add(new IntInsnNode(169, value2));
        return this;
    }

    public CodeBlock visitInsn(int opcode) {
        this.instructionList.add(new InsnNode(opcode));
        return this;
    }

    public CodeBlock visitIntInsn(int opcode, int operand) {
        this.instructionList.add(new IntInsnNode(opcode, operand));
        return this;
    }

    public CodeBlock visitInsnNode(int opcode, int operand) {
        this.instructionList.add(new IntInsnNode(opcode, operand));
        return this;
    }

    public CodeBlock visitTypeInsn(int opcode, String desc) {
        this.instructionList.add(new TypeInsnNode(opcode, desc));
        return this;
    }

    public CodeBlock visitFieldInsn(int opcode, String className, String fieldName, String fieldDesc) {
        this.instructionList.add(new FieldInsnNode(opcode, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock visitMethodInsn(int opcode, String className, String methodName, String methodDesc) {
        boolean intf = opcode == 185;
        this.instructionList.add(new MethodInsnNode(opcode, className, methodName, methodDesc, intf));
        return this;
    }

    public CodeBlock visitInvokeDynamicInsn(String name2, String desc, Handle bootstrapMethod, Object ... bootstrapArguments) {
        this.instructionList.add(new InvokeDynamicInsnNode(name2, desc, bootstrapMethod, bootstrapArguments));
        return this;
    }

    public CodeBlock visitJumpInsn(int opcode, LabelNode node) {
        this.instructionList.add(new JumpInsnNode(opcode, node));
        return this;
    }

    public CodeBlock visitLabel(Label label2) {
        this.instructionList.add(new LabelNode(label2));
        return this;
    }

    public CodeBlock visitLdcInsn(Object value2) {
        this.instructionList.add(new LdcInsnNode(value2));
        return this;
    }

    public CodeBlock visitIincInsn(int varIndex, int increment) {
        this.instructionList.add(new IincInsnNode(varIndex, increment));
        return this;
    }

    public CodeBlock visitTableSwitchInsn(int min2, int max2, LabelNode defaultHandler, LabelNode[] handlers) {
        this.instructionList.add(new TableSwitchInsnNode(min2, max2, defaultHandler, handlers));
        return this;
    }

    public CodeBlock visitLookupSwitchInsn(LabelNode defaultHandler, int[] keys2, LabelNode[] handlers) {
        this.instructionList.add(new LookupSwitchInsnNode(defaultHandler, keys2, handlers));
        return this;
    }

    public CodeBlock visitMultiANewArrayInsn(String desc, int dims) {
        this.instructionList.add(new MultiANewArrayInsnNode(desc, dims));
        return this;
    }

    public CodeBlock visitTryCatchBlock(LabelNode scopeStart, LabelNode scopeEnd, LabelNode handler, String exceptionType) {
        this.tryCatchBlockList.add(new TryCatchBlockNode(scopeStart, scopeEnd, handler, exceptionType));
        return this;
    }

    public CodeBlock visitLocalVariable(String varName, String varDesc, String signature, LabelNode scopeStart, LabelNode scopeEnd, int varIndex) {
        this.localVariableList.add(new LocalVariableNode(varName, varDesc, signature, scopeStart, scopeEnd, varIndex));
        return this;
    }

    public CodeBlock visitLineNumber(int lineNumber, LabelNode start2) {
        this.instructionList.add(new LineNumberNode(lineNumber, start2));
        return this;
    }

    public CodeBlock tableswitch(int min2, int max2, LabelNode defaultLabel, LabelNode[] cases) {
        this.instructionList.add(new TableSwitchInsnNode(min2, max2, defaultLabel, cases));
        return this;
    }

    public CodeBlock visitFrame(int opcode, int nrLocals, Object[] localTypes, int nrStackElements, Object[] stackElements) {
        this.instructionList.add(new FrameNode(opcode, nrLocals, localTypes, nrStackElements, stackElements));
        return this;
    }

    public InsnList getInstructionList() {
        return this.instructionList;
    }

    public List<TryCatchBlockNode> getTryCatchBlockList() {
        return this.tryCatchBlockList;
    }

    public List<LocalVariableNode> getLocalVariableList() {
        return this.localVariableList;
    }

    public List<VisibleAnnotation> getAnnotations() {
        return this.annotations;
    }

    public CodeBlock frame_same(Object ... stackArguments) {
        int type2;
        switch (stackArguments.length) {
            case 0: {
                type2 = 3;
                break;
            }
            case 1: {
                type2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("same frame should have 0 or 1 arguments on stack");
            }
        }
        this.instructionList.add(new FrameNode(type2, 0, null, stackArguments.length, stackArguments));
        return this;
    }

    public CodeBlock prepend(CodeBlock codeBlock) {
        if (codeBlock.returns()) {
            this.returns = true;
        }
        this.annotations.addAll(codeBlock.annotations);
        this.instructionList.insert(codeBlock.instructionList);
        return this;
    }

    public CodeBlock append(CodeBlock codeBlock) {
        if (codeBlock.returns()) {
            this.returns = true;
        }
        this.instructionList.add(codeBlock.instructionList);
        this.tryCatchBlockList.addAll(codeBlock.tryCatchBlockList);
        this.annotations.addAll(codeBlock.annotations);
        return this;
    }

    public VisibleAnnotation annotation(Class<?> type2) {
        VisibleAnnotation annotation = new VisibleAnnotation(CodegenUtils.ci(type2));
        this.addAnnotation(annotation);
        return annotation;
    }

    public CodeBlock addAnnotation(VisibleAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public CodeBlock addAll(InsnList insnList) {
        this.instructionList.add(insnList);
        return this;
    }

    public int arity() {
        return this.arity;
    }

    public boolean returns() {
        return this.returns;
    }
}

